/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.graph;

import de.grogra.graph.Attribute;
import de.grogra.graph.AttributeChangeListener;
import de.grogra.graph.ChangeBoundaryListener;
import de.grogra.graph.EdgeChangeListener;
import de.grogra.graph.EventSupport;
import de.grogra.graph.Graph;
import de.grogra.graph.GraphState;
import de.grogra.reflect.FieldChain;
import de.grogra.util.Lock;
import de.grogra.util.LockProtectedRunnable;
import de.grogra.util.Lockable;
import de.grogra.util.ThreadContext;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class GraphBase
implements Graph {
    private final Lockable lockable;
    EventSupport support;
    State mainState;
    private final IdentityHashMap stateMap = new IdentityHashMap();
    int writeLockCount;

    public GraphBase(Lockable lockable) {
        this.lockable = lockable;
    }

    protected void init() {
        this.support = new EventSupport(this.createObjectMap());
        this.mainState = this.createMainState();
    }

    protected abstract State createMainState();

    public GraphState getMainState() {
        return this.mainState;
    }

    public void addChangeBoundaryListener(ChangeBoundaryListener changeBoundaryListener) {
        this.support.addChangeBoundaryListener(changeBoundaryListener);
    }

    public void removeChangeBoundaryListener(ChangeBoundaryListener changeBoundaryListener) {
        this.support.removeChangeBoundaryListener(changeBoundaryListener);
    }

    public void addAttributeChangeListener(AttributeChangeListener attributeChangeListener) {
        this.support.addAttributeChangeListener(attributeChangeListener);
    }

    public void addEdgeChangeListener(EdgeChangeListener edgeChangeListener) {
        this.support.addEdgeChangeListener(edgeChangeListener);
    }

    public void removeAttributeChangeListener(AttributeChangeListener attributeChangeListener) {
        this.support.removeAttributeChangeListener(attributeChangeListener);
    }

    public void removeEdgeChangeListener(EdgeChangeListener edgeChangeListener) {
        this.support.removeEdgeChangeListener(edgeChangeListener);
    }

    public void addAttributeChangeListener(Object object, boolean bl, AttributeChangeListener attributeChangeListener) {
        this.support.addAttributeChangeListener(object, bl, attributeChangeListener);
    }

    public void removeAttributeChangeListener(Object object, boolean bl, AttributeChangeListener attributeChangeListener) {
        this.support.removeAttributeChangeListener(object, bl, attributeChangeListener);
    }

    public void addEdgeChangeListener(Object object, boolean bl, EdgeChangeListener edgeChangeListener) {
        this.support.addEdgeChangeListener(object, bl, edgeChangeListener);
    }

    public void removeEdgeChangeListener(Object object, boolean bl, EdgeChangeListener edgeChangeListener) {
        this.support.removeEdgeChangeListener(object, bl, edgeChangeListener);
    }

    public void execute(LockProtectedRunnable lockProtectedRunnable, boolean bl) {
        this.lockable.execute((LockProtectedRunnable)new TaskWrapper(lockProtectedRunnable), bl);
    }

    public void execute(LockProtectedRunnable lockProtectedRunnable, Lock lock) {
        this.lockable.execute((LockProtectedRunnable)new TaskWrapper(lockProtectedRunnable), lock);
    }

    public void executeForcedly(LockProtectedRunnable lockProtectedRunnable, boolean bl) throws InterruptedException, Lockable.DeadLockException {
        this.lockable.executeForcedly((LockProtectedRunnable)new TaskWrapper(lockProtectedRunnable), bl);
    }

    public void executeForcedly(LockProtectedRunnable lockProtectedRunnable, Lock lock) throws InterruptedException {
        this.lockable.executeForcedly((LockProtectedRunnable)new TaskWrapper(lockProtectedRunnable), lock);
    }

    public boolean isLocked(boolean bl) {
        return this.lockable.isLocked(bl);
    }

    public int getQueueLength() {
        return this.lockable.getQueueLength();
    }

    public long getMaxWaitingTime() {
        return this.lockable.getMaxWaitingTime();
    }

    public Map getStateMap() {
        return this.stateMap;
    }

    private final class TaskWrapper
    implements LockProtectedRunnable {
        final LockProtectedRunnable task;

        TaskWrapper(LockProtectedRunnable lockProtectedRunnable) {
            this.task = lockProtectedRunnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(boolean bl, Lock lock) {
            boolean bl2 = lock.isWriteLock() && GraphBase.this.mainState.getContext().isCurrent();
            try {
                if (bl2 && ++GraphBase.this.writeLockCount == 1) {
                    GraphBase.this.mainState.getQueue().clear();
                }
                this.task.run(bl, lock);
            }
            finally {
                if (bl2 && --GraphBase.this.writeLockCount == 0) {
                    while (!GraphBase.this.mainState.getQueue().isEmpty()) {
                        GraphBase.this.mainState.getQueue().fire(GraphBase.this.mainState, true);
                    }
                }
            }
        }
    }

    protected abstract class State
    extends GraphState {
        private final EventSupport.Queue queue;

        public State(ThreadContext threadContext) {
            this.initialize(GraphBase.this, threadContext);
            this.queue = GraphBase.this.support.new EventSupport.Queue();
        }

        public void fireAttributeChanged(Object object, boolean bl, Attribute attribute, FieldChain fieldChain, int[] nArray) {
            this.queue.postAttributeChanged(object, bl, attribute, fieldChain, nArray);
        }

        protected void fireEdgeChanged(Object object, Object object2, Object object3) {
            this.queue.postEdgeChanged(object, object2, object3);
        }

        public EventSupport.Queue getQueue() {
            return this.queue;
        }
    }
}

