/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.graph.impl;

import de.grogra.graph.impl.Node;
import de.grogra.reflect.Type;
import java.io.PrintWriter;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Extent {
    private final Type type;
    private final Object lock;
    private final Extent superExtent;
    private Extent subExtents;
    private final Extent next;
    private Node[] first = new Node[8];
    private int size;
    private int totalSize;

    Extent(Object object, Type type, Extent extent) {
        this.lock = object;
        this.type = type;
        this.superExtent = extent;
        if (extent == null) {
            this.next = null;
        } else {
            this.next = extent.subExtents;
            extent.subExtents = this;
        }
    }

    public Type getType() {
        return this.type;
    }

    public int size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int totalSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.totalSize >= 0 ? this.totalSize : this.totalSizeImpl();
        }
    }

    public Node getFirstNode(int n) {
        return this.first[n];
    }

    public Node getNextNode(Node node) {
        return node.extentNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSubExtents(Collection<? super Extent> collection) {
        Object object = this.lock;
        synchronized (object) {
            Extent extent = this.subExtents;
            while (extent != null) {
                collection.add(extent);
                extent = extent.next;
            }
        }
    }

    private int totalSizeImpl() {
        if (this.totalSize < 0) {
            int n = 0;
            Extent extent = this.subExtents;
            while (extent != null) {
                n += extent.totalSizeImpl();
                extent = extent.next;
            }
            this.totalSize = n + this.size;
        }
        return this.totalSize;
    }

    void add(Node node) {
        assert (node.id >= 0L && node.extentNext == null && node.extentPrev == null);
        int n = node.getExtentIndex();
        if (this.first[n] == null) {
            this.first[n] = node;
        } else {
            this.first[n].extentPrev = node;
            node.extentNext = this.first[n];
            this.first[n] = node;
        }
        ++this.size;
        if (this.totalSize >= 0) {
            ++this.totalSize;
            Extent extent = this.superExtent;
            while (extent != null && extent.totalSize >= 0) {
                extent.totalSize = -1;
                extent = extent.superExtent;
            }
        }
    }

    void remove(Node node) {
        block7: {
            if (node.extentPrev != null) {
                node.extentPrev.extentNext = node.extentNext;
            } else {
                for (int i = 0; i <= 7; ++i) {
                    if (this.first[i] != node) continue;
                    this.first[i] = node.extentNext;
                    break block7;
                }
                if (node.extentNext != null) {
                    throw new AssertionError();
                }
            }
        }
        if (node.extentNext != null) {
            node.extentNext.extentPrev = node.extentPrev;
        }
        node.extentNext = null;
        node.extentPrev = null;
        --this.size;
        if (this.totalSize >= 0) {
            --this.totalSize;
            Extent extent = this.superExtent;
            while (extent != null && extent.totalSize >= 0) {
                extent.totalSize = -1;
                extent = extent.superExtent;
            }
        }
    }

    void reenqueue(Node node) {
        this.remove(node);
        this.add(node);
    }

    void clear() {
        for (int i = 0; i <= 7; ++i) {
            Node node = this.first[i];
            while (node != null) {
                Node node2 = node.extentNext;
                node.extentNext = null;
                node.extentPrev = null;
                node = node2;
            }
            this.first[i] = null;
        }
        this.size = 0;
        this.totalSize = -1;
        Extent extent = this.subExtents;
        while (extent != null) {
            extent.clear();
            extent = extent.next;
        }
    }

    void dump(String string, boolean bl) {
        System.err.print(string);
        System.err.println(this);
        for (int i = 0; i <= 7; ++i) {
            Node node = this.first[i];
            while (node != null) {
                System.err.print(string);
                System.err.print("    ");
                System.err.println(node);
                node = node.extentNext;
            }
        }
        if (bl) {
            Extent extent = this.subExtents;
            while (extent != null) {
                extent.dump(string + "  ", true);
                extent = extent.next;
            }
        }
    }

    void dumpAll() {
        this.dump("", true);
    }

    public String toString() {
        return "Extent[type=" + this.type.getBinaryName() + ",size=" + this.size + ']';
    }

    void dumpStatistics(PrintWriter printWriter, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            printWriter.print(' ');
        }
        printWriter.print(this.type.getBinaryName());
        printWriter.print('[');
        printWriter.print(this.size);
        printWriter.print(" nodes = ");
        printWriter.print((float)this.size * 100.0f / (float)n);
        printWriter.print(" %, ");
        printWriter.print(this.totalSize());
        printWriter.print(" total = ");
        printWriter.print((float)this.totalSize() * 100.0f / (float)n);
        printWriter.println(" %]");
        Extent extent = this.subExtents;
        while (extent != null) {
            extent.dumpStatistics(printWriter, n, n2 + 1);
            extent = extent.next;
        }
    }
}

