/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.graph.impl;

import de.grogra.graph.ArrayPath;
import de.grogra.graph.Attribute;
import de.grogra.graph.AttributeAccessor;
import de.grogra.graph.AttributeChangeListener;
import de.grogra.graph.BooleanMap;
import de.grogra.graph.ChangeBoundaryListener;
import de.grogra.graph.EdgeChangeListener;
import de.grogra.graph.EdgePattern;
import de.grogra.graph.EdgePatternImpl;
import de.grogra.graph.EventSupport;
import de.grogra.graph.Graph;
import de.grogra.graph.GraphState;
import de.grogra.graph.Instantiator;
import de.grogra.graph.ObjectAttribute;
import de.grogra.graph.ObjectMap;
import de.grogra.graph.ParentAttribute;
import de.grogra.graph.SpecialEdgeDescriptor;
import de.grogra.graph.Visitor;
import de.grogra.graph.impl.Edge;
import de.grogra.graph.impl.EdgeImpl;
import de.grogra.graph.impl.Extent;
import de.grogra.graph.impl.GraphOutput;
import de.grogra.graph.impl.GraphOutputStream;
import de.grogra.graph.impl.GraphTransaction;
import de.grogra.graph.impl.GraphXAApplier;
import de.grogra.graph.impl.Node;
import de.grogra.graph.impl.PlaceholderNode;
import de.grogra.graph.impl.SharedObjectNode;
import de.grogra.graph.impl.State;
import de.grogra.persistence.FatalPersistenceException;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.PersistenceCapable;
import de.grogra.persistence.PersistenceConnection;
import de.grogra.persistence.PersistenceInput;
import de.grogra.persistence.PersistenceInputStream;
import de.grogra.persistence.PersistenceManager;
import de.grogra.persistence.PersistenceOutput;
import de.grogra.persistence.PersistenceOutputStream;
import de.grogra.persistence.ResolvableReference;
import de.grogra.persistence.SOReferenceImpl;
import de.grogra.persistence.ServerConnection;
import de.grogra.persistence.Shareable;
import de.grogra.persistence.SharedObjectProvider;
import de.grogra.persistence.Transaction;
import de.grogra.persistence.TransactionApplier;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.reflect.TypeDecorator;
import de.grogra.reflect.XClass;
import de.grogra.util.I18NBundle;
import de.grogra.util.Lock;
import de.grogra.util.LockProtectedRunnable;
import de.grogra.util.Lockable;
import de.grogra.util.StringMap;
import de.grogra.util.ThreadContext;
import de.grogra.util.Utils;
import de.grogra.xl.util.IntList;
import de.grogra.xl.util.LongToIntHashMap;
import de.grogra.xl.util.ObjectList;
import de.grogra.xl.util.XBitSet;
import de.grogra.xl.util.XHashMap;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StreamCorruptedException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphManager
extends PersistenceManager
implements Graph,
SharedObjectProvider {
    public static final I18NBundle I18N = I18NBundle.getInstance(GraphManager.class);
    public static final String META_GRAPH = "MetaGraph";
    public static final GraphManager STATIC = new GraphManager(new ServerConnection(null), null, false, false);
    public static final GraphState STATIC_STATE = STATIC.createStaticState(null);
    static final int GC_BITMARK_HANDLE = 1;
    private static final int INVALID_BITMARK_HANDLE = 3;
    private final StringMap roots = new StringMap();
    private final PropertyChangeSupport soListeners = new PropertyChangeSupport(this);
    private final IdentityHashMap stateMap = new IdentityHashMap();
    private GraphState mainState;
    private Executor sync;
    final EventSupport support;
    private boolean makePersistentTransitive = true;
    public double[] rate;
    public final LongToIntHashMap baseMap = new LongToIntHashMap();
    private Node[] hashBuckets = new Node[64];
    private int extentSize = 0;
    private int resizeThreshold = 40;
    private boolean logDataOnPersistenceChange = true;
    boolean loggingSuppressed = false;
    private boolean currentGCMark;
    final XHashMap<String, Node> nodeForName = new XHashMap();
    private final HashMap<Object, Extent> typeExtents = new HashMap();
    private final Extent rootExtent;
    private ObjectList<Node> firstStack = new ObjectList(64);
    private ObjectList<Node> secondStack = new ObjectList(64);
    private final HashMap<String, Object> props = new HashMap();
    private final Object markLock = new Object();
    private XBitSet objectMarks = new XBitSet();
    private int bitMarks = 0;
    private final IntList objBitMarks = new IntList();
    private final IntList objBitMarksUsed = new IntList();
    private ObjectList disposeBits = new ObjectList();
    private ObjectList disposeObjects = new ObjectList();
    private final SOReferenceImpl ref = new SOReferenceImpl();

    public GraphManager(PersistenceConnection persistenceConnection, String string, boolean bl, boolean bl2) {
        super(persistenceConnection, string, bl2);
        if (this.allocateBitMark(false) != 1) {
            throw new AssertionError();
        }
        this.currentGCMark = false;
        this.rootExtent = new Extent(this.makeLock, Node.$TYPE, null);
        this.typeExtents.put(GraphManager.getHashKey(Node.$TYPE), this.rootExtent);
        this.support = new EventSupport(this.createObjectMap());
    }

    public void initMainState(Executor executor) {
        this.sync = executor;
        this.mainState = new State(this, ThreadContext.current(), false);
    }

    @Override
    public GraphState getMainState() {
        return this.mainState;
    }

    @Override
    public Map getStateMap() {
        return this.stateMap;
    }

    @Override
    public void addChangeBoundaryListener(ChangeBoundaryListener changeBoundaryListener) {
        this.support.addChangeBoundaryListener(changeBoundaryListener);
    }

    @Override
    public void removeChangeBoundaryListener(ChangeBoundaryListener changeBoundaryListener) {
        this.support.removeChangeBoundaryListener(changeBoundaryListener);
    }

    @Override
    public void addAttributeChangeListener(AttributeChangeListener attributeChangeListener) {
        this.support.addAttributeChangeListener(attributeChangeListener);
    }

    @Override
    public void addEdgeChangeListener(EdgeChangeListener edgeChangeListener) {
        this.support.addEdgeChangeListener(edgeChangeListener);
    }

    @Override
    public void removeAttributeChangeListener(AttributeChangeListener attributeChangeListener) {
        this.support.removeAttributeChangeListener(attributeChangeListener);
    }

    @Override
    public void removeEdgeChangeListener(EdgeChangeListener edgeChangeListener) {
        this.support.removeEdgeChangeListener(edgeChangeListener);
    }

    @Override
    public void addAttributeChangeListener(Object object, boolean bl, AttributeChangeListener attributeChangeListener) {
        this.support.addAttributeChangeListener(object, bl, attributeChangeListener);
    }

    @Override
    public void removeAttributeChangeListener(Object object, boolean bl, AttributeChangeListener attributeChangeListener) {
        this.support.removeAttributeChangeListener(object, bl, attributeChangeListener);
    }

    @Override
    public void addEdgeChangeListener(Object object, boolean bl, EdgeChangeListener edgeChangeListener) {
        this.support.addEdgeChangeListener(object, bl, edgeChangeListener);
    }

    @Override
    public void removeEdgeChangeListener(Object object, boolean bl, EdgeChangeListener edgeChangeListener) {
        this.support.removeEdgeChangeListener(object, bl, edgeChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRoot(String string, Node node) {
        this.roots.put(string, (Object)node);
        Object object = this.makeLock;
        synchronized (object) {
            this.makePersistentImpl(node, -1L, null);
        }
    }

    public Node getRoot() {
        return (Node)this.getRoot("MainGraph");
    }

    @Override
    public Object getRoot(String string) {
        return this.roots.get(string);
    }

    @Override
    public String[] getRootKeys() {
        return this.roots.getKeys();
    }

    public void logDataOnPersistenceChange(boolean bl) {
        this.logDataOnPersistenceChange = bl;
    }

    public void suppressLogging(boolean bl) {
        this.loggingSuppressed = bl;
    }

    @Override
    protected TransactionApplier createXAApplier() {
        return new GraphXAApplier();
    }

    @Override
    protected Transaction createTransaction(Thread thread) {
        return new GraphTransaction(this, thread);
    }

    @Override
    protected boolean isAllowedThread(boolean bl) {
        return !bl || this.getMainState().getContext().isCurrent();
    }

    @Override
    protected void executeInAllowedThread(Runnable runnable) {
        this.sync.execute(runnable);
    }

    @Override
    protected void invokeRun(LockProtectedRunnable lockProtectedRunnable, boolean bl, Lock lock) {
        Transaction transaction = this.getTransaction(false);
        int n = -1;
        if (transaction != null && lock.isWriteLock()) {
            n = transaction.getActiveCount();
            transaction.begin(false);
        }
        Throwable throwable = null;
        try {
            lockProtectedRunnable.run(bl, lock);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        if (n >= 0) {
            while (transaction.getActiveCount() > n) {
                if (throwable != null) {
                    transaction.rollback();
                    continue;
                }
                transaction.commit();
            }
        }
        Utils.rethrow(throwable);
    }

    @Override
    protected void enterWriteLock() {
        this.getActiveTransaction();
    }

    @Override
    protected void leaveWriteLock() {
        this.getTransaction(true).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void prepareCompletion(Transaction transaction, boolean bl) {
        if (bl && transaction.hasModified()) {
            ObjectList<Node> objectList = this.firstStack;
            ObjectList<Node> objectList2 = this.secondStack;
            Object object = this.makeLock;
            synchronized (object) {
                int n;
                boolean bl2 = !this.currentGCMark;
                objectList.clear();
                objectList2.clear();
                for (n = 0; n < this.roots.size(); ++n) {
                    Node node = (Node)this.roots.getValueAt(n);
                    objectList2.add(node);
                }
                while (!objectList2.isEmpty()) {
                    ObjectList<Node> objectList3 = objectList2;
                    objectList2 = objectList;
                    objectList = objectList3;
                    for (int i = objectList.size - 1; i >= 0; --i) {
                        if (objectList.get(i).setGCMark(bl2) != bl2) continue;
                        objectList.elements[i] = null;
                    }
                    while (!objectList.isEmpty()) {
                        Node node = objectList.pop();
                        if (node == null) continue;
                        this.addDirectlyReachable(node, objectList2, transaction);
                    }
                }
                this.currentGCMark = bl2;
                for (n = this.hashBuckets.length - 1; n >= 0; --n) {
                    Node node = this.hashBuckets[n];
                    while (node != null) {
                        if ((node.bits & 0x10) == 0 && node.getGCMark() != this.currentGCMark) {
                            if (this.logDataOnPersistenceChange) {
                                transaction.logReadData(node, true);
                            }
                            objectList2.add(node);
                        }
                        node = node.hashBucketNext;
                    }
                }
                while (!objectList2.isEmpty()) {
                    this.makeTransient(objectList2.pop(), transaction);
                }
            }
        }
        super.prepareCompletion(transaction, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void transactionApplied(Transaction.Data data, boolean bl, Transaction transaction) {
        super.transactionApplied(data, bl, transaction);
        this.finishMakePersistent(((GraphTransaction)transaction).madePersistent, 0);
        Object object = this.makeLock;
        synchronized (object) {
            ObjectList<Node> objectList = ((GraphTransaction)transaction).extentIndexChanged;
            while (!objectList.isEmpty()) {
                Node node = objectList.pop();
                this.getExtentUnsync(node.getNType()).reenqueue(node);
            }
            objectList = ((GraphTransaction)transaction).madeTransient;
            while (!objectList.isEmpty()) {
                this.removeFromExtent(objectList.pop());
            }
        }
        ((GraphTransaction)transaction).madeTransient.clear();
        ((GraphTransaction)transaction).madePersistent.clear();
        ((GraphTransaction)transaction).extentIndexChanged.clear();
    }

    @Override
    protected void completeTransaction(Transaction transaction, boolean bl) {
        super.completeTransaction(transaction, bl);
        ((GraphTransaction)transaction).madeTransient.clear();
        ((GraphTransaction)transaction).madePersistent.clear();
        ((GraphTransaction)transaction).extentIndexChanged.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String string, Object object) {
        HashMap<String, Object> hashMap = this.props;
        synchronized (hashMap) {
            this.props.put(string, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String string) {
        HashMap<String, Object> hashMap = this.props;
        synchronized (hashMap) {
            return this.props.get(string);
        }
    }

    private static int hashCode(long l) {
        int n = (int)l ^ (int)(l >>> 32);
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        return n ^ n >>> 10;
    }

    Node getNodeOrPlaceholder(long l) {
        Node node = this.hashBuckets[GraphManager.hashCode(l) & this.hashBuckets.length - 1];
        while (node != null) {
            if (node.id == l) {
                return node;
            }
            node = node.hashBucketNext;
        }
        return null;
    }

    public void removeAllFromExtent() {
        Node node = this.getRoot();
        this.removeAllFromExtentInternal(node);
    }

    private void removeAllFromExtentInternal(Node node) {
        this.removeFromExtentInternal(node);
        for (Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
            if (edge.getSource() != node) continue;
            Node node2 = edge.getTarget();
            this.removeAllFromExtentInternal(node2);
        }
    }

    private void removeFromExtentInternal(Node node) {
        try {
            this.removeFromExtent(node);
        }
        catch (FatalPersistenceException fatalPersistenceException) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromExtent(Node node) {
        int n = GraphManager.hashCode(node.id) & this.hashBuckets.length - 1;
        Node node2 = this.hashBuckets[n];
        Node node3 = null;
        while (node2 != null) {
            if (node2 == node) {
                --this.extentSize;
                if (node3 != null) {
                    node3.hashBucketNext = node2.hashBucketNext;
                } else {
                    this.hashBuckets[n] = node2.hashBucketNext;
                }
                node.setGraphManager(null, -2L);
                if (node.getName() != null) {
                    XHashMap<String, Node> xHashMap = this.nodeForName;
                    synchronized (xHashMap) {
                        this.nodeForName.remove(node.getName(), node);
                    }
                }
                this.getExtentUnsync(node.getNType()).remove(node);
                return;
            }
            node3 = node2;
            node2 = node2.hashBucketNext;
        }
        throw new FatalPersistenceException("Illegal node " + node);
    }

    @Override
    public long prepareId(PersistenceCapable persistenceCapable) {
        long l = persistenceCapable.getId();
        if (l < 0L) {
            l = this.nextId();
            ((Node)persistenceCapable).setGraphManager(null, l);
        }
        return l;
    }

    public void setMakePersistentTransitive(boolean bl) {
        this.makePersistentTransitive = bl;
    }

    @Override
    protected void makePersistentImpl(PersistenceCapable persistenceCapable, long l, Transaction transaction) {
        int n;
        if (persistenceCapable.getPersistenceManager() != null) {
            if (persistenceCapable.getPersistenceManager() != this) {
                throw new FatalPersistenceException("Different PM");
            }
            return;
        }
        boolean bl = l >= 0L;
        ObjectList<Node> objectList = this.firstStack;
        ObjectList<Node> objectList2 = this.secondStack;
        ObjectList<Node> objectList3 = transaction != null ? ((GraphTransaction)transaction).madePersistent : null;
        objectList.clear();
        objectList2.clear();
        objectList2.add((Node)persistenceCapable);
        int n2 = n = objectList3 != null ? objectList3.size : -1;
        while (!objectList2.isEmpty()) {
            ObjectList<Node> objectList4 = objectList2;
            objectList2 = objectList;
            objectList = objectList4;
            for (int i = objectList.size() - 1; i >= 0; --i) {
                Node node;
                Node node2 = objectList.get(i);
                if (node2.manager == this) {
                    objectList.elements[i] = null;
                    continue;
                }
                if (bl) {
                    bl = false;
                    this.idUsed(l);
                } else if (node2.id >= 0L) {
                    l = node2.id;
                    this.idUsed(l);
                } else {
                    l = this.nextId();
                }
                int n3 = GraphManager.hashCode(l) & this.hashBuckets.length - 1;
                node2.hashBucketNext = node = this.hashBuckets[n3];
                while (node != null) {
                    if (node.id == l) {
                        throw new FatalPersistenceException("Cannot make " + node2 + " persistent: There already exists the object " + node + " with id " + l);
                    }
                    node = node.hashBucketNext;
                }
                this.hashBuckets[n3] = node2;
                node2.setGraphManager(this, l);
                if (++this.extentSize > this.resizeThreshold) {
                    Node[] nodeArray = new Node[this.hashBuckets.length << 1];
                    int n4 = nodeArray.length - 1;
                    for (int j = this.hashBuckets.length - 1; j >= 0; --j) {
                        Node node3;
                        node = this.hashBuckets[j];
                        if (node == null) continue;
                        this.hashBuckets[j] = null;
                        do {
                            node3 = node.hashBucketNext;
                            int n5 = GraphManager.hashCode(node.id) & n4;
                            node.hashBucketNext = nodeArray[n5];
                            nodeArray[n5] = node;
                        } while ((node = node3) != null);
                    }
                    this.hashBuckets = nodeArray;
                    this.resizeThreshold = (int)((float)nodeArray.length * 0.7f);
                }
                node2.setGCMark(this.currentGCMark);
                if (transaction != null) {
                    objectList3.add(node2);
                } else {
                    objectList.push(node2);
                    this.finishMakePersistent(objectList, objectList.size - 1);
                    objectList.pop();
                }
                if (!Transaction.isNotApplying(transaction)) continue;
                transaction.logMakePersistent(node2);
            }
            if (!this.makePersistentTransitive) {
                objectList.clear();
            }
            while (!objectList.isEmpty()) {
                Node node = objectList.pop();
                if (node == null) continue;
                this.addDirectlyReachable(node, objectList2, null);
            }
        }
        if (this.logDataOnPersistenceChange && Transaction.isNotApplying(transaction)) {
            for (int i = n; i < objectList3.size; ++i) {
                transaction.logReadData(objectList3.get(i), false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishMakePersistent(ObjectList<Node> objectList, int n) {
        Node node;
        int n2;
        Object object = this.nodeForName;
        synchronized (object) {
            for (n2 = objectList.size - 1; n2 >= n; --n2) {
                node = objectList.get(n2);
                if (node.getName() == null) continue;
                this.nodeForName.add(node.getName(), node);
            }
        }
        object = this.makeLock;
        synchronized (object) {
            for (n2 = objectList.size - 1; n2 >= n; --n2) {
                node = objectList.get(n2);
                this.getExtentUnsync(node.getNType()).add(node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Extent getExtent(Type type) {
        Object object = this.makeLock;
        synchronized (object) {
            return this.getExtentUnsync(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Extent getExtent(Class clazz) {
        Object object = this.makeLock;
        synchronized (object) {
            Extent extent = this.typeExtents.get(clazz);
            if (extent == null) {
                if (!Node.class.isAssignableFrom(clazz)) {
                    throw new IllegalArgumentException("No Node subtype: " + clazz.getName());
                }
                Type type = Reflection.getType(clazz);
                extent = new Extent(this.makeLock, type, this.getExtentUnsync(type.getSupertype()));
                this.typeExtents.put(clazz, extent);
            }
            return extent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildExtents() {
        Object object = this.makeLock;
        synchronized (object) {
            this.getExtentUnsync(Node.$TYPE).clear();
            for (int i = this.hashBuckets.length - 1; i >= 0; --i) {
                Node node = this.hashBuckets[i];
                while (node != null) {
                    this.getExtentUnsync(node.getNType()).add(node);
                    node = node.hashBucketNext;
                }
            }
        }
    }

    private static Object getHashKey(Type type) {
        return (type = TypeDecorator.undecorate(type)) instanceof XClass ? type : type.getImplementationClass();
    }

    private Extent getExtentUnsync(Type type) {
        Extent extent = this.typeExtents.get(GraphManager.getHashKey(type));
        if (extent == null) {
            if (!Reflection.isSuperclassOrSame(Node.$TYPE, type)) {
                throw new IllegalArgumentException("No Node subtype: " + type.getBinaryName());
            }
            extent = new Extent(this.makeLock, type, this.getExtentUnsync(type.getSupertype()));
            this.typeExtents.put(GraphManager.getHashKey(type), extent);
        }
        return extent;
    }

    private void addDirectlyReachable(Node node, ObjectList<Node> objectList, Transaction transaction) {
        Edge edge;
        Object object;
        Object object2 = null;
        boolean bl = true;
        for (object = node.getFirstEdge(); object != null; object = ((Edge)object).getNext(node)) {
            if (((Edge)object).edgeBits == 0) continue;
            edge = ((Edge)object).getNeighbor(node);
            if (transaction != null) {
                if (object == node) {
                    object2 = null;
                    bl = false;
                } else if (bl && object2 == null && ((Edge)object).isSource((Node)edge)) {
                    object2 = object;
                }
                if (edge.getGCMark() != this.currentGCMark) continue;
                objectList.add((Node)edge);
                continue;
            }
            GraphManager graphManager = ((Node)edge).manager;
            if (graphManager == null) {
                objectList.add((Node)edge);
                continue;
            }
            if (graphManager == this) continue;
            throw new FatalPersistenceException("A conflicting persistence manager was found in the graph.");
        }
        if (object2 != null) {
            object = ((Edge)object2).getSource();
            int n = ((Edge)object2).edgeBits;
            ((Edge)object2).remove(transaction, false);
            edge = ((Node)object).getOrCreateEdgeTo(node);
            assert (edge == node);
            edge.addEdgeBits(n, transaction, false);
        }
        object = node.getManageableType().getFCOFields();
        for (int i = ((ManageableType.Field[])object).length - 1; i >= 0; --i) {
            this.addNodes(((ManageableType.Field)object[i]).getObject(node), objectList, transaction != null);
        }
    }

    private void addNodes(Object object, ObjectList<Node> objectList, boolean bl) {
        block13: {
            block11: {
                Node node;
                block12: {
                    if (!(object instanceof Node)) break block11;
                    node = (Node)object;
                    if (!bl) break block12;
                    if (node.getGCMark() != this.currentGCMark) break block13;
                    objectList.add(node);
                    break block13;
                }
                GraphManager graphManager = node.manager;
                if (graphManager == null) {
                    objectList.add(node);
                } else if (graphManager != this) {
                    throw new FatalPersistenceException("A conflicting persistence manager was found in the graph.");
                }
                break block13;
            }
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    this.addNodes(objectArray[i], objectList, bl);
                }
            } else if (object instanceof List) {
                List list = (List)object;
                if (object instanceof RandomAccess) {
                    for (int i = list.size() - 1; i >= 0; --i) {
                        this.addNodes(list.get(i), objectList, bl);
                    }
                } else {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        this.addNodes(iterator.next(), objectList, bl);
                    }
                }
            }
        }
    }

    @Override
    protected void makeTransientImpl(PersistenceCapable persistenceCapable, Transaction transaction) {
        Node node = (Node)persistenceCapable;
        if (this.getNodeOrPlaceholder(node.id) != node) {
            throw new FatalPersistenceException(node + " is not registered in the graph. " + this.getNodeOrPlaceholder(node.id));
        }
        if (Transaction.isNotApplying(transaction)) {
            transaction.logMakeTransient(persistenceCapable);
        }
        if (transaction != null) {
            ((GraphTransaction)transaction).madeTransient.add(node);
            node.bits |= 0x10;
        } else {
            this.removeFromExtent(node);
        }
    }

    @Override
    public Node getObject(long l) {
        Node node = this.getNodeOrPlaceholder(l);
        return node instanceof PlaceholderNode ? null : node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int allocateBitMark(boolean bl) {
        Object object = this.markLock;
        synchronized (object) {
            int n;
            int n2;
            block6: {
                n2 = Utils.indexOfOne(~this.bitMarks);
                if (n2 >= 0) {
                    this.bitMarks |= 1 << n2;
                    this.disposeBits.set(n2, bl ? new ObjectList() : null);
                    return 1 << n2;
                }
                int[] nArray = this.objBitMarksUsed.elements;
                for (n = this.objBitMarksUsed.size - 1; n >= 0; --n) {
                    if (nArray[n] == 255) {
                        continue;
                    }
                    break block6;
                }
                n = this.objBitMarksUsed.size;
                this.objBitMarks.add(this.allocateObjectMark(false));
                this.objBitMarksUsed.add(0);
            }
            n2 = Utils.indexOfOne(~this.objBitMarksUsed.elements[n]);
            int n3 = n;
            this.objBitMarksUsed.elements[n3] = this.objBitMarksUsed.elements[n3] | 1 << n2;
            n2 = (this.objBitMarks.elements[n] << 3) + n2;
            this.disposeBits.set(n2 + 32, bl ? new ObjectList() : null);
            return -n2;
        }
    }

    @Override
    public final void disposeBitMark(int n, boolean bl) {
        this.disposeBitMark(n, bl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disposeBitMark(int n, boolean bl, boolean bl2) {
        int n2;
        boolean bl3 = false;
        switch (n) {
            case 1: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
            case 8: {
                n2 = 3;
                break;
            }
            case 16: {
                n2 = 4;
                break;
            }
            case 32: {
                n2 = 5;
                break;
            }
            case 64: {
                n2 = 6;
                break;
            }
            case 128: {
                n2 = 7;
                break;
            }
            case 256: {
                n2 = 8;
                break;
            }
            case 512: {
                n2 = 9;
                break;
            }
            case 1024: {
                n2 = 10;
                break;
            }
            case 2048: {
                n2 = 11;
                break;
            }
            case 4096: {
                n2 = 12;
                break;
            }
            case 8192: {
                n2 = 13;
                break;
            }
            case 16384: {
                n2 = 14;
                break;
            }
            case 32768: {
                n2 = 15;
                break;
            }
            case 65536: {
                n2 = 16;
                break;
            }
            case 131072: {
                n2 = 17;
                break;
            }
            case 262144: {
                n2 = 18;
                break;
            }
            case 524288: {
                n2 = 19;
                break;
            }
            case 0x100000: {
                n2 = 20;
                break;
            }
            case 0x200000: {
                n2 = 21;
                break;
            }
            case 0x400000: {
                n2 = 22;
                break;
            }
            case 0x800000: {
                n2 = 23;
                break;
            }
            case 0x1000000: {
                n2 = 24;
                break;
            }
            case 0x2000000: {
                n2 = 25;
                break;
            }
            case 0x4000000: {
                n2 = 26;
                break;
            }
            case 0x8000000: {
                n2 = 27;
                break;
            }
            case 0x10000000: {
                n2 = 28;
                break;
            }
            case 0x20000000: {
                n2 = 29;
                break;
            }
            case 0x40000000: {
                n2 = 30;
                break;
            }
            case -2147483648: {
                n2 = 31;
                break;
            }
            default: {
                bl3 = true;
                n2 = 32 - n;
            }
        }
        Object object = this.markLock;
        synchronized (object) {
            int n3;
            Object e = this.disposeBits.get(n2);
            if (e != null || bl) {
                if (bl || e == this) {
                    for (n3 = this.hashBuckets.length - 1; n3 >= 0; --n3) {
                        Node node = this.hashBuckets[n3];
                        while (node != null) {
                            node.setBitMark(n, false);
                            if (!bl2) {
                                for (Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
                                    edge.setBitMark(n, false);
                                }
                            }
                            node = node.hashBucketNext;
                        }
                    }
                } else {
                    Object[] objectArray = ((ObjectList)e).elements;
                    for (int i = ((ObjectList)e).size - 1; i >= 0; --i) {
                        ((Edge)objectArray[i]).setBitMark(n, false);
                    }
                }
                this.disposeBits.set(n2, null);
            }
            if (bl3) {
                n3 = (n2 -= 32) >> 3;
                int[] nArray = this.objBitMarks.elements;
                for (int i = this.objBitMarks.size - 1; i >= 0; --i) {
                    if (nArray[i] != n3) continue;
                    int n4 = i;
                    this.objBitMarksUsed.elements[n4] = this.objBitMarksUsed.elements[n4] & ~(1 << (n2 & 7));
                    if (this.objBitMarksUsed.elements[n4] == 0) {
                        this.disposeObjectMark(n3, false);
                        this.objBitMarks.removeAt(i);
                        this.objBitMarksUsed.removeAt(i);
                    }
                    return;
                }
                throw new AssertionError();
            }
            this.bitMarks &= ~n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int allocateObjectMark(boolean bl) {
        Object object = this.markLock;
        synchronized (object) {
            int n = this.objectMarks.nextClearBit(0);
            if (n < 0) {
                n = this.objectMarks.size();
            }
            this.objectMarks.set(n);
            this.disposeObjects.set(n, bl ? new ObjectList() : null);
            return n;
        }
    }

    @Override
    public final void disposeObjectMark(int n, boolean bl) {
        this.disposeObjectMark(n, bl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disposeObjectMark(int n, boolean bl, boolean bl2) {
        Object object = this.markLock;
        synchronized (object) {
            Object e = this.disposeObjects.get(n);
            if (e != null || bl) {
                if (bl || e == this) {
                    for (int i = this.hashBuckets.length - 1; i >= 0; --i) {
                        Node node = this.hashBuckets[i];
                        while (node != null) {
                            node.setObjectMark(n, null);
                            if (!bl2) {
                                for (Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
                                    edge.setObjectMark(n, null);
                                }
                            }
                            node = node.hashBucketNext;
                        }
                    }
                } else {
                    Object[] objectArray = ((ObjectList)e).elements;
                    for (int i = ((ObjectList)e).size - 1; i >= 0; --i) {
                        ((Edge)objectArray[i]).setObjectMark(n, null);
                    }
                }
                this.disposeObjects.set(n, null);
            }
            this.objectMarks.set(n, false);
        }
    }

    final void bitMarkSet(Edge edge, int n) {
        int n2;
        switch (n) {
            case 1: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
            case 8: {
                n2 = 3;
                break;
            }
            case 16: {
                n2 = 4;
                break;
            }
            case 32: {
                n2 = 5;
                break;
            }
            case 64: {
                n2 = 6;
                break;
            }
            case 128: {
                n2 = 7;
                break;
            }
            case 256: {
                n2 = 8;
                break;
            }
            case 512: {
                n2 = 9;
                break;
            }
            case 1024: {
                n2 = 10;
                break;
            }
            case 2048: {
                n2 = 11;
                break;
            }
            case 4096: {
                n2 = 12;
                break;
            }
            case 8192: {
                n2 = 13;
                break;
            }
            case 16384: {
                n2 = 14;
                break;
            }
            case 32768: {
                n2 = 15;
                break;
            }
            case 65536: {
                n2 = 16;
                break;
            }
            case 131072: {
                n2 = 17;
                break;
            }
            case 262144: {
                n2 = 18;
                break;
            }
            case 524288: {
                n2 = 19;
                break;
            }
            case 0x100000: {
                n2 = 20;
                break;
            }
            case 0x200000: {
                n2 = 21;
                break;
            }
            case 0x400000: {
                n2 = 22;
                break;
            }
            case 0x800000: {
                n2 = 23;
                break;
            }
            case 0x1000000: {
                n2 = 24;
                break;
            }
            case 0x2000000: {
                n2 = 25;
                break;
            }
            case 0x4000000: {
                n2 = 26;
                break;
            }
            case 0x8000000: {
                n2 = 27;
                break;
            }
            case 0x10000000: {
                n2 = 28;
                break;
            }
            case 0x20000000: {
                n2 = 29;
                break;
            }
            case 0x40000000: {
                n2 = 30;
                break;
            }
            case -2147483648: {
                n2 = 31;
                break;
            }
            default: {
                n2 = 32 - n;
            }
        }
        Object e = this.disposeBits.get(n2);
        if (e != null && e != this) {
            if (((ObjectList)e).size << 4 > this.extentSize) {
                this.disposeBits.set(n2, this);
            } else {
                ((ObjectList)e).add(edge);
            }
        }
    }

    final void objectMarkSet(Edge edge, int n) {
        Object e = this.disposeObjects.get(n);
        if (e != null && e != this) {
            if (((ObjectList)e).size << 4 > this.extentSize) {
                this.disposeObjects.set(n, this);
            } else {
                ((ObjectList)e).add(edge);
            }
        }
    }

    @Override
    public BooleanMap createBooleanMap() {
        final int n = this.allocateBitMark(false);
        final int n2 = this.allocateBitMark(false);
        return new BooleanMap(){

            public boolean putBoolean(Object object, boolean bl, boolean bl2) {
                return ((Edge)object).setBitMark(bl || object instanceof EdgeImpl ? n : n2, bl2);
            }

            public boolean getBoolean(Object object, boolean bl) {
                return ((Edge)object).getBitMark(bl || object instanceof EdgeImpl ? n : n2);
            }

            public void dispose() {
                GraphManager.this.disposeBitMark(n, true, false);
                GraphManager.this.disposeBitMark(n2, true, true);
            }
        };
    }

    @Override
    public <V> ObjectMap<V> createObjectMap() {
        final int n = this.allocateObjectMark(false);
        final int n2 = this.allocateObjectMark(false);
        return new ObjectMap<V>(){

            @Override
            public V putObject(Object object, boolean bl, V v) {
                return ((Edge)object).setObjectMark(bl || object instanceof EdgeImpl ? n : n2, v);
            }

            @Override
            public V getObject(Object object, boolean bl) {
                return ((Edge)object).getObjectMark(bl || object instanceof EdgeImpl ? n : n2);
            }

            @Override
            public void dispose() {
                GraphManager.this.disposeObjectMark(n, true, false);
                GraphManager.this.disposeObjectMark(n2, true, true);
            }
        };
    }

    @Override
    public void writeExtent(PersistenceOutputStream persistenceOutputStream) throws IOException {
        this.writeExtent(new GraphOutputStream(persistenceOutputStream), null);
    }

    public void writeExtent(final GraphOutput graphOutput, final Node node) throws IOException {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Task
        implements LockProtectedRunnable {
            IOException ex;

            Task() {
            }

            @Override
            public void run(boolean bl, Lock lock) {
                try {
                    GraphManager.this.writeExtent0(graphOutput, node);
                }
                catch (IOException iOException) {
                    this.ex = iOException;
                }
            }
        }
        Task task = new Task();
        Utils.executeForcedlyAndUninterruptibly((Lockable)this, (LockProtectedRunnable)task, false);
        if (task.ex != null) {
            throw task.ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeExtent0(GraphOutput graphOutput, Node node) throws IOException {
        int n = this.allocateBitMark(false);
        try {
            if (node != null) {
                graphOutput.beginExtent(this, 1);
                graphOutput.beginRoot("SubGraph");
                GraphManager.writeExtent(node, node.findAdjacent(true, false, 768), n, graphOutput, null);
                graphOutput.endRoot("SubGraph");
                graphOutput.endExtent();
            } else {
                graphOutput.beginExtent(this, this.roots.size());
                for (int i = 0; i < this.roots.size(); ++i) {
                    graphOutput.beginRoot(this.roots.getKeyAt(i));
                    GraphManager.writeExtent((Node)this.roots.getValueAt(i), null, n, graphOutput, null);
                    graphOutput.endRoot(this.roots.getKeyAt(i));
                }
                graphOutput.endExtent();
            }
        }
        finally {
            this.disposeBitMark(n, true);
        }
    }

    private static void writeExtent(Node node, Node node2, int n, GraphOutput graphOutput, Edge edge) throws IOException {
        boolean bl = node.setBitMark(n, true);
        if (bl && edge == null) {
            return;
        }
        graphOutput.beginNode(node, edge);
        if (!bl) {
            for (edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
                Node node3 = edge.getTarget();
                if (node3 != node) {
                    GraphManager.writeExtent(node3, node, n, graphOutput, edge);
                    continue;
                }
                node3 = edge.getSource();
                if (node2 == node3) continue;
                GraphManager.writeExtent(node3, node, n, graphOutput, null);
            }
        }
        graphOutput.endNode(node);
    }

    @Override
    public void readExtent(PersistenceInputStream persistenceInputStream) throws IOException {
        this.setMakePersistentTransitive(false);
        persistenceInputStream.beginExtent(this);
        int n = persistenceInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            persistenceInputStream.checkInt(-401623889);
            String string = persistenceInputStream.readUTF();
            persistenceInputStream.check(9);
            this.setRoot(string, GraphManager.readNode(persistenceInputStream));
        }
        persistenceInputStream.endExtent();
        this.setMakePersistentTransitive(true);
    }

    private static Node readNode(PersistenceInputStream persistenceInputStream) throws IOException {
        Node node = (Node)persistenceInputStream.readPersistentObject();
        block5: while (true) {
            switch (persistenceInputStream.readUnsignedByte()) {
                case 218: {
                    int n = persistenceInputStream.readInt();
                    node.getOrCreateEdgeTo(GraphManager.readNode(persistenceInputStream)).addEdgeBits(n, null);
                    continue block5;
                }
                case 9: {
                    GraphManager.readNode(persistenceInputStream);
                    continue block5;
                }
                case 115: {
                    return node;
                }
            }
            break;
        }
        throw new StreamCorruptedException();
    }

    void sharedObjectModified(PropertyChangeEvent propertyChangeEvent) {
        this.soListeners.firePropertyChange(propertyChangeEvent);
    }

    public void addSharedObjectListener(PropertyChangeListener propertyChangeListener) {
        this.soListeners.addPropertyChangeListener(propertyChangeListener);
    }

    public void removeSharedObjectListener(PropertyChangeListener propertyChangeListener) {
        this.soListeners.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean accept0(Node object, ArrayPath arrayPath, Visitor visitor, int n) {
        Object object2 = null;
        Object object3 = null;
        Edge edge = null;
        boolean bl = false;
        boolean bl2 = true;
        ObjectList objectList = arrayPath.stack;
        int n2 = objectList.size;
        try {
            block7: while (true) {
                block18: {
                    Object object4;
                    block19: {
                        block20: {
                            if (!bl && (object2 = visitor.visitEnter(arrayPath, true)) == Visitor.STOP) break block18;
                            if (bl) break block19;
                            object4 = ((Node)object).getInstantiator();
                            if (object4 == null) break block20;
                            bl2 = true;
                            Object object5 = visitor.visitInstanceEnter();
                            if (object5 != Visitor.STOP) {
                                try {
                                    visitor.getGraphState().beginInstancing(object, arrayPath.getObjectId(-1));
                                    bl2 = object4.instantiate(arrayPath, visitor);
                                }
                                finally {
                                    visitor.getGraphState().endInstancing();
                                }
                            }
                            if (!(bl2 & visitor.visitInstanceLeave(object5))) break block18;
                        }
                        edge = ((Node)object).getFirstEdge();
                    }
                    while (edge != null) {
                        if (!bl) {
                            arrayPath.pushEdgeSet(edge, -1L, false);
                            object4 = edge.getNeighbor((Node)object);
                            arrayPath.pushNode(object4, ((Node)object4).manager != null ? ((Node)object4).id : (long)object4.hashCode());
                            bl2 = true;
                            object3 = visitor.visitEnter(arrayPath, false);
                            if (!(object3 == Visitor.STOP || n != 3 && ((Edge)object4).setBitMark(n, true))) {
                                objectList.push(object2).push(object3).push(object).push(edge);
                                object = object4;
                                continue block7;
                            }
                        }
                        bl = false;
                        arrayPath.popNode();
                        arrayPath.popEdgeSet();
                        if (!(bl2 &= visitor.visitLeave(object3, arrayPath, false))) break;
                        edge = edge.getNext((Node)object);
                    }
                }
                bl2 = visitor.visitLeave(object2, arrayPath, true);
                if (objectList.size == n2) {
                    boolean bl3 = bl2;
                    return bl3;
                }
                edge = (Edge)objectList.pop();
                object = (Node)objectList.pop();
                object3 = objectList.pop();
                object2 = objectList.pop();
                bl = true;
            }
        }
        finally {
            arrayPath.stack.setSize(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void accept(Object object, Visitor visitor, ArrayPath arrayPath) {
        Node node = (Node)(object != null ? object : this.roots.get("MainGraph"));
        if (node != null) {
            int n = this.allocateBitMark(false);
            try {
                node.setBitMark(n, true);
                if (arrayPath == null) {
                    arrayPath = new ArrayPath(this);
                } else {
                    arrayPath.clear(this);
                }
                arrayPath.pushNode(node, node.id);
                GraphManager.accept0(node, arrayPath, visitor, n);
                arrayPath.popNode();
            }
            finally {
                this.disposeBitMark(n, true);
            }
        }
    }

    public static void acceptGraph(Node node, Visitor visitor, ArrayPath arrayPath) {
        if (node != null) {
            arrayPath.pushNode(node, node.manager != null ? node.id : (long)node.hashCode());
            GraphManager.accept0(node, arrayPath, visitor, 3);
            arrayPath.popNode();
        }
    }

    public GraphState createStaticState(ThreadContext threadContext) {
        return new State(this, threadContext, true);
    }

    @Override
    public ObjectAttribute getParentAttribute() {
        return ParentAttribute.TREE;
    }

    @Override
    public EdgePattern getTreePattern() {
        return EdgePatternImpl.TREE;
    }

    @Override
    public String getProviderName() {
        return META_GRAPH;
    }

    @Override
    public ResolvableReference readReference(final PersistenceInput persistenceInput) throws IOException {
        final long l = persistenceInput.readPersistentObjectId();
        final SharedObjectNode sharedObjectNode = (SharedObjectNode)persistenceInput.resolveId(l);
        if (sharedObjectNode != null && sharedObjectNode.getSharedObject() != null) {
            this.ref.object = sharedObjectNode.getSharedObject();
            return this.ref;
        }
        return new ResolvableReference(){
            private SharedObjectNode n;
            {
                this.n = sharedObjectNode;
            }

            public Shareable resolve() {
                if (this.n == null) {
                    this.n = (SharedObjectNode)persistenceInput.resolveId(l);
                }
                return this.n != null ? this.n.getSharedObject() : null;
            }

            public boolean isResolvable() {
                return this.resolve() != null;
            }
        };
    }

    @Override
    public void writeObject(Shareable shareable, PersistenceOutput persistenceOutput) throws IOException {
        shareable.getProvider().writeObject(shareable, persistenceOutput);
    }

    public void addMetaNode(Node node, Transaction transaction) {
        ((Node)this.getRoot(META_GRAPH)).addEdgeBitsTo(node, 512, transaction);
    }

    public void removeMetaNode(Node node, Transaction transaction) {
        ((Node)this.getRoot(META_GRAPH)).removeEdgeBitsTo(node, -1, transaction);
    }

    @Override
    public int getLifeCycleState(Object object, boolean bl) {
        Node node;
        if (!(object instanceof Edge)) {
            return 2;
        }
        Edge edge = (Edge)object;
        if (edge.getGraph() != this) {
            return 2;
        }
        if (bl) {
            if (!(edge instanceof Node)) {
                return 2;
            }
            node = (Node)edge;
        } else {
            node = edge.getSource();
            if (node == null) {
                return 1;
            }
            if ((node.bits & 0x10) != 0) {
                return 1;
            }
            node = edge.getTarget();
            if (node == null) {
                return 1;
            }
        }
        return (node.bits & 0x10) != 0 ? 1 : 0;
    }

    @Override
    public String getName(Object object, boolean bl) {
        return bl ? ((Node)object).getName() : ((Edge)object).getSource().getId() + " -> " + ((Edge)object).getTarget().getId();
    }

    @Override
    public long getId(Object object) {
        return ((Node)object).id;
    }

    @Override
    public Object getNodeForId(long l) {
        return this.getObject(l);
    }

    @Override
    public Object getObjectForName(boolean bl, String string) {
        return bl ? this.getNodeForName(string) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getNodeForName(String string) {
        XHashMap<String, Node> xHashMap = this.nodeForName;
        synchronized (xHashMap) {
            return this.nodeForName.get(string);
        }
    }

    @Override
    public Object getDescription(Object object, boolean bl, String string) {
        if (Utils.isStringDescription(string)) {
            if (bl) {
                String string2 = ((Node)object).getName();
                return string2 != null ? string2 : ((Node)object).getNType().getSimpleName() + '.' + ((Node)object).getId();
            }
            StringBuffer stringBuffer = new StringBuffer();
            Edge edge = (Edge)object;
            boolean bl2 = "ShortDescription".equals(string);
            if (bl2) {
                stringBuffer.append(edge.getSource().getId()).append(' ');
            }
            edge.getEdgeKeys(stringBuffer, false, true);
            if (bl2) {
                stringBuffer.append(' ').append(edge.getTarget().getId());
            }
            return stringBuffer.toString();
        }
        if ("Icon".equals(string)) {
            return null;
        }
        return null;
    }

    @Override
    public SpecialEdgeDescriptor[] getSpecialEdgeDescriptors(Object object, boolean bl) {
        return ((Node)object).getNType().getSpecialEdgeDescriptors(bl);
    }

    @Override
    public int getSymbol(Object object, boolean bl) {
        return bl ? ((Node)object).getSymbol() : 3;
    }

    @Override
    public int getColor(Object object, boolean bl) {
        return bl ? ((Node)object).getSymbolColor() : 0xFFFFA0;
    }

    @Override
    public Attribute[] getAttributes(Object object, boolean bl) {
        if (bl) {
            return ((Node)object).getAttributes();
        }
        Edge edge = (Edge)object;
        int n = edge.getEdgeBits();
        if ((n & 0xFF) == 0) {
            return Attribute.ATTRIBUTE_0;
        }
        return ((n & 0x80) != 0 ? edge.getSource() : edge.getTarget()).getEdgeAttributes(edge);
    }

    @Override
    public Attribute[] getDependent(Object object, boolean bl, Attribute attribute) {
        return bl ? ((Node)object).getNType().dependencies.getDependent(attribute) : attribute.toArray();
    }

    @Override
    public AttributeAccessor getAccessor(Object object, boolean bl, Attribute attribute) {
        if (bl) {
            return ((Node)object).getAccessor(attribute);
        }
        Edge edge = (Edge)object;
        int n = edge.getEdgeBits();
        if ((n & 0xFF) == 0) {
            return null;
        }
        return ((n & 0x80) != 0 ? edge.getSource() : edge.getTarget()).getEdgeAttributeAccessor(attribute);
    }

    @Override
    public Object getFirstEdge(Object object) {
        return ((Node)object).getFirstEdge();
    }

    @Override
    public Instantiator getInstantiator(Object object) {
        return ((Node)object).getInstantiator();
    }

    @Override
    public int getEdgeBits(Object object) {
        return ((Edge)object).getEdgeBits();
    }

    @Override
    public Object getSourceNode(Object object) {
        return ((Edge)object).getSource();
    }

    @Override
    public Object getTargetNode(Object object) {
        return ((Edge)object).getTarget();
    }

    @Override
    public Object getNextEdge(Object object, Object object2) {
        return ((Edge)object).getNext((Node)object2);
    }

    public void dumpNodeStatistics(PrintWriter printWriter) {
        printWriter.println("Node Statistics for " + this);
        this.rootExtent.dumpStatistics(printWriter, this.rootExtent.totalSize(), 1);
    }

    public void dumpNodeStatistics(OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(outputStream);
        this.dumpNodeStatistics(printWriter);
        printWriter.flush();
    }

    public String toXLString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendXLTo(stringBuffer, bl);
        return stringBuffer.toString();
    }

    public void appendXLTo(StringBuffer stringBuffer, boolean bl) {
        HashMap<Node, String> hashMap = new HashMap<Node, String>();
        ObjectList<Node> objectList = new ObjectList<Node>();
        GraphManager.append(stringBuffer, bl, this.getRoot(), null, false, hashMap, objectList);
        while (!objectList.isEmpty()) {
            Node node = objectList.pop();
            if (hashMap.get(node) != null) continue;
            stringBuffer.append(", ");
            GraphManager.append(stringBuffer, bl, node, null, false, hashMap, objectList);
        }
    }

    private static void append(StringBuffer stringBuffer, boolean bl, Node node, Edge edge, boolean bl2, HashMap<Node, String> hashMap, ObjectList<Node> objectList) {
        String string;
        boolean bl3 = false;
        if (edge != null) {
            int n = edge.getEdgeBits();
            switch (n) {
                case 512: {
                    if (bl2) break;
                    stringBuffer.append(" [");
                    bl3 = true;
                    break;
                }
                case 256: {
                    if (bl2) {
                        stringBuffer.append("> ");
                        break;
                    }
                    stringBuffer.append(' ');
                    break;
                }
                default: {
                    if (!bl2) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append("-0x").append(Integer.toHexString(n)).append("-> ");
                }
            }
        }
        if ((string = hashMap.get(node)) != null) {
            stringBuffer.append(string);
        } else {
            int n = 0;
            int n2 = 0;
            for (Edge edge2 = node.getFirstEdge(); edge2 != null; edge2 = edge2.getNext(node)) {
                if (edge2.isSource(node)) {
                    ++n2;
                    continue;
                }
                if (edge2 == edge) continue;
                ++n;
            }
            if (n == 0) {
                string = "";
            } else {
                string = "n" + hashMap.size();
                stringBuffer.append(string).append(':');
            }
            hashMap.put(node, string);
            stringBuffer.append(bl ? node.getNType().getName() : node.getNType().getSimpleName());
            for (int i = 0; i < 2; ++i) {
                for (Edge edge3 = node.getFirstEdge(); edge3 != null; edge3 = edge3.getNext(node)) {
                    if (i == 0 != (edge3.getEdgeBits() == 512)) continue;
                    if (edge3.isSource(node)) {
                        if (--n2 > 0) {
                            stringBuffer.append(" [");
                        }
                        GraphManager.append(stringBuffer, bl, edge3.getTarget(), edge3, n2 > 0, hashMap, objectList);
                        if (n2 <= 0) continue;
                        stringBuffer.append(']');
                        continue;
                    }
                    if (edge3 == edge || hashMap.get(edge3.getSource()) != null) continue;
                    objectList.add(edge3.getSource());
                }
            }
        }
        if (bl3) {
            stringBuffer.append(']');
        }
    }

    public int getGraphSize(String string) {
        HashMap<Node, String> hashMap = new HashMap<Node, String>();
        ObjectList<Node> objectList = new ObjectList<Node>();
        this.getListOfNodes((Node)this.getRoot(string), null, false, hashMap, objectList);
        return hashMap.size();
    }

    public int getGraphSize() {
        return this.getGraphSize("MainGraph");
    }

    public int getMetaGraphSize() {
        return this.getGraphSize(META_GRAPH);
    }

    private void getListOfNodes(Node node, Edge edge, boolean bl, HashMap<Node, String> hashMap, ObjectList<Node> objectList) {
        String string = hashMap.get(node);
        if (string == null) {
            int n = 0;
            int n2 = 0;
            for (Edge edge2 = node.getFirstEdge(); edge2 != null; edge2 = edge2.getNext(node)) {
                if (edge2.isSource(node)) {
                    ++n2;
                    continue;
                }
                if (edge2 == edge) continue;
                ++n;
            }
            string = n == 0 ? "" : "n" + hashMap.size();
            hashMap.put(node, string);
            for (int i = 0; i < 2; ++i) {
                for (Edge edge3 = node.getFirstEdge(); edge3 != null; edge3 = edge3.getNext(node)) {
                    if (i == 0 != (edge3.getEdgeBits() == 512) || !edge3.isSource(node)) continue;
                    objectList.add(node);
                    this.getListOfNodes(edge3.getTarget(), edge3, n2 > 0, hashMap, objectList);
                }
            }
        }
    }
}

