/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.graph.impl;

import de.grogra.annotation.Choice;
import de.grogra.annotation.Editable;
import de.grogra.annotation.Range;
import de.grogra.graph.AccessorBase;
import de.grogra.graph.AccessorMap;
import de.grogra.graph.ArrayPath;
import de.grogra.graph.Attribute;
import de.grogra.graph.AttributeAccessor;
import de.grogra.graph.AttributeDependencies;
import de.grogra.graph.Attributes;
import de.grogra.graph.BooleanAttribute;
import de.grogra.graph.BooleanAttributeAccessor;
import de.grogra.graph.ByteAttribute;
import de.grogra.graph.ByteAttributeAccessor;
import de.grogra.graph.CharAttribute;
import de.grogra.graph.CharAttributeAccessor;
import de.grogra.graph.DoubleAttribute;
import de.grogra.graph.DoubleAttributeAccessor;
import de.grogra.graph.EdgePattern;
import de.grogra.graph.FloatAttribute;
import de.grogra.graph.FloatAttributeAccessor;
import de.grogra.graph.Graph;
import de.grogra.graph.GraphState;
import de.grogra.graph.Instantiator;
import de.grogra.graph.IntAttribute;
import de.grogra.graph.IntAttributeAccessor;
import de.grogra.graph.LongAttribute;
import de.grogra.graph.LongAttributeAccessor;
import de.grogra.graph.ObjectAttribute;
import de.grogra.graph.ObjectAttributeAccessor;
import de.grogra.graph.Path;
import de.grogra.graph.ShortAttribute;
import de.grogra.graph.ShortAttributeAccessor;
import de.grogra.graph.SpecialEdgeDescriptor;
import de.grogra.graph.Visitor;
import de.grogra.graph.VisitorImpl;
import de.grogra.graph.impl.Edge;
import de.grogra.graph.impl.EdgeImpl;
import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.GraphTransaction;
import de.grogra.graph.impl.NodeData;
import de.grogra.graph.impl.State;
import de.grogra.persistence.FieldAccessor;
import de.grogra.persistence.IndirectField;
import de.grogra.persistence.Manageable;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.Observer;
import de.grogra.persistence.PersistenceCapable;
import de.grogra.persistence.PersistenceField;
import de.grogra.persistence.PersistenceManager;
import de.grogra.persistence.Shareable;
import de.grogra.persistence.SharedObjectProvider;
import de.grogra.persistence.SharedObjectReference;
import de.grogra.persistence.Transaction;
import de.grogra.reflect.Annotation;
import de.grogra.reflect.BoundedType;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Field;
import de.grogra.reflect.FieldChain;
import de.grogra.reflect.FieldDecorator;
import de.grogra.reflect.Method;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.reflect.TypeImpl;
import de.grogra.reflect.UserFields;
import de.grogra.reflect.XClass;
import de.grogra.reflect.XData;
import de.grogra.reflect.XObject;
import de.grogra.util.EnumerationType;
import de.grogra.util.I18NBundle;
import de.grogra.util.Map;
import de.grogra.util.MimeType;
import de.grogra.util.StringMap;
import de.grogra.util.Utils;
import de.grogra.util.WrapException;
import de.grogra.xl.util.IntHashMap;
import de.grogra.xl.util.ObjectList;
import de.grogra.xl.util.XHashMap;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;

public class Node
extends Edge
implements PersistenceCapable,
Shareable,
Map,
XObject,
UserFields {
    public static final NType $TYPE;
    public static final NType.Field name$FIELD;
    public static final NType.Field layer$FIELD;
    public static final NType.Field extentIndex$FIELD;
    public static final NType.Field mark$FIELD;
    public static final NType.Field isInterpretive$FIELD;
    public static final NType.Field extentTail$FIELD;
    public static final MimeType MIME_TYPE;
    public static final int MIN_UNUSED_SPECIAL_OF_TARGET = 2;
    public static final int MIN_UNUSED_SPECIAL_OF_SOURCE = 129;
    private static final int LAYER_MASK = 15;
    public static final int DELETED = 16;
    public static final int HAS_OBSERVERS = 32;
    public static final int IS_INTERPRETIVE = 64;
    public static final int EXTENT_BIT = 7;
    public static final int LAST_EXTENT_INDEX = 7;
    public static final int EXTENT_MASK = 896;
    public static final int MARK = 1024;
    public static final int USED_BITS = 11;
    public static final ObjectAttribute ADDITIONAL_FIELDS;
    protected int bits = 0;
    NodeData data = null;
    private Node parent = null;
    transient long id = -1L;
    transient GraphManager manager = null;
    transient Node extentPrev;
    transient Node extentNext;
    transient Node hashBucketNext;
    private transient int stamp = 0;
    static final ThreadLocal<WeakReference<GraphManager>> DESERIALIZATION_MANAGER;

    public final ManageableType getManageableType() {
        if (this.data == null || this.data.ntype == null) {
            return this.getNTypeImpl();
        }
        return this.data.ntype;
    }

    public Manageable manageableReadResolve() {
        return this;
    }

    public Object manageableWriteReplace() {
        return this;
    }

    public final NType getNType() {
        if (this.data == null || this.data.ntype == null) {
            return this.getNTypeImpl();
        }
        return this.data.ntype;
    }

    protected NType getNTypeImpl() {
        return $TYPE;
    }

    public boolean isManagingInstance() {
        NType nType = this.getNTypeImpl();
        return nType == null || nType.getRepresentative() == this;
    }

    protected Node newInstance() {
        return new Node();
    }

    protected Object clone() throws CloneNotSupportedException {
        Node node = (Node)super.clone();
        node.next = null;
        node.targetNext = null;
        node.edgeBits = 0;
        node.data = null;
        node.parent = null;
        node.id = -1L;
        node.manager = null;
        node.bits &= 0xFFFFFFDF;
        node.bitMarks = 0;
        node.marks = Utils.OBJECT_0;
        return node;
    }

    public Node clone(boolean bl) throws CloneNotSupportedException {
        Node node = this.newInstance();
        assert (node.getClass() == this.getClass()) : "newInstance not implemented in " + this.getClass();
        node.dup(this, bl, null);
        return node;
    }

    public Node cloneGraph(EdgePattern edgePattern, final boolean bl) throws CloneNotSupportedException {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class CloneVisitor
        extends VisitorImpl {
            XHashMap clones = new XHashMap();

            CloneVisitor() {
            }

            @Override
            public Object visitEnter(Path path, boolean bl2) {
                if (bl2) {
                    this.getClone((Node)path.getObject(-1));
                    return null;
                }
                Object object = super.visitEnter(path, bl2);
                if (object != STOP) {
                    Node node = this.getClone((Node)path.getObject(-3));
                    Node node2 = this.getClone((Node)path.getObject(-1));
                    if (!path.isInEdgeDirection(-2)) {
                        Node node3 = node;
                        node = node2;
                        node2 = node3;
                    }
                    node.addEdgeBitsTo(node2, path.getEdgeBits(-2), null);
                }
                return object;
            }

            @Override
            public Object visitInstanceEnter() {
                return STOP;
            }

            private Node getClone(Node node) {
                Node node2 = (Node)this.clones.get(node);
                if (node2 == null) {
                    try {
                        node2 = node.clone(bl);
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        throw new WrapException(cloneNotSupportedException);
                    }
                    this.clones.put(node, node2);
                }
                return node2;
            }
        }
        CloneVisitor cloneVisitor = new CloneVisitor();
        cloneVisitor.init(this.getCurrentGraphState(), edgePattern);
        try {
            if (this.manager != null) {
                this.manager.accept(this, cloneVisitor, null);
            } else {
                GraphManager.acceptGraph(this, cloneVisitor, new ArrayPath(GraphManager.STATIC));
            }
        }
        catch (WrapException wrapException) {
            if (wrapException.getCause() instanceof CloneNotSupportedException) {
                throw (CloneNotSupportedException)wrapException.getCause();
            }
            throw wrapException;
        }
        return (Node)cloneVisitor.clones.get(this);
    }

    public void dup(Node node, boolean bl, Transaction transaction) throws CloneNotSupportedException {
        NType nType = this.getNType();
        block11: for (int i = nType.getManagedFieldCount() - 1; i >= 0; --i) {
            ManageableType.Field field = nType.getManagedField(i);
            switch (field.getType().getTypeId()) {
                case 2: {
                    field.setBoolean(this, null, field.getBoolean(node), transaction);
                    continue block11;
                }
                case 3: {
                    field.setByte(this, null, field.getByte(node), transaction);
                    continue block11;
                }
                case 4: {
                    field.setShort(this, null, field.getShort(node), transaction);
                    continue block11;
                }
                case 5: {
                    field.setChar(this, null, field.getChar(node), transaction);
                    continue block11;
                }
                case 6: {
                    field.setInt(this, null, field.getInt(node), transaction);
                    continue block11;
                }
                case 7: {
                    field.setLong(this, null, field.getLong(node), transaction);
                    continue block11;
                }
                case 8: {
                    field.setFloat(this, null, field.getFloat(node), transaction);
                    continue block11;
                }
                case 9: {
                    field.setDouble(this, null, field.getDouble(node), transaction);
                    continue block11;
                }
                case 0: {
                    field.setObject(this, null, bl ? field.getCloned(node) : field.getObject(node), transaction);
                }
            }
        }
        this.dupUnmanagedFields(node);
    }

    protected void dupUnmanagedFields(Node node) {
    }

    public final PersistenceManager getPersistenceManager() {
        return this.manager;
    }

    public final GraphManager getGraph() {
        return this.manager;
    }

    public final Transaction getTransaction(boolean bl) {
        return this.manager != null ? this.manager.getTransaction(bl) : null;
    }

    public final GraphState getCurrentGraphState() {
        return this.manager != null ? GraphState.current(this.manager) : null;
    }

    void setGraphManager(GraphManager graphManager, long l) {
        this.resetMarks();
        this.manager = graphManager;
        this.id = l;
        this.bits &= 0xFFFFFFEF;
    }

    public boolean isRoot() {
        for (Edge edge = this.getFirstEdge(); edge != null; edge = edge.getNext(this)) {
            if (!edge.isTarget(this)) continue;
            return false;
        }
        return true;
    }

    public int getDirectChildCount() {
        int n = 0;
        for (Edge edge = this.getFirstEdge(); edge != null; edge = edge.getNext(this)) {
            if (!edge.isSource(this)) continue;
            ++n;
        }
        return n;
    }

    public final long getId() {
        return this.id;
    }

    public AttributeAccessor getAccessor(Attribute attribute) {
        return this.getNType().accessors.getAccessorById(attribute.getId());
    }

    public AttributeAccessor getAccessor(String string) {
        return this.getNType().accessors.find(string);
    }

    public Attribute[] getAttributes() {
        AccessorMap accessorMap = this.getNType().accessors;
        return accessorMap.getAttributes(null);
    }

    public Attribute[] getEdgeAttributes(Edge edge) {
        return Attribute.ATTRIBUTE_0;
    }

    public AttributeAccessor getEdgeAttributeAccessor(Attribute attribute) {
        return null;
    }

    protected boolean getBoolean(BooleanAttribute booleanAttribute, GraphState graphState) {
        throw new NoSuchElementException(booleanAttribute.getKey());
    }

    protected byte getByte(ByteAttribute byteAttribute, GraphState graphState) {
        throw new NoSuchElementException(byteAttribute.getKey());
    }

    protected short getShort(ShortAttribute shortAttribute, GraphState graphState) {
        throw new NoSuchElementException(shortAttribute.getKey());
    }

    protected char getChar(CharAttribute charAttribute, GraphState graphState) {
        throw new NoSuchElementException(charAttribute.getKey());
    }

    protected int getInt(IntAttribute intAttribute, GraphState graphState) {
        throw new NoSuchElementException(intAttribute.getKey());
    }

    protected long getLong(LongAttribute longAttribute, GraphState graphState) {
        throw new NoSuchElementException(longAttribute.getKey());
    }

    protected float getFloat(FloatAttribute floatAttribute, GraphState graphState) {
        throw new NoSuchElementException(floatAttribute.getKey());
    }

    protected double getDouble(DoubleAttribute doubleAttribute, GraphState graphState) {
        throw new NoSuchElementException(doubleAttribute.getKey());
    }

    protected Object getObject(ObjectAttribute objectAttribute, Object object, GraphState graphState) {
        throw new NoSuchElementException(objectAttribute.getKey());
    }

    public final void initXClass(XClass xClass) {
        this.getXData().init(xClass);
    }

    public final XClass getXClass() {
        return this.data != null ? this.data.cls : null;
    }

    public final synchronized NodeData getXData() {
        if (this.data == null) {
            this.data = new NodeData();
        }
        return this.data;
    }

    public Object getOrNull(Object object) {
        return this.get(object, null);
    }

    public Object get(Object object, Object object2) {
        AttributeAccessor attributeAccessor;
        if (object instanceof Attribute) {
            attributeAccessor = this.getAccessor((Attribute)object);
        } else if (object instanceof String) {
            ManageableType.Field field;
            attributeAccessor = this.getAccessor((String)object);
            if (attributeAccessor == null && (field = this.getNType().getManagedField((String)object)) != null) {
                return field.get(this, null);
            }
        } else {
            attributeAccessor = null;
        }
        return attributeAccessor == null ? object2 : attributeAccessor.getAttribute().get(this, true, GraphState.current(this.manager));
    }

    public final Edge getNext(Node node) {
        return node == this ? this.targetNext : this.next;
    }

    public final Node getSource() {
        return this.parent;
    }

    public final Node getTarget() {
        return this;
    }

    public boolean isSource(Node node) {
        return node == this.parent;
    }

    public boolean isTarget(Node node) {
        return node == this;
    }

    public boolean isDirection(Node node, Node node2) {
        return node == this.parent || node2 == this;
    }

    public final Node getNeighbor(Node node) {
        return node == this ? this.parent : this;
    }

    public final Edge getFirstEdge() {
        return this.parent == null ? this.targetNext : this;
    }

    public final Edge getEdgeTo(Node node) {
        for (Edge edge = this.targetNext; edge != null; edge = edge.getNext(this)) {
            if (edge.getTarget() != node) continue;
            return edge;
        }
        return null;
    }

    public final int getEdgeBitsTo(Node node) {
        for (Edge edge = this.targetNext; edge != null; edge = edge.getNext(this)) {
            if (edge.getTarget() != node) continue;
            return edge.edgeBits;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Edge getOrCreateEdgeTo(Node node) {
        if (node == this) {
            throw new IllegalArgumentException("Cannot create an edge from a node to itself");
        }
        if (this.id < node.id) {
            Node node2 = this;
            synchronized (node2) {
                Node node3 = node;
                synchronized (node3) {
                    return this.getOrCreateEdgeSync(node);
                }
            }
        }
        if (node.id < 0L) {
            return this.getOrCreateEdgeSync(node);
        }
        Node node4 = node;
        synchronized (node4) {
            Node node5 = this;
            synchronized (node5) {
                return this.getOrCreateEdgeSync(node);
            }
        }
    }

    private Edge getOrCreateEdgeSync(Node node) {
        Edge edge;
        Edge edge2 = this;
        for (edge = this.targetNext; edge != null; edge = edge.getNext(this)) {
            if (edge.getTarget() == node) {
                return edge;
            }
            edge2 = edge;
        }
        if (node.parent == null) {
            node.parent = this;
            edge = node;
        } else {
            EdgeImpl edgeImpl = new EdgeImpl(this, node);
            edgeImpl.targetNext = node.targetNext;
            node.setNext(edgeImpl, node);
            edge = edgeImpl;
        }
        edge.setNext(edge2.getNext(this), this);
        edge2.setNext(edge, this);
        return edge;
    }

    void removeEdge(Edge edge) {
        if (edge == this) {
            this.parent = null;
            return;
        }
        Edge edge2 = this;
        for (Edge edge3 = this.targetNext; edge3 != null; edge3 = edge3.getNext(this)) {
            if (edge3 == edge) {
                edge2.setNext(edge3.getNext(this), this);
                return;
            }
            edge2 = edge3;
        }
    }

    public final void removeAll(Transaction transaction) {
        if (this.parent != null) {
            this.remove(transaction);
        }
        while (this.targetNext != null) {
            this.targetNext.remove(transaction);
        }
    }

    public final void addEdgeBitsTo(Node node, int n, Transaction transaction) {
        this.getOrCreateEdgeTo(node).addEdgeBits(n, transaction);
    }

    public final void removeEdgeBitsTo(Node node, int n, Transaction transaction) {
        Edge edge = this.getEdgeTo(node);
        if (edge != null) {
            edge.removeEdgeBits(n, transaction);
        }
    }

    public String toString() {
        return this.getNType() == null ? super.toString() : this.getNType().getName() + '[' + this.paramString() + "]@" + Integer.toHexString(System.identityHashCode(this));
    }

    protected String paramString() {
        return "id=" + this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String string) {
        String string2;
        String string3 = string2 = this.data != null ? this.data.name : null;
        if (Utils.equal(string, string2)) {
            return;
        }
        NodeData nodeData = this.getXData();
        if (this.manager != null) {
            XHashMap<String, Node> xHashMap;
            XHashMap<String, Node> xHashMap2 = xHashMap = this.manager.nodeForName;
            synchronized (xHashMap2) {
                if (string2 != null) {
                    xHashMap.remove(string2, this);
                }
                if (string != null) {
                    xHashMap.add(string, this);
                }
                nodeData.name = string;
            }
        } else {
            nodeData.name = string;
        }
    }

    public final String getName() {
        return this.data != null ? this.data.name : null;
    }

    public final boolean hasName(String string) {
        return Utils.equal(string, this.data != null ? this.data.name : null);
    }

    public void setLayer(int n) {
        this.bits = this.bits & 0xFFFFFFF0 | n & 0xF;
    }

    public int getLayer() {
        return this.bits & 0xF;
    }

    public void setExtentIndex(int n) {
        this.bits = this.bits & 0xFFFFFC7F | n << 7 & 0x380;
    }

    public int getExtentIndex() {
        return (this.bits & 0x380) >> 7;
    }

    public void setMark(boolean bl) {
        this.bits = bl ? (this.bits |= 0x400) : (this.bits &= 0xFFFFFBFF);
    }

    public boolean isMarked() {
        return (this.bits & 0x400) != 0;
    }

    public int getSymbol() {
        return 0;
    }

    public int getSymbolColor() {
        return 11711232;
    }

    public int getUserFieldCount() {
        return this.getNType().getUserFields().length;
    }

    public Field getUserField(int n) {
        return this.getNType().getUserFields()[n];
    }

    public Instantiator getInstantiator() {
        Method method = this.getNType().getInstantiatorMethod;
        if (method == null) {
            return null;
        }
        try {
            return (Instantiator)method.invoke(this, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public boolean instantiateGraph(int n, ArrayPath arrayPath, Visitor visitor) {
        GraphState graphState = visitor.getGraphState();
        graphState.instantiateEdge(n, true, -1L);
        graphState.instantiate(this, true, this.manager != null ? this.id : (long)this.hashCode());
        arrayPath.pushEdges(n, true, -1L, true);
        arrayPath.pushNode(this, this.manager != null ? this.id : (long)this.hashCode());
        boolean bl = true;
        Object object = visitor.visitEnter(arrayPath, false);
        if (object != Visitor.STOP) {
            bl = this.instantiate0(graphState, arrayPath, visitor);
        }
        bl &= visitor.visitLeave(object, arrayPath, false);
        if (arrayPath != null) {
            arrayPath.popNode();
            arrayPath.popEdgeSet();
        }
        graphState.deinstantiate();
        graphState.deinstantiate();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean instantiate0(GraphState graphState, ArrayPath arrayPath, Visitor visitor) {
        Object object;
        Graph graph = graphState.getGraph();
        Object object2 = visitor.visitEnter(arrayPath, true);
        if (object2 == Visitor.STOP) return visitor.visitLeave(object2, arrayPath, true);
        Instantiator instantiator = graph.getInstantiator(this);
        if (instantiator != null) {
            boolean bl = true;
            object = visitor.visitInstanceEnter();
            if (object != Visitor.STOP) {
                try {
                    graphState.beginInstancing(this, this.manager != null ? this.id : (long)this.hashCode());
                    bl = instantiator.instantiate(arrayPath, visitor);
                }
                finally {
                    graphState.endInstancing();
                }
            }
            if (!(bl & visitor.visitInstanceLeave(object))) return visitor.visitLeave(object2, arrayPath, true);
        }
        for (object = this.getFirstEdge(); object != null; object = ((Edge)object).getNext(this)) {
            Node node = ((Edge)object).getTarget();
            if (node == this) continue;
            graphState.instantiate(object, false, -1L);
            graphState.instantiate(node, true, this.manager != null ? this.id : (long)this.hashCode());
            arrayPath.pushEdgeSet(object, -1L, false);
            arrayPath.pushNode(node, this.manager != null ? node.id : (long)node.hashCode());
            Object object3 = visitor.visitEnter(arrayPath, false);
            boolean bl = object3 == Visitor.STOP || node.instantiate0(graphState, arrayPath, visitor);
            bl &= visitor.visitLeave(object3, arrayPath, false);
            if (arrayPath != null) {
                arrayPath.popNode();
                arrayPath.popEdgeSet();
            }
            graphState.deinstantiate();
            graphState.deinstantiate();
            if (!bl) return visitor.visitLeave(object2, arrayPath, true);
        }
        return visitor.visitLeave(object2, arrayPath, true);
    }

    public Node findAdjacent(boolean bl, boolean bl2, int n) {
        for (Edge edge = this.getFirstEdge(); edge != null; edge = edge.getNext(this)) {
            if (!edge.testEdgeBits(n)) continue;
            if (bl2 && edge.getSource() == this) {
                return edge.getTarget();
            }
            if (!bl || edge.getTarget() != this) continue;
            return edge.getSource();
        }
        return null;
    }

    public Node getFirst(int n) {
        return this.findAdjacent(false, true, n);
    }

    public Node getBranch() {
        return this.findAdjacent(false, true, 512);
    }

    public Node getBranchTail() {
        Node node = null;
        for (Node node2 = this.findAdjacent(false, true, 512); node2 != null; node2 = node2.getSuccessor()) {
            node = node2;
        }
        return node;
    }

    public int getBranchLength() {
        int n = 0;
        for (Node node = this.getBranch(); node != null; node = node.getSuccessor()) {
            ++n;
        }
        return n;
    }

    public Node getAxisParent() {
        Node node = this;
        while (true) {
            for (Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
                Node node2 = edge.getSource();
                if (node2 == node) continue;
                int n = edge.getEdgeBits();
                if ((n & 0x100) != 0) {
                    node = node2;
                    continue;
                }
                if ((n & 0x200) == 0) continue;
                return node2;
            }
            break;
        }
        return null;
    }

    public Node getSuccessor() {
        return this.findAdjacent(false, true, 256);
    }

    public Node getPredecessor() {
        return this.findAdjacent(true, false, 256);
    }

    public Node getBranchNode(int n) {
        Node node;
        if (n < 0) {
            return null;
        }
        for (node = this.getBranch(); node != null && n-- > 0; node = node.getSuccessor()) {
        }
        return node;
    }

    public int getIndex() {
        int n = 0;
        Node node = this;
        while ((node = node.findAdjacent(true, false, 256)) != null) {
            ++n;
        }
        return n;
    }

    public void appendBranchNode(Node node, Transaction transaction) {
        if (node == null) {
            return;
        }
        Node node2 = this.getBranchTail();
        if (node2 != null) {
            node2.getOrCreateEdgeTo(node).addEdgeBits(256, transaction);
        } else {
            this.getOrCreateEdgeTo(node).addEdgeBits(512, transaction);
        }
    }

    public void appendBranchNode(Node node) {
        this.appendBranchNode(node, null);
    }

    public void insertBranchNode(int n, Node node, Transaction transaction) {
        Node node2 = this.getBranch();
        if (node2 == null) {
            this.getOrCreateEdgeTo(node).addEdgeBits(512, transaction);
        } else if (n == 0) {
            this.setBranch(node, transaction);
            node.setSuccessor(node2);
        } else {
            Node node3;
            do {
                node3 = node2;
                node2 = node3.getSuccessor();
                if (--n != 0) continue;
                node3.setSuccessor(node, transaction);
                node.setSuccessor(node2, transaction);
                return;
            } while (node2 != null);
            node3.setSuccessor(node, transaction);
        }
    }

    public void insertBranchNode(int n, Node node) {
        this.insertBranchNode(n, node, null);
    }

    public void setBranch(Node node, Transaction transaction) {
        Node node2 = this.getBranch();
        if (node2 != node) {
            if (node2 != null) {
                this.getEdgeTo(node2).removeEdgeBits(512, transaction);
            }
            if (node != null) {
                this.getOrCreateEdgeTo(node).addEdgeBits(512, transaction);
            }
        }
    }

    public void setBranch(Node node) {
        this.setBranch(node, null);
    }

    public void setSuccessor(Node node, Transaction transaction) {
        Node node2 = this.getSuccessor();
        if (node2 != node) {
            if (node2 != null) {
                this.getEdgeTo(node2).removeEdgeBits(256, transaction);
            }
            if (node != null) {
                this.getOrCreateEdgeTo(node).addEdgeBits(256, transaction);
            }
        }
    }

    public void setSuccessor(Node node) {
        this.setSuccessor(node, null);
    }

    public boolean isAncestorOf(Node node) {
        while (node != null) {
            if (node == this) {
                return true;
            }
            node = node.getAxisParent();
        }
        return false;
    }

    public Node getCommonAncestor(Node node) {
        for (Node node2 = this; node2 != null; node2 = node2.getAxisParent()) {
            if (!node2.isAncestorOf(node)) continue;
            return node2;
        }
        return null;
    }

    public void removeFromChain() {
        this.removeFromChain(null);
    }

    public void removeFromChain(Transaction transaction) {
        Node node = this.getPredecessor();
        Node node2 = this.getSuccessor();
        this.setSuccessor(null);
        if (node != null) {
            node.setSuccessor(node2, transaction);
        } else {
            node = this.getAxisParent();
            if (node != null) {
                node.setBranch(node2, transaction);
            }
        }
    }

    public void fieldModified(PersistenceField persistenceField, int[] nArray, Transaction transaction) {
        Object object;
        ++this.stamp;
        if ((this.bits & 0x20) != 0 && !Transaction.isApplying(transaction)) {
            boolean bl = true;
            for (Edge edge = this.getFirstEdge(); edge != null; edge = edge.getNext(this)) {
                Node node;
                int n = edge.edgeBits;
                if ((n & 0xFF) != 0 && (node = (n & 0x80) != 0 ? edge.getSource() : edge.getTarget()) != this) {
                    object = node.getNTypeImpl().specialEdgeFields;
                    if (node.getNTypeImpl().specialEdgeFields != null && object[n & 0xFF] != null) {
                        bl = false;
                        node.specialEdgeRefModified(this, object[n & 0xFF], persistenceField, nArray, transaction);
                    }
                }
                if ((n & 0x4000) == 0 || (node = edge.getTarget()) == this) continue;
                bl = false;
                ((Observer)((Object)node)).fieldModified(this, persistenceField, nArray, transaction);
            }
            if (bl) {
                this.bits &= 0xFFFFFFDF;
            }
        }
        if (persistenceField.length() == 1) {
            NType.Field field = (NType.Field)persistenceField.getSubfield(0);
            int n = field.specialEdge;
            if (n != 0) {
                boolean bl = (n & 0x80) != 0;
                Object object2 = field.getObject(this);
                for (object = this.getFirstEdge(); object != null; object = ((Edge)object).getNext(this)) {
                    Node node;
                    if ((((Edge)object).edgeBits & 0xFF) != n || this == (node = bl ? ((Edge)object).getTarget() : ((Edge)object).getSource())) continue;
                    if (node == object2) {
                        field = null;
                        continue;
                    }
                    ((Edge)object).removeEdgeBits(n, transaction);
                }
                if (field != null && object2 instanceof Node) {
                    (bl ? this.getOrCreateEdgeTo((Node)object2) : ((Node)object2).getOrCreateEdgeTo(this)).addEdgeBits(n, transaction);
                }
            }
        }
        if (transaction != null && this.getProvider() != null) {
            transaction.fireSharedObjectModified(this);
        }
        if (this.manager != null && persistenceField.length() == 1 && persistenceField.getSubfield(0) == extentIndex$FIELD) {
            if (transaction != null) {
                ((GraphTransaction)transaction).extentIndexChanged.add(this);
            } else {
                this.manager.getExtent(this.getNType()).reenqueue(this);
            }
        }
    }

    public int getStamp() {
        return this.stamp;
    }

    protected void specialEdgeRefModified(Node node, NType.Field field, PersistenceField persistenceField, int[] nArray, Transaction transaction) {
        this.fieldModified(field, null, transaction);
    }

    protected void edgeChanged(Edge edge, int n, Transaction transaction) {
        int n2 = edge.edgeBits & 0xFF;
        if (n2 != 0 || (edge.edgeBits & 0x4000) != 0 && edge.getSource() == this) {
            this.bits |= 0x20;
        }
        if (n2 != (n &= 0xFF) && Transaction.isNotApplying(transaction)) {
            if (n != 0) {
                this.specialEdgeRemoved(edge, n, transaction);
            }
            if (n2 != 0) {
                this.specialEdgeAdded(edge, transaction);
            }
        }
    }

    protected void specialEdgeRemoved(Edge edge, int n, Transaction transaction) {
        Node node;
        NType.Field field;
        NType nType = this.getNTypeImpl();
        NType.Field[] fieldArray = nType.specialEdgeFields;
        if (nType.specialEdgeFields != null && (field = fieldArray[n]) != null && this != (node = (n & 0x80) != 0 ? edge.getTarget() : edge.getSource()) && field.getObject(this) == node) {
            field.setObject(this, null, null, transaction);
        }
    }

    protected void specialEdgeAdded(Edge edge, Transaction transaction) {
        Node node;
        NType.Field field;
        int n = edge.edgeBits & 0xFF;
        NType nType = this.getNTypeImpl();
        NType.Field[] fieldArray = nType.specialEdgeFields;
        if (nType.specialEdgeFields != null && (field = fieldArray[n]) != null && this != (node = (n & 0x80) != 0 ? edge.getTarget() : edge.getSource()) && field.getObject(this) != node) {
            field.setObject(this, null, node, transaction);
        }
    }

    public void initProvider(SharedObjectProvider sharedObjectProvider) {
        NodeData nodeData = this.getXData();
        if (nodeData.sop != null) {
            throw new IllegalStateException();
        }
        nodeData.sop = sharedObjectProvider;
    }

    public SharedObjectProvider getProvider() {
        return this.data != null ? this.data.sop : null;
    }

    public synchronized void addReference(SharedObjectReference sharedObjectReference) {
        NodeData nodeData = this.getXData();
        if (nodeData.refs == null) {
            nodeData.refs = new ObjectList(4, false);
        }
        nodeData.refs.add(sharedObjectReference);
    }

    public synchronized void removeReference(SharedObjectReference sharedObjectReference) {
        NodeData nodeData = this.data;
        if (nodeData != null && nodeData.refs != null) {
            nodeData.refs.remove(sharedObjectReference);
        }
    }

    public synchronized void appendReferencesTo(List list) {
        NodeData nodeData = this.data;
        if (nodeData != null && nodeData.refs != null) {
            list.addAll(nodeData.refs);
        }
    }

    public void dumpTree() {
        this.dumpTree(0);
    }

    private void dumpTree(int n) {
        for (int i = n * 2; i > 0; --i) {
            System.out.print(' ');
        }
        System.out.println(this);
        for (Node node = this.getBranch(); node != null; node = node.getSuccessor()) {
            node.dumpTree(n + 1);
        }
    }

    public void dump() {
        this.dump(0, new StringBuffer(), null);
    }

    private void dump(int n, StringBuffer stringBuffer, Edge edge) {
        for (int i = n * 2; i > 0; --i) {
            System.out.print(' ');
        }
        System.out.print(this);
        if (edge != null) {
            System.out.print(' ');
            stringBuffer.setLength(0);
            edge.getEdgeKeys(stringBuffer, false, false);
            System.out.print(stringBuffer);
        }
        System.out.println();
        for (Edge edge2 = this.getFirstEdge(); edge2 != null; edge2 = edge2.getNext(this)) {
            Node node = edge2.getTarget();
            if (node == this) continue;
            node.dump(n + 1, stringBuffer, edge2);
        }
    }

    public GraphManager setGraphForDeserialization(GraphManager graphManager) {
        WeakReference<GraphManager> weakReference = DESERIALIZATION_MANAGER.get();
        DESERIALIZATION_MANAGER.set(new WeakReference<GraphManager>(graphManager));
        return weakReference != null ? (GraphManager)weakReference.get() : null;
    }

    protected Object writeReplace() {
        return this.id >= 0L ? new SerializationHandle(this) : this;
    }

    static {
        MIME_TYPE = new MimeType("application/x-grogra-graph");
        $TYPE = new NType(new Node());
        name$FIELD = new NType.Field($TYPE, "name", 0x200000, Type.STRING, null, true, null);
        $TYPE.addManagedField(name$FIELD);
        $TYPE.declareFieldAttribute(name$FIELD, Attributes.NAME);
        layer$FIELD = new NType.BitField($TYPE, "layer", 0x200000, Type.INT, 15);
        $TYPE.addManagedField(layer$FIELD);
        $TYPE.declareFieldAttribute(layer$FIELD, Attributes.LAYER);
        extentIndex$FIELD = new NType.BitField($TYPE, "extentIndex", 0x2200000, Type.INT, 896);
        $TYPE.addManagedField(extentIndex$FIELD);
        extentTail$FIELD = new NType.BitField($TYPE, "extentTail", 0x2200000, Type.BOOLEAN, 896);
        mark$FIELD = new NType.BitField($TYPE, "mark", 0x2200000, Type.BOOLEAN, 1024);
        $TYPE.addManagedField(mark$FIELD);
        isInterpretive$FIELD = new NType.BitField($TYPE, "isInterpretive", 0x2200000, Type.BOOLEAN, 64);
        $TYPE.addManagedField(isInterpretive$FIELD);
        class FieldsAccessor
        extends ObjectAttribute.IdentityAccessor {
            FieldsAccessor(ObjectAttribute objectAttribute) {
            }

            public Object setSubfield(Object object, FieldChain fieldChain, int[] nArray, Object object2, GraphState graphState) {
                new IndirectField().add(fieldChain).set(object, nArray, object2, ((State)graphState).getActiveTransaction());
                return object2;
            }

            public boolean isWritable(Object object, GraphState graphState) {
                return true;
            }
        }
        $TYPE.addAccessor(new FieldsAccessor(Attributes.USER_FIELDS));
        ADDITIONAL_FIELDS = Attributes.init(new ObjectAttribute($TYPE.getClass(), false, null), "additionalFields", GraphManager.I18N);
        $TYPE.addAccessor(new FieldsAccessor(ADDITIONAL_FIELDS));
        $TYPE.declareSpecialEdge(1, "edgenode.in", new Node[0]);
        $TYPE.declareSpecialEdge(128, "edgenode.out", new Node[0]);
        $TYPE.validate();
        DESERIALIZATION_MANAGER = new ThreadLocal();
    }

    private static final class SerializationHandle
    implements Serializable {
        private static final long serialVersionUID = 5434810166185154007L;
        private final long id;

        SerializationHandle(Node node) {
            this.id = node.id;
        }

        Object readResolve() throws ObjectStreamException {
            WeakReference<GraphManager> weakReference = DESERIALIZATION_MANAGER.get();
            if (weakReference == null) {
                throw new NotActiveException("GraphManager not set");
            }
            GraphManager graphManager = (GraphManager)weakReference.get();
            if (graphManager == null) {
                throw new NotActiveException("GraphManager has been garbage-collected");
            }
            Node node = graphManager.getObject(this.id);
            if (node == null) {
                throw new InvalidObjectException("GraphManager has no node with id " + this.id);
            }
            return node;
        }
    }

    public static class NType
    extends ManageableType {
        int usedBitMasks;
        Field[] specialEdgeFields = null;
        final AccessorMap accessors;
        final AttributeDependencies dependencies;
        final Method getInstantiatorMethod;
        private Node representative;
        private StringMap aliasFields;
        private IntHashMap specialEdgeDescriptors = null;
        private XHashMap specialEdgeDescriptorsForKey = null;
        private ObjectList specialEdgeDescOfSource = null;
        private ObjectList specialEdgeDescOfTarget = null;
        private de.grogra.reflect.Field[] userFields;
        private final HashMap methods = new HashMap();

        public NType(Node node) {
            this(node.getXClass() != null ? node.getXClass() : ClassAdapter.wrap(node.getClass()), node);
        }

        public NType(Class clazz) {
            this(ClassAdapter.wrap(clazz), null);
        }

        public static NType create(Type type, NType nType) {
            return new NType(type, nType, null);
        }

        private NType(Type type, Node node) {
            this(type, (NType)NType.forType(type.getSupertype()), node);
        }

        private NType(Type type, NType nType, Node node) {
            super(type, nType, false);
            this.accessors = nType == null ? new AccessorMap() : new AccessorMap(nType.accessors);
            this.dependencies = nType == null ? new AttributeDependencies() : new AttributeDependencies(nType.dependencies);
            this.usedBitMasks = nType == null ? 32 : nType.usedBitMasks;
            this.specialEdgeDescOfSource = nType == null ? new ObjectList() : nType.specialEdgeDescOfSource;
            this.specialEdgeDescOfTarget = nType == null ? new ObjectList() : nType.specialEdgeDescOfTarget;
            this.representative = node;
            this.dup(nType);
            Method method = Reflection.findMethodWithPrefixInTypes(type, "mgetInstantiator;()", false, true);
            if (method != null && Node.class.getName().equals(method.getDeclaringType().getBinaryName())) {
                method = null;
            }
            this.getInstantiatorMethod = method;
        }

        private void dup(NType nType) {
            if (nType != null && nType.specialEdgeFields != null) {
                this.specialEdgeFields = (Field[])nType.specialEdgeFields.clone();
            }
        }

        public final Object getRepresentative() {
            return this.representative;
        }

        public Object newInstance() throws InvocationTargetException, InstantiationException, IllegalAccessException {
            if (this.representative != null) {
                try {
                    Node node = this.representative.newInstance();
                    XClass xClass = this.representative.getXClass();
                    if (xClass != null) {
                        node.initXClass(xClass);
                    }
                    return node;
                }
                catch (RuntimeException runtimeException) {
                    throw new InvocationTargetException(runtimeException);
                }
            }
            return super.newInstance();
        }

        public final void addDependency(Attribute attribute, Attribute attribute2) {
            if (this.finished) {
                throw new IllegalStateException();
            }
            this.dependencies.add(attribute, attribute2);
        }

        public final void addAccessor(AttributeAccessor attributeAccessor) {
            if (this.finished) {
                throw new IllegalStateException();
            }
            this.accessors.add(attributeAccessor);
        }

        public final void addIdentityAccessor(ObjectAttribute objectAttribute) {
            this.addAccessor(objectAttribute.new ObjectAttribute.IdentityAccessor());
        }

        public final void declareFieldAttribute(Field field, Attribute attribute) {
            this.addAccessor(new FieldAttributeAccessor(attribute, field));
            this.setAttribute(field, attribute);
        }

        public final void declareFieldAttribute(Field field, Attribute attribute, double d) {
            this.addAccessor(new FieldAttributeAccessor(attribute, field, d));
            this.setAttribute(field, attribute);
        }

        public final void setDependentAttribute(Field field, Attribute attribute) {
            if (this.finished) {
                throw new IllegalStateException();
            }
            field.dependentAttribute = attribute;
        }

        public final void setAttribute(Field field, Attribute attribute) {
            if (this.finished) {
                throw new IllegalStateException();
            }
            field.dependentAttribute = attribute;
            field.attribute = attribute;
        }

        public final int getAttributeCount() {
            return this.accessors.size();
        }

        public final AttributeAccessor getAccessor(int n) {
            return this.accessors.getAccessor(n);
        }

        public final AttributeAccessor getAccessorById(int n) {
            return this.accessors.getAccessorById(n);
        }

        public final synchronized Method getMethod(String string) {
            Object object = this.methods.get(string);
            if (object == this) {
                return null;
            }
            if (object == null) {
                object = Reflection.findMethodWithPrefixInTypes(this, string, false, true);
                this.methods.put(string, object != null ? object : this);
            }
            return (Method)object;
        }

        public final void setSpecialEdgeField(Field field, int n) {
            if (this.finished) {
                throw new IllegalStateException();
            }
            if ((n & 0xFF) == 0 || (n & 0xFFFFFF00) != 0) {
                throw new IllegalArgumentException("Special edge " + n);
            }
            field.specialEdge = n;
            if (this.specialEdgeFields == null) {
                this.specialEdgeFields = new Field[256];
            }
            this.specialEdgeFields[n] = field;
        }

        public SpecialEdgeDescriptor getSpecialEdgeDescriptor(int n) {
            for (NType nType = this; nType != null; nType = (NType)nType.getManageableSupertype()) {
                Object object;
                if (nType.specialEdgeDescriptors == null || (object = nType.specialEdgeDescriptors.get(n, null)) == null) continue;
                return (SpecialEdgeDescriptor)object;
            }
            return null;
        }

        public SpecialEdgeDescriptor getSpecialEdgeDescriptor(String string) {
            for (NType nType = this; nType != null; nType = (NType)nType.getManageableSupertype()) {
                Object object;
                if (nType.specialEdgeDescriptorsForKey == null || (object = nType.specialEdgeDescriptorsForKey.get(string, null)) == null) continue;
                return (SpecialEdgeDescriptor)object;
            }
            return null;
        }

        public void declareSpecialEdge(int n, String string, Object[] objectArray) {
            I18NBundle i18NBundle;
            if (this.finished) {
                throw new IllegalStateException();
            }
            if (this.specialEdgeDescriptors == null) {
                this.specialEdgeDescriptors = new IntHashMap(4);
                this.specialEdgeDescriptorsForKey = new XHashMap(4);
                this.specialEdgeDescOfSource = new ObjectList().addAll(this.specialEdgeDescOfSource);
                this.specialEdgeDescOfTarget = new ObjectList().addAll(this.specialEdgeDescOfTarget);
            }
            try {
                i18NBundle = I18NBundle.getInstance(this.getImplementationClass());
            }
            catch (MissingResourceException missingResourceException) {
                i18NBundle = null;
            }
            SpecialEdgeDescriptor specialEdgeDescriptor = new SpecialEdgeDescriptor(i18NBundle, string, n, objectArray.getClass().getComponentType());
            if (this.specialEdgeDescriptors.put(n, specialEdgeDescriptor) != null) {
                throw new IllegalArgumentException(n + " already declared");
            }
            if (this.specialEdgeDescriptorsForKey.put(string, specialEdgeDescriptor) != null) {
                throw new IllegalArgumentException(string + " already declared");
            }
            ((n & 0x80) != 0 ? this.specialEdgeDescOfSource : this.specialEdgeDescOfTarget).add(specialEdgeDescriptor);
        }

        SpecialEdgeDescriptor[] getSpecialEdgeDescriptors(boolean bl) {
            ObjectList objectList = bl ? this.specialEdgeDescOfSource : this.specialEdgeDescOfTarget;
            return objectList.toArray(new SpecialEdgeDescriptor[objectList.size()]);
        }

        public void declareAlias(String string, PersistenceField persistenceField) {
            if (this.finished) {
                throw new IllegalStateException();
            }
            if (this.aliasFields == null) {
                this.aliasFields = new StringMap(4);
            }
            this.aliasFields.put(string, (Object)persistenceField);
        }

        public PersistenceField resolveAliasField(String string) {
            Object object;
            if (this.aliasFields != null && (object = this.aliasFields.get(string)) != null) {
                return (PersistenceField)object;
            }
            return super.resolveAliasField(string);
        }

        public ManageableType validate() {
            this.dependencies.validate();
            return super.validate();
        }

        synchronized de.grogra.reflect.Field[] getUserFields() {
            if (this.userFields == null) {
                ObjectList<de.grogra.reflect.Field> objectList = new ObjectList<de.grogra.reflect.Field>();
                for (int i = 0; i < this.getManagedFieldCount(); ++i) {
                    ManageableType.Field field = this.getManagedField(i);
                    de.grogra.reflect.Field field2 = Reflection.getDeclaredField(field.getDeclaringType(), field.getDescriptor());
                    if (field2 == null || !Reflection.isPublic(field2) || Reflection.getDeclaredAnnotation(field2, Editable.class) == null) continue;
                    for (int j = 0; j < field2.getDeclaredAnnotationCount(); ++j) {
                        Annotation annotation = field2.getDeclaredAnnotation(j);
                        TypeImpl typeImpl = null;
                        if (Reflection.equal(Range.class, annotation.annotationType())) {
                            if ((1 << field2.getType().getTypeId() & 0x3D8) != 0) {
                                typeImpl = new BoundedType("bounded", field2.getType().getTypeId(), (Number)annotation.value("min"), (Number)annotation.value("max"));
                            }
                        } else if (Reflection.equal(Choice.class, annotation.annotationType()) && Reflection.isIntegral(field2.getType())) {
                            typeImpl = new EnumerationType("choice", (String[])annotation.value("value"));
                        }
                        if (typeImpl == null) continue;
                        field2 = new FieldDecorator(field2, typeImpl);
                    }
                    objectList.add(field2);
                }
                this.userFields = new de.grogra.reflect.Field[objectList.size()];
                objectList.toArray(this.userFields);
            }
            return this.userFields;
        }

        public static final class BitField
        extends Field {
            private final int mask;
            private final int position;

            public BitField(NType nType, String string, int n, Type type, int n2) {
                super(nType, string, n, type, null, false, null);
                if (!"extentTail".equals(string) && (nType.usedBitMasks & n2) != 0) {
                    throw new AssertionError((Object)("Bitmasks overlap: " + nType + '.' + string));
                }
                nType.usedBitMasks |= n2;
                this.mask = n2;
                for (int i = 0; i < 32; ++i) {
                    if ((n2 & 1) != 0) {
                        this.position = i;
                        return;
                    }
                    n2 >>>= 1;
                }
                throw new AssertionError((Object)("Bitmask is 0: " + nType + '.' + string));
            }

            public void setBoolean(Object object, boolean bl) {
                ((Node)object).bits = bl ? (((Node)object).bits |= this.mask) : (((Node)object).bits &= ~this.mask);
            }

            public boolean getBoolean(Object object) {
                return (((Node)object).bits & this.mask) != 0;
            }

            public void setInt(Object object, int n) {
                ((Node)object).bits = ((Node)object).bits & ~this.mask | n << this.position & this.mask;
            }

            public int getInt(Object object) {
                return (((Node)object).bits & this.mask) >>> this.position;
            }
        }

        public static class Field
        extends ManageableType.Field
        implements XObject {
            Attribute attribute;
            Attribute dependentAttribute;
            int specialEdge;
            private final de.grogra.reflect.Field wrappedField;
            private final boolean nameField;
            private transient XClass cls;
            private transient XData data;

            public final void initXClass(XClass xClass) {
                if (this.cls != null) {
                    throw new IllegalStateException();
                }
                this.cls = xClass;
                this.data = new XData();
                this.data.init(xClass);
            }

            public final XClass getXClass() {
                return this.cls;
            }

            public final XData getXData() {
                return this.data;
            }

            public Field(NType nType, String string, int n, Type type, Type type2) {
                this(nType, string, n, type, type2, false, null);
            }

            public Field(NType nType, String string, int n, Class clazz, Class clazz2, boolean bl) {
                this(nType, string, n, ClassAdapter.wrap(clazz), clazz2 == null ? null : ClassAdapter.wrap(clazz2), false, bl ? Reflection.getDeclaredField(nType, string) : null);
            }

            public Field(NType nType, de.grogra.reflect.Field field, int n) {
                this(nType, field.getSimpleName(), n, field.getType(), null, false, field);
            }

            Field(NType nType, String string, int n, Type type, Type type2, boolean bl, de.grogra.reflect.Field field) {
                NType nType2 = nType;
                nType2.getClass();
                super(nType2, string, n, type, type2);
                this.attribute = null;
                this.dependentAttribute = null;
                this.specialEdge = 0;
                this.nameField = bl;
                this.wrappedField = field;
            }

            public final Attribute getAttribute() {
                return this.attribute;
            }

            public final Attribute getDependentAttribute() {
                return this.dependentAttribute;
            }

            public void setBoolean(Object object, boolean bl) {
                if (this.wrappedField != null) {
                    try {
                        this.wrappedField.setBoolean(object, bl);
                    }
                    catch (Exception exception) {
                        throw new WrapException(exception);
                    }
                } else {
                    super.setBoolean(object, bl);
                }
            }

            public boolean getBoolean(Object object) {
                if (this.wrappedField == null) {
                    return super.getBoolean(object);
                }
                try {
                    return this.wrappedField.getBoolean(object);
                }
                catch (Exception exception) {
                    throw new WrapException(exception);
                }
            }

            public void setByte(Object object, byte by) {
                if (this.wrappedField != null) {
                    try {
                        this.wrappedField.setByte(object, by);
                    }
                    catch (Exception exception) {
                        throw new WrapException(exception);
                    }
                } else {
                    super.setByte(object, by);
                }
            }

            public byte getByte(Object object) {
                if (this.wrappedField == null) {
                    return super.getByte(object);
                }
                try {
                    return this.wrappedField.getByte(object);
                }
                catch (Exception exception) {
                    throw new WrapException(exception);
                }
            }

            public void setShort(Object object, short s) {
                if (this.wrappedField != null) {
                    try {
                        this.wrappedField.setShort(object, s);
                    }
                    catch (Exception exception) {
                        throw new WrapException(exception);
                    }
                } else {
                    super.setShort(object, s);
                }
            }

            public short getShort(Object object) {
                if (this.wrappedField == null) {
                    return super.getShort(object);
                }
                try {
                    return this.wrappedField.getShort(object);
                }
                catch (Exception exception) {
                    throw new WrapException(exception);
                }
            }

            public void setChar(Object object, char c) {
                if (this.wrappedField != null) {
                    try {
                        this.wrappedField.setChar(object, c);
                    }
                    catch (Exception exception) {
                        throw new WrapException(exception);
                    }
                } else {
                    super.setChar(object, c);
                }
            }

            public char getChar(Object object) {
                if (this.wrappedField == null) {
                    return super.getChar(object);
                }
                try {
                    return this.wrappedField.getChar(object);
                }
                catch (Exception exception) {
                    throw new WrapException(exception);
                }
            }

            public void setInt(Object object, int n) {
                if (this.wrappedField != null) {
                    try {
                        this.wrappedField.setInt(object, n);
                    }
                    catch (Exception exception) {
                        throw new WrapException(exception);
                    }
                } else {
                    super.setInt(object, n);
                }
            }

            public int getInt(Object object) {
                if (this.wrappedField == null) {
                    return super.getInt(object);
                }
                try {
                    return this.wrappedField.getInt(object);
                }
                catch (Exception exception) {
                    throw new WrapException(exception);
                }
            }

            public void setLong(Object object, long l) {
                if (this.wrappedField != null) {
                    try {
                        this.wrappedField.setLong(object, l);
                    }
                    catch (Exception exception) {
                        throw new WrapException(exception);
                    }
                } else {
                    super.setLong(object, l);
                }
            }

            public long getLong(Object object) {
                if (this.wrappedField == null) {
                    return super.getLong(object);
                }
                try {
                    return this.wrappedField.getLong(object);
                }
                catch (Exception exception) {
                    throw new WrapException(exception);
                }
            }

            public void setFloat(Object object, float f) {
                if (this.wrappedField != null) {
                    try {
                        this.wrappedField.setFloat(object, f);
                    }
                    catch (Exception exception) {
                        throw new WrapException(exception);
                    }
                } else {
                    super.setFloat(object, f);
                }
            }

            public float getFloat(Object object) {
                if (this.wrappedField == null) {
                    return super.getFloat(object);
                }
                try {
                    return this.wrappedField.getFloat(object);
                }
                catch (Exception exception) {
                    throw new WrapException(exception);
                }
            }

            public void setDouble(Object object, double d) {
                if (this.wrappedField != null) {
                    try {
                        this.wrappedField.setDouble(object, d);
                    }
                    catch (Exception exception) {
                        throw new WrapException(exception);
                    }
                } else {
                    super.setDouble(object, d);
                }
            }

            public double getDouble(Object object) {
                if (this.wrappedField == null) {
                    return super.getDouble(object);
                }
                try {
                    return this.wrappedField.getDouble(object);
                }
                catch (Exception exception) {
                    throw new WrapException(exception);
                }
            }

            protected void setObjectImpl(Object object, Object object2) {
                if (this.nameField) {
                    ((Node)object).setName((String)object2);
                } else if (this.wrappedField != null) {
                    try {
                        this.wrappedField.setObject(object, object2);
                    }
                    catch (Exception exception) {
                        throw new WrapException(exception);
                    }
                } else {
                    super.setObjectImpl(object, object2);
                }
            }

            public Object getObject(Object object) {
                if (this.nameField) {
                    return ((Node)object).getName();
                }
                if (this.wrappedField == null) {
                    return super.getObject(object);
                }
                try {
                    return this.wrappedField.getObject(object);
                }
                catch (Exception exception) {
                    throw new WrapException(exception);
                }
            }
        }
    }

    public static class AccessorBridge
    extends AccessorBase {
        public AccessorBridge(Attribute attribute) {
            super(attribute);
        }

        public boolean isWritable(Object object, GraphState graphState) {
            return false;
        }

        public boolean getBoolean(Object object, GraphState graphState) {
            return ((Node)object).getBoolean((BooleanAttribute)this.attribute, graphState);
        }

        public boolean setBoolean(Object object, boolean bl, GraphState graphState) {
            throw new UnsupportedOperationException();
        }

        public byte getByte(Object object, GraphState graphState) {
            return ((Node)object).getByte((ByteAttribute)this.attribute, graphState);
        }

        public byte setByte(Object object, byte by, GraphState graphState) {
            throw new UnsupportedOperationException();
        }

        public short getShort(Object object, GraphState graphState) {
            return ((Node)object).getShort((ShortAttribute)this.attribute, graphState);
        }

        public short setShort(Object object, short s, GraphState graphState) {
            throw new UnsupportedOperationException();
        }

        public char getChar(Object object, GraphState graphState) {
            return ((Node)object).getChar((CharAttribute)this.attribute, graphState);
        }

        public char setChar(Object object, char c, GraphState graphState) {
            throw new UnsupportedOperationException();
        }

        public int getInt(Object object, GraphState graphState) {
            return ((Node)object).getInt((IntAttribute)this.attribute, graphState);
        }

        public int setInt(Object object, int n, GraphState graphState) {
            throw new UnsupportedOperationException();
        }

        public long getLong(Object object, GraphState graphState) {
            return ((Node)object).getLong((LongAttribute)this.attribute, graphState);
        }

        public long setLong(Object object, long l, GraphState graphState) {
            throw new UnsupportedOperationException();
        }

        public float getFloat(Object object, GraphState graphState) {
            return ((Node)object).getFloat((FloatAttribute)this.attribute, graphState);
        }

        public float setFloat(Object object, float f, GraphState graphState) {
            throw new UnsupportedOperationException();
        }

        public double getDouble(Object object, GraphState graphState) {
            return ((Node)object).getDouble((DoubleAttribute)this.attribute, graphState);
        }

        public double setDouble(Object object, double d, GraphState graphState) {
            throw new UnsupportedOperationException();
        }

        public Object getObject(Object object, GraphState graphState) {
            return ((Node)object).getObject((ObjectAttribute)this.attribute, null, graphState);
        }

        public Object getObject(Object object, Object object2, GraphState graphState) {
            return ((Node)object).getObject((ObjectAttribute)this.attribute, object2, graphState);
        }

        public Object setObject(Object object, Object object2, GraphState graphState) {
            throw new UnsupportedOperationException();
        }
    }

    public static class FieldAttributeAccessor
    extends FieldAccessor
    implements BooleanAttributeAccessor,
    ByteAttributeAccessor,
    ShortAttributeAccessor,
    CharAttributeAccessor,
    IntAttributeAccessor,
    LongAttributeAccessor,
    FloatAttributeAccessor,
    DoubleAttributeAccessor,
    ObjectAttributeAccessor {
        private final Attribute attr;
        private final boolean hasFactor;
        private final double field2Attr;
        private final double attr2Field;

        public FieldAttributeAccessor(Attribute attribute, NType.Field field) {
            super(field);
            this.attr = attribute;
            this.hasFactor = false;
            this.field2Attr = 0.0;
            this.attr2Field = 0.0;
        }

        public FieldAttributeAccessor(Attribute attribute, NType.Field field, double d) {
            super(field);
            this.attr = attribute;
            this.hasFactor = true;
            this.field2Attr = d;
            this.attr2Field = 1.0 / d;
        }

        public final Attribute getAttribute() {
            return this.attr;
        }

        public final Field getField() {
            return Reflection.equal(this.attr.getType(), this.field.getType()) ? this.field : null;
        }

        public boolean isWritable(Object object, GraphState graphState) {
            return !(this.field instanceof PersistenceField) || ((PersistenceField)this.field).isWritable(object);
        }

        public String toString() {
            return "Accessor[" + this.attr + ',' + this.field + ']';
        }

        public Object getObject(Object object, Object object2, GraphState graphState) {
            try {
                return this.getObject(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException.getMessage());
            }
        }

        public boolean getBoolean(Object object, GraphState graphState) {
            try {
                return this.getBoolean(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException.getMessage());
            }
        }

        public boolean setBoolean(Object object, boolean bl, GraphState graphState) {
            try {
                return this.setBoolean(object, bl, ((State)graphState).getActiveTransaction());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException.getMessage());
            }
        }

        public byte getByte(Object object, GraphState graphState) {
            try {
                return this.getByte(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException.getMessage());
            }
        }

        public byte setByte(Object object, byte by, GraphState graphState) {
            try {
                return this.setByte(object, by, ((State)graphState).getActiveTransaction());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException.getMessage());
            }
        }

        public short getShort(Object object, GraphState graphState) {
            try {
                return this.getShort(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException.getMessage());
            }
        }

        public short setShort(Object object, short s, GraphState graphState) {
            try {
                return this.setShort(object, s, ((State)graphState).getActiveTransaction());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException.getMessage());
            }
        }

        public char getChar(Object object, GraphState graphState) {
            try {
                return this.getChar(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException.getMessage());
            }
        }

        public char setChar(Object object, char c, GraphState graphState) {
            try {
                return this.setChar(object, c, ((State)graphState).getActiveTransaction());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException.getMessage());
            }
        }

        public int getInt(Object object, GraphState graphState) {
            try {
                return this.getInt(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException.getMessage());
            }
        }

        public int setInt(Object object, int n, GraphState graphState) {
            try {
                return this.setInt(object, n, ((State)graphState).getActiveTransaction());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException.getMessage());
            }
        }

        public long getLong(Object object, GraphState graphState) {
            try {
                return this.getLong(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException.getMessage());
            }
        }

        public long setLong(Object object, long l, GraphState graphState) {
            try {
                return this.setLong(object, l, ((State)graphState).getActiveTransaction());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException.getMessage());
            }
        }

        public float getFloat(Object object, GraphState graphState) {
            try {
                if (this.hasFactor) {
                    return (float)this.field2Attr * this.getFloat(object);
                }
                return this.getFloat(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException.getMessage());
            }
        }

        public float setFloat(Object object, float f, GraphState graphState) {
            try {
                if (this.hasFactor) {
                    this.setFloat(object, f * (float)this.attr2Field, ((State)graphState).getActiveTransaction());
                    return f;
                }
                return this.setFloat(object, f, ((State)graphState).getActiveTransaction());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException.getMessage());
            }
        }

        public double getDouble(Object object, GraphState graphState) {
            try {
                if (this.hasFactor) {
                    return this.field2Attr * this.getDouble(object);
                }
                return this.getDouble(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException.getMessage());
            }
        }

        public double setDouble(Object object, double d, GraphState graphState) {
            try {
                if (this.hasFactor) {
                    this.setDouble(object, d * this.attr2Field, ((State)graphState).getActiveTransaction());
                    return d;
                }
                return this.setDouble(object, d, ((State)graphState).getActiveTransaction());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException.getMessage());
            }
        }

        public final Object getObject(Object object, GraphState graphState) {
            return this.getObject(object, (Object)null, graphState);
        }

        public Object setObject(Object object, Object object2, GraphState graphState) {
            try {
                return this.setObject(object, object2, ((State)graphState).getActiveTransaction());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException.getMessage());
            }
        }

        public Object setSubfield(Object object, FieldChain fieldChain, int[] nArray, Object object2, GraphState graphState) {
            return this.setSubfield(object, fieldChain, nArray, object2, ((State)graphState).getActiveTransaction());
        }
    }
}

