/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.persistence;

import de.grogra.persistence.FatalPersistenceException;
import de.grogra.persistence.IndirectField;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.PersistenceCapable;
import de.grogra.persistence.PersistenceField;
import de.grogra.persistence.PersistenceManager;
import de.grogra.persistence.Transaction;
import de.grogra.persistence.XAQueue;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Type;
import java.io.IOException;

public class ModificationQueue
extends XAQueue {
    public static final Type TYPE = ClassAdapter.wrap(ModificationQueue.class);
    public static final int SET_BOOLEAN = 1;
    public static final int SET_BYTE = 2;
    public static final int SET_SHORT = 3;
    public static final int SET_CHAR = 4;
    public static final int SET_INT = 5;
    public static final int SET_LONG = 6;
    public static final int SET_FLOAT = 7;
    public static final int SET_DOUBLE = 8;
    public static final int SET_OBJECT = 9;
    public static final int ADD_BYTE = 10;
    public static final int ADD_SHORT = 11;
    public static final int ADD_CHAR = 12;
    public static final int ADD_INT = 13;
    public static final int ADD_LONG = 14;
    public static final int ADD_FLOAT = 15;
    public static final int ADD_DOUBLE = 16;
    public static final int MUL_BYTE = 17;
    public static final int MUL_SHORT = 18;
    public static final int MUL_CHAR = 19;
    public static final int MUL_INT = 20;
    public static final int MUL_LONG = 21;
    public static final int MUL_FLOAT = 22;
    public static final int MUL_DOUBLE = 23;
    public static final int DIV_BYTE = 24;
    public static final int DIV_SHORT = 25;
    public static final int DIV_CHAR = 26;
    public static final int DIV_INT = 27;
    public static final int DIV_LONG = 28;
    public static final int DIV_FLOAT = 29;
    public static final int DIV_DOUBLE = 30;
    public static final int OR_BOOLEAN = 31;
    public static final int OR_BYTE = 32;
    public static final int OR_SHORT = 33;
    public static final int OR_CHAR = 34;
    public static final int OR_INT = 35;
    public static final int OR_LONG = 36;
    public static final int AND_BOOLEAN = 37;
    public static final int AND_BYTE = 38;
    public static final int AND_SHORT = 39;
    public static final int AND_CHAR = 40;
    public static final int AND_INT = 41;
    public static final int AND_LONG = 42;
    public static final int XOR_BOOLEAN = 43;
    public static final int XOR_BYTE = 44;
    public static final int XOR_SHORT = 45;
    public static final int XOR_CHAR = 46;
    public static final int XOR_INT = 47;
    public static final int XOR_LONG = 48;
    public static final int MAKE_PERSISTENT = 49;
    public static final int MIN_UNUSED_ITEM = 50;
    private final Applier applier = this.createApplier();

    public ModificationQueue(PersistenceManager persistenceManager) {
        super(persistenceManager, false);
        this.setItemSize(1, 1, -1, 1, 0, 0, 0);
        this.setItemSize(2, 1, -1, 1, 0, 0, 0);
        this.setItemSize(3, 2, -1, 1, 0, 0, 0);
        this.setItemSize(4, 2, -1, 1, 0, 0, 0);
        this.setItemSize(5, 0, -1, 1, 0, 0, 0);
        this.setItemSize(6, 0, -1, 2, 0, 0, 0);
        this.setItemSize(7, 0, -1, 1, 1, 0, 0);
        this.setItemSize(8, 0, -1, 1, 0, 1, 0);
        this.setItemSize(9, -1, -1, -1, -1, -1, 0);
        this.setItemSize(10, 1, -1, 1, 0, 0, 0);
        this.setItemSize(11, 2, -1, 1, 0, 0, 0);
        this.setItemSize(12, 2, -1, 1, 0, 0, 0);
        this.setItemSize(13, 0, -1, 1, 0, 0, 0);
        this.setItemSize(14, 0, -1, 2, 0, 0, 0);
        this.setItemSize(15, 0, -1, 1, 1, 0, 0);
        this.setItemSize(16, 0, -1, 1, 0, 1, 0);
        this.setItemSize(17, 1, -1, 1, 0, 0, 0);
        this.setItemSize(18, 2, -1, 1, 0, 0, 0);
        this.setItemSize(19, 2, -1, 1, 0, 0, 0);
        this.setItemSize(20, 0, -1, 1, 0, 0, 0);
        this.setItemSize(21, 0, -1, 2, 0, 0, 0);
        this.setItemSize(22, 0, -1, 1, 1, 0, 0);
        this.setItemSize(23, 0, -1, 1, 0, 1, 0);
        this.setItemSize(24, 1, -1, 1, 0, 0, 0);
        this.setItemSize(25, 2, -1, 1, 0, 0, 0);
        this.setItemSize(26, 2, -1, 1, 0, 0, 0);
        this.setItemSize(27, 0, -1, 1, 0, 0, 0);
        this.setItemSize(28, 0, -1, 2, 0, 0, 0);
        this.setItemSize(29, 0, -1, 1, 1, 0, 0);
        this.setItemSize(30, 0, -1, 1, 0, 1, 0);
        this.setItemSize(31, 1, -1, 1, 0, 0, 0);
        this.setItemSize(32, 1, -1, 1, 0, 0, 0);
        this.setItemSize(33, 2, -1, 1, 0, 0, 0);
        this.setItemSize(34, 2, -1, 1, 0, 0, 0);
        this.setItemSize(35, 0, -1, 1, 0, 0, 0);
        this.setItemSize(36, 0, -1, 2, 0, 0, 0);
        this.setItemSize(37, 1, -1, 1, 0, 0, 0);
        this.setItemSize(38, 1, -1, 1, 0, 0, 0);
        this.setItemSize(39, 2, -1, 1, 0, 0, 0);
        this.setItemSize(40, 2, -1, 1, 0, 0, 0);
        this.setItemSize(41, 0, -1, 1, 0, 0, 0);
        this.setItemSize(42, 0, -1, 2, 0, 0, 0);
        this.setItemSize(43, 1, -1, 1, 0, 0, 0);
        this.setItemSize(44, 1, -1, 1, 0, 0, 0);
        this.setItemSize(45, 2, -1, 1, 0, 0, 0);
        this.setItemSize(46, 2, -1, 1, 0, 0, 0);
        this.setItemSize(47, 0, -1, 1, 0, 0, 0);
        this.setItemSize(48, 0, -1, 2, 0, 0, 0);
        this.setItemSize(49, -1, -1, -1, -1, -1, 0);
    }

    public boolean beginManaged(ManageableType manageableType, boolean bl) {
        super.beginManaged(manageableType, bl);
        return false;
    }

    public void makePersistent(PersistenceCapable persistenceCapable, long l) {
        this.writeItem(49);
        this.writeLong(l);
        boolean bl = this.beginManaged(persistenceCapable.getManageableType(), true);
        try {
            persistenceCapable.getManageableType().write(persistenceCapable, this, bl);
        }
        catch (IOException iOException) {
            throw new FatalPersistenceException(iOException);
        }
        this.endManaged(persistenceCapable, true);
    }

    public void setBoolean(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, boolean bl) {
        this.writeItem(1);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeBoolean(bl);
    }

    public void setByte(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, byte by) {
        this.writeItem(2);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeByte(by);
    }

    public void setShort(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, short s) {
        this.writeItem(3);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeShort(s);
    }

    public void setChar(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, char c) {
        this.writeItem(4);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeChar(c);
    }

    public void setInt(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, int n) {
        this.writeItem(5);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeInt(n);
    }

    public void setLong(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, long l) {
        this.writeItem(6);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeLong(l);
    }

    public void setFloat(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, float f) {
        this.writeItem(7);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeFloat(f);
    }

    public void setDouble(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, double d) {
        this.writeItem(8);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeDouble(d);
    }

    public void setObject(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, Object object) {
        this.writeItem(9);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        try {
            persistenceField.writeObject(object, this);
        }
        catch (IOException iOException) {
            throw new FatalPersistenceException(iOException);
        }
    }

    public void addByte(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, byte by) {
        this.writeItem(10);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeByte(by);
    }

    public void addShort(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, short s) {
        this.writeItem(11);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeShort(s);
    }

    public void addChar(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, char c) {
        this.writeItem(12);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeChar(c);
    }

    public void addInt(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, int n) {
        this.writeItem(13);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeInt(n);
    }

    public void addLong(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, long l) {
        this.writeItem(14);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeLong(l);
    }

    public void addFloat(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, float f) {
        this.writeItem(15);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeFloat(f);
    }

    public void addDouble(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, double d) {
        this.writeItem(16);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeDouble(d);
    }

    public void mulByte(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, byte by) {
        this.writeItem(17);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeByte(by);
    }

    public void mulShort(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, short s) {
        this.writeItem(18);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeShort(s);
    }

    public void mulChar(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, char c) {
        this.writeItem(19);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeChar(c);
    }

    public void mulInt(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, int n) {
        this.writeItem(20);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeInt(n);
    }

    public void mulLong(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, long l) {
        this.writeItem(21);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeLong(l);
    }

    public void mulFloat(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, float f) {
        this.writeItem(22);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeFloat(f);
    }

    public void mulDouble(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, double d) {
        this.writeItem(23);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeDouble(d);
    }

    public void divByte(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, byte by) {
        this.writeItem(24);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeByte(by);
    }

    public void divShort(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, short s) {
        this.writeItem(25);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeShort(s);
    }

    public void divChar(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, char c) {
        this.writeItem(26);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeChar(c);
    }

    public void divInt(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, int n) {
        this.writeItem(27);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeInt(n);
    }

    public void divLong(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, long l) {
        this.writeItem(28);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeLong(l);
    }

    public void divFloat(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, float f) {
        this.writeItem(29);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeFloat(f);
    }

    public void divDouble(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, double d) {
        this.writeItem(30);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeDouble(d);
    }

    public void orBoolean(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, boolean bl) {
        this.writeItem(31);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeBoolean(bl);
    }

    public void orByte(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, byte by) {
        this.writeItem(32);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeByte(by);
    }

    public void orShort(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, short s) {
        this.writeItem(33);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeShort(s);
    }

    public void orChar(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, char c) {
        this.writeItem(34);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeChar(c);
    }

    public void orInt(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, int n) {
        this.writeItem(35);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeInt(n);
    }

    public void orLong(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, long l) {
        this.writeItem(36);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeLong(l);
    }

    public void andBoolean(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, boolean bl) {
        this.writeItem(37);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeBoolean(bl);
    }

    public void andByte(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, byte by) {
        this.writeItem(38);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeByte(by);
    }

    public void andShort(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, short s) {
        this.writeItem(39);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeShort(s);
    }

    public void andChar(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, char c) {
        this.writeItem(40);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeChar(c);
    }

    public void andInt(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, int n) {
        this.writeItem(41);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeInt(n);
    }

    public void andLong(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, long l) {
        this.writeItem(42);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeLong(l);
    }

    public void xorBoolean(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, boolean bl) {
        this.writeItem(43);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeBoolean(bl);
    }

    public void xorByte(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, byte by) {
        this.writeItem(44);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeByte(by);
    }

    public void xorShort(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, short s) {
        this.writeItem(45);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeShort(s);
    }

    public void xorChar(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, char c) {
        this.writeItem(46);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeChar(c);
    }

    public void xorInt(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, int n) {
        this.writeItem(47);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeInt(n);
    }

    public void xorLong(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, long l) {
        this.writeItem(48);
        this.writeLong(persistenceCapable.getId());
        persistenceField.write(nArray, this);
        this.writeLong(l);
    }

    protected Applier createApplier() {
        return new Applier();
    }

    public boolean apply(Transaction transaction) throws IOException {
        this.applier.resetCursor();
        return this.applier.apply(transaction);
    }

    protected class Applier
    extends XAQueue.Reader {
        protected final IndirectField indirectField;

        protected Applier() {
            super(ModificationQueue.this);
            this.indirectField = new IndirectField();
        }

        protected boolean apply(int n, Transaction transaction) throws IOException {
            switch (n & 0xFFF) {
                case 0: {
                    this.enter(false);
                    boolean bl = this.apply(transaction);
                    this.leave();
                    return bl;
                }
                case 1: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    transaction.prepareSetBoolean(persistenceCapable, indirectField, nArray);
                    transaction.finishSet(this);
                    return true;
                }
                case 2: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    transaction.prepareSetByte(persistenceCapable, indirectField, nArray);
                    transaction.finishSet(this);
                    return true;
                }
                case 3: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    transaction.prepareSetShort(persistenceCapable, indirectField, nArray);
                    transaction.finishSet(this);
                    return true;
                }
                case 4: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    transaction.prepareSetChar(persistenceCapable, indirectField, nArray);
                    transaction.finishSet(this);
                    return true;
                }
                case 5: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    transaction.prepareSetInt(persistenceCapable, indirectField, nArray);
                    transaction.finishSet(this);
                    return true;
                }
                case 6: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    transaction.prepareSetLong(persistenceCapable, indirectField, nArray);
                    transaction.finishSet(this);
                    return true;
                }
                case 7: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    transaction.prepareSetFloat(persistenceCapable, indirectField, nArray);
                    transaction.finishSet(this);
                    return true;
                }
                case 8: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    transaction.prepareSetDouble(persistenceCapable, indirectField, nArray);
                    transaction.finishSet(this);
                    return true;
                }
                case 9: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    transaction.prepareSetObject(persistenceCapable, indirectField, nArray);
                    transaction.finishSet(this);
                    return true;
                }
                case 10: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setByte(persistenceCapable, nArray, (byte)(indirectField.getByte(persistenceCapable, nArray) + this.readByte()), transaction);
                    return true;
                }
                case 11: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setShort(persistenceCapable, nArray, (short)(indirectField.getShort(persistenceCapable, nArray) + this.readShort()), transaction);
                    return true;
                }
                case 12: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setChar(persistenceCapable, nArray, (char)(indirectField.getChar(persistenceCapable, nArray) + this.readChar()), transaction);
                    return true;
                }
                case 13: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setInt(persistenceCapable, nArray, indirectField.getInt(persistenceCapable, nArray) + this.readInt(), transaction);
                    return true;
                }
                case 14: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setLong(persistenceCapable, nArray, indirectField.getLong(persistenceCapable, nArray) + this.readLong(), transaction);
                    return true;
                }
                case 15: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setFloat(persistenceCapable, nArray, indirectField.getFloat(persistenceCapable, nArray) + this.readFloat(), transaction);
                    return true;
                }
                case 16: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setDouble(persistenceCapable, nArray, indirectField.getDouble(persistenceCapable, nArray) + this.readDouble(), transaction);
                    return true;
                }
                case 17: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setByte(persistenceCapable, nArray, (byte)(indirectField.getByte(persistenceCapable, nArray) * this.readByte()), transaction);
                    return true;
                }
                case 18: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setShort(persistenceCapable, nArray, (short)(indirectField.getShort(persistenceCapable, nArray) * this.readShort()), transaction);
                    return true;
                }
                case 19: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setChar(persistenceCapable, nArray, (char)(indirectField.getChar(persistenceCapable, nArray) * this.readChar()), transaction);
                    return true;
                }
                case 20: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setInt(persistenceCapable, nArray, indirectField.getInt(persistenceCapable, nArray) * this.readInt(), transaction);
                    return true;
                }
                case 21: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setLong(persistenceCapable, nArray, indirectField.getLong(persistenceCapable, nArray) * this.readLong(), transaction);
                    return true;
                }
                case 22: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setFloat(persistenceCapable, nArray, indirectField.getFloat(persistenceCapable, nArray) * this.readFloat(), transaction);
                    return true;
                }
                case 23: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setDouble(persistenceCapable, nArray, indirectField.getDouble(persistenceCapable, nArray) * this.readDouble(), transaction);
                    return true;
                }
                case 24: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setByte(persistenceCapable, nArray, (byte)(indirectField.getByte(persistenceCapable, nArray) / this.readByte()), transaction);
                    return true;
                }
                case 25: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setShort(persistenceCapable, nArray, (short)(indirectField.getShort(persistenceCapable, nArray) / this.readShort()), transaction);
                    return true;
                }
                case 26: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setChar(persistenceCapable, nArray, (char)(indirectField.getChar(persistenceCapable, nArray) / this.readChar()), transaction);
                    return true;
                }
                case 27: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setInt(persistenceCapable, nArray, indirectField.getInt(persistenceCapable, nArray) / this.readInt(), transaction);
                    return true;
                }
                case 28: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setLong(persistenceCapable, nArray, indirectField.getLong(persistenceCapable, nArray) / this.readLong(), transaction);
                    return true;
                }
                case 29: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setFloat(persistenceCapable, nArray, indirectField.getFloat(persistenceCapable, nArray) / this.readFloat(), transaction);
                    return true;
                }
                case 30: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setDouble(persistenceCapable, nArray, indirectField.getDouble(persistenceCapable, nArray) / this.readDouble(), transaction);
                    return true;
                }
                case 31: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setBoolean(persistenceCapable, nArray, indirectField.getBoolean(persistenceCapable, nArray) | this.readBoolean(), transaction);
                    return true;
                }
                case 32: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setByte(persistenceCapable, nArray, (byte)(indirectField.getByte(persistenceCapable, nArray) | this.readByte()), transaction);
                    return true;
                }
                case 33: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setShort(persistenceCapable, nArray, (short)(indirectField.getShort(persistenceCapable, nArray) | this.readShort()), transaction);
                    return true;
                }
                case 34: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setChar(persistenceCapable, nArray, (char)(indirectField.getChar(persistenceCapable, nArray) | this.readChar()), transaction);
                    return true;
                }
                case 35: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setInt(persistenceCapable, nArray, indirectField.getInt(persistenceCapable, nArray) | this.readInt(), transaction);
                    return true;
                }
                case 36: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setLong(persistenceCapable, nArray, indirectField.getLong(persistenceCapable, nArray) | this.readLong(), transaction);
                    return true;
                }
                case 37: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setBoolean(persistenceCapable, nArray, indirectField.getBoolean(persistenceCapable, nArray) & this.readBoolean(), transaction);
                    return true;
                }
                case 38: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setByte(persistenceCapable, nArray, (byte)(indirectField.getByte(persistenceCapable, nArray) & this.readByte()), transaction);
                    return true;
                }
                case 39: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setShort(persistenceCapable, nArray, (short)(indirectField.getShort(persistenceCapable, nArray) & this.readShort()), transaction);
                    return true;
                }
                case 40: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setChar(persistenceCapable, nArray, (char)(indirectField.getChar(persistenceCapable, nArray) & this.readChar()), transaction);
                    return true;
                }
                case 41: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setInt(persistenceCapable, nArray, indirectField.getInt(persistenceCapable, nArray) & this.readInt(), transaction);
                    return true;
                }
                case 42: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setLong(persistenceCapable, nArray, indirectField.getLong(persistenceCapable, nArray) & this.readLong(), transaction);
                    return true;
                }
                case 43: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setBoolean(persistenceCapable, nArray, indirectField.getBoolean(persistenceCapable, nArray) ^ this.readBoolean(), transaction);
                    return true;
                }
                case 44: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setByte(persistenceCapable, nArray, (byte)(indirectField.getByte(persistenceCapable, nArray) ^ this.readByte()), transaction);
                    return true;
                }
                case 45: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setShort(persistenceCapable, nArray, (short)(indirectField.getShort(persistenceCapable, nArray) ^ this.readShort()), transaction);
                    return true;
                }
                case 46: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setChar(persistenceCapable, nArray, (char)(indirectField.getChar(persistenceCapable, nArray) ^ this.readChar()), transaction);
                    return true;
                }
                case 47: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setInt(persistenceCapable, nArray, indirectField.getInt(persistenceCapable, nArray) ^ this.readInt(), transaction);
                    return true;
                }
                case 48: {
                    PersistenceCapable persistenceCapable = ModificationQueue.this.manager.getObject(this.readLong());
                    IndirectField indirectField = this.indirectField;
                    int[] nArray = indirectField.read(persistenceCapable, this);
                    indirectField.setLong(persistenceCapable, nArray, indirectField.getLong(persistenceCapable, nArray) ^ this.readLong(), transaction);
                    return true;
                }
            }
            throw new IOException();
        }

        public final boolean apply(Transaction transaction) throws IOException {
            boolean bl = false;
            int n = this.readItem();
            while (n >= 0) {
                bl |= this.apply(n, transaction);
                n = this.next();
            }
            return bl;
        }
    }
}

