/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.persistence;

import de.grogra.persistence.BindingsCache;
import de.grogra.persistence.PersistenceBindings;
import de.grogra.persistence.PersistenceConnection;
import de.grogra.persistence.PersistenceException;
import de.grogra.persistence.PersistenceManager;
import de.grogra.persistence.RemoteClient;
import de.grogra.persistence.Transaction;
import de.grogra.xl.util.ObjectList;
import java.io.IOException;
import java.util.HashMap;

public class ServerConnection
extends PersistenceConnection {
    private long nextXAStamp;
    private final HashMap extentMap = new HashMap();
    private final ObjectList clientList = new ObjectList();
    private short nextManagerId = 0;
    private volatile short nextCacheId = 0;

    public ServerConnection(PersistenceBindings persistenceBindings) {
        super(persistenceBindings);
        this.initializeCache(new BindingsCache(persistenceBindings, this.nextCacheId()));
    }

    short nextCacheId() {
        short s = this.nextCacheId;
        this.nextCacheId = (short)(s + 1);
        return s;
    }

    public synchronized short registerManager(PersistenceManager persistenceManager, String string) {
        Extent extent = new Extent(persistenceManager);
        this.extentMap.put(string, extent);
        short s = this.nextManagerId;
        this.nextManagerId = (short)(s + 1);
        short s2 = s;
        this.clientList.set(s2, new ClientData(extent, null, s2));
        return s2;
    }

    public synchronized short registerRemoteManager(RemoteClient remoteClient, String string) {
        Extent extent = (Extent)this.extentMap.get(string);
        short s = this.nextManagerId;
        this.nextManagerId = (short)(s + 1);
        short s2 = s;
        ClientData clientData = new ClientData(extent, remoteClient, s2);
        this.clientList.set(s2, clientData);
        extent.clients.add(clientData);
        return s2;
    }

    public void deregisterManager(PersistenceManager persistenceManager) {
    }

    public synchronized PersistenceManager initialize(short s) {
        Extent extent = ((ClientData)this.clientList.get((int)s)).extent;
        ObjectList objectList = extent.clients;
        for (int i = objectList.size() - 1; i >= 0; --i) {
            ClientData clientData = (ClientData)objectList.get(i);
            if (clientData.managerId != s) continue;
            assert (!clientData.initialized);
            clientData.initialized = true;
            return extent.localManager;
        }
        throw new AssertionError();
    }

    public synchronized PersistenceManager getLocalManager(short s) {
        return ((ClientData)this.clientList.get((int)s)).extent.localManager;
    }

    public synchronized RemoteClient getClient(short s) {
        return ((ClientData)this.clientList.get((int)s)).client;
    }

    public synchronized void commit(Transaction.Data data, long l) {
        try {
            ((ClientData)this.clientList.get((int)data.getKey().getManagerId())).extent.commit(data, l);
        }
        catch (IOException iOException) {
            throw new PersistenceException(iOException);
        }
    }

    private final class Extent {
        final PersistenceManager localManager;
        final ObjectList clients = new ObjectList();

        Extent(PersistenceManager persistenceManager) {
            this.localManager = persistenceManager;
        }

        void commit(Transaction.Data data, long l) throws IOException {
            long l2 = ServerConnection.this.nextXAStamp++;
            if (data.isRemote()) {
                this.localManager.transactionCommitted(data, l2);
            } else {
                this.localManager.localTransactionCommitted(data.key, l2);
            }
            for (int i = 0; i < this.clients.size(); ++i) {
                ClientData clientData = (ClientData)this.clients.get(i);
                if (clientData.managerId == data.getKey().getManagerId()) {
                    clientData.client.localTransactionCommitted(data.getKey(), l2);
                    continue;
                }
                if (!clientData.initialized) continue;
                clientData.client.transactionCommitted(data, clientData.managerId, l2);
            }
        }
    }

    private static final class ClientData {
        final Extent extent;
        final RemoteClient client;
        final short managerId;
        boolean initialized = false;

        ClientData(Extent extent, RemoteClient remoteClient, short s) {
            this.extent = extent;
            this.client = remoteClient;
            this.managerId = s;
        }
    }
}

