/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.persistence;

import de.grogra.persistence.Manageable;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.PersistenceCapable;
import de.grogra.persistence.PersistenceManager;
import de.grogra.persistence.PersistenceOutput;
import de.grogra.persistence.PersistenceOutputListener;
import de.grogra.persistence.Shareable;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.util.IOWrapException;
import de.grogra.util.SAXElement;
import de.grogra.util.Utils;
import de.grogra.util.WrapException;
import java.io.IOException;
import java.io.Serializable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLPersistenceWriter
implements PersistenceOutput {
    public static final String NAMESPACE = "http://grogra.de/xmlpersistence";
    public static final String NS_PREFIX = "gx";
    public static final Attributes NS_ATTRIBUTE;
    protected final PersistenceOutputListener listener;
    private final ContentHandler ch;
    private StringBuffer buffer = new StringBuffer();
    private AttributesImpl atts = new SAXElement();
    private String fieldName;
    private int outputContext = 3;
    private long outputStack;
    private String arrayFieldName;
    private String managedFieldName;
    static final int BUFFER_LIST = 0;
    static final int BUFFER_MAP = 1;
    static final int ELEMENT_WITH_ATTRIBUTES = 2;
    static final int ELEMENT_WITH_ELEMENTS = 3;
    static final String SERIALIZED_PREFIX = "serialized:";

    private void add(String string, String string2, String string3) {
        this.atts.addAttribute(NAMESPACE, string, string2, "CDATA", string3);
    }

    public XMLPersistenceWriter(ContentHandler contentHandler, PersistenceOutputListener persistenceOutputListener) {
        this.ch = contentHandler;
        this.listener = persistenceOutputListener;
    }

    public ContentHandler getContentHandler() {
        return this.ch;
    }

    private void checkWS() {
        int n = this.buffer.length();
        if (n > 0) {
            switch (this.buffer.charAt(n - 1)) {
                case ' ': 
                case '(': 
                case ')': 
                case ':': 
                case '=': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    return;
                }
            }
            this.buffer.append(' ');
        }
    }

    public void beginExtent(PersistenceManager persistenceManager) throws IOException {
    }

    public void endExtent() throws IOException {
    }

    public void writeName(String string) {
        this.checkWS();
        this.buffer.append(string);
    }

    public void writeString(String string) {
        this.checkWS();
        Utils.quote(string, this.buffer);
    }

    private boolean beginWrite(char c) throws IOException {
        switch (this.outputContext) {
            case 0: {
                this.checkWS();
                if (c > '\u0000') {
                    this.buffer.append(c);
                }
                return true;
            }
            case 1: {
                this.checkWS();
                this.buffer.append(this.fieldName).append('=');
                if (c > '\u0000') {
                    this.buffer.append(c);
                }
                return true;
            }
            case 2: {
                this.buffer.setLength(0);
                if (c > '\u0000') {
                    this.buffer.append(c);
                }
                return false;
            }
            case 3: {
                this.buffer.setLength(0);
                return false;
            }
        }
        throw new AssertionError();
    }

    private void endWrite(String string) throws IOException {
        switch (this.outputContext) {
            case 2: {
                this.atts.addAttribute("", this.fieldName, this.fieldName, "CDATA", this.buffer.toString());
                break;
            }
            case 3: {
                this.atts.clear();
                if (this.fieldName != null) {
                    this.add("name", "gx:name", this.fieldName);
                }
                if (!string.equals("null")) {
                    this.add("value", "gx:value", this.buffer.toString());
                }
                this.startElement(string, this.atts);
                this.endElement(string);
            }
        }
        this.fieldName = null;
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.beginWrite('\u0000');
        this.buffer.append(bl);
        this.endWrite("data");
    }

    public void writeByte(int n) throws IOException {
        this.beginWrite('\u0000');
        this.buffer.append(n);
        this.endWrite("data");
    }

    public void writeChar(int n) throws IOException {
        this.beginWrite('\u0000');
        if (n == 39) {
            this.buffer.append("'\\''");
        } else {
            this.buffer.append('\'').append(n).append('\'');
        }
        this.endWrite("data");
    }

    public void writeShort(int n) throws IOException {
        this.beginWrite('\u0000');
        this.buffer.append(n);
        this.endWrite("data");
    }

    public void writeInt(int n) throws IOException {
        this.beginWrite('\u0000');
        this.buffer.append(n);
        this.endWrite("data");
    }

    public void writeLong(long l) throws IOException {
        this.beginWrite('\u0000');
        this.buffer.append(l);
        this.endWrite("data");
    }

    public void writeFloat(float f) throws IOException {
        this.beginWrite('\u0000');
        this.buffer.append(f);
        this.endWrite("data");
    }

    public void writeDouble(double d) throws IOException {
        this.beginWrite('\u0000');
        this.buffer.append(d);
        this.endWrite("data");
    }

    public void writeNullObject() throws IOException {
        this.beginWrite('\u0000');
        this.buffer.append("null");
        this.endWrite("null");
    }

    public void writeStringObject(String string) throws IOException {
        this.writeString0(string, "data");
    }

    private void writeString0(String string, String string2) throws IOException {
        boolean bl = this.beginWrite('\u0000');
        if ("null".equals(string)) {
            this.buffer.append("\"null\"");
        } else if (bl || string.indexOf(34) >= 0) {
            Utils.quote(string, this.buffer);
        } else {
            this.buffer.append(string);
        }
        this.endWrite(string2);
    }

    public void writeObject(Object object, Type type) throws IOException {
        if (Reflection.isFinal(type) && type.isStringSerializable()) {
            this.writeString0(object.toString(), "string");
        } else if (object instanceof Class) {
            this.writeString0(((Class)object).getName(), "string");
        } else {
            this.beginWrite('@');
            Utils.encodeBase64(object, this.buffer);
            if (this.outputContext == 0 || this.outputContext == 1) {
                this.buffer.append(' ');
            }
            this.endWrite("serialized");
        }
        if (this.listener != null) {
            this.listener.objectWritten(object);
        }
    }

    public void writePersistentObjectReference(PersistenceCapable persistenceCapable) throws IOException {
        this.beginWrite('#');
        this.buffer.append(persistenceCapable.getId());
        this.endWrite("ref");
    }

    public void writeSharedObjectReference(Shareable shareable) throws IOException {
        this.beginWrite('*');
        this.buffer.append(shareable.getProvider().getProviderName()).append(':');
        int n = this.outputContext;
        this.outputContext = 0;
        String string = this.fieldName;
        shareable.getProvider().writeObject(shareable, this);
        this.outputContext = n;
        this.fieldName = string;
        this.endWrite("shared");
        if (this.listener != null) {
            this.listener.sharedObjectReferenceWritten(shareable);
        }
    }

    private void pushOutput() {
        this.outputStack = this.outputStack << 2 | (long)this.outputContext;
    }

    private void popOutput() {
        this.outputContext = (int)this.outputStack & 3;
        this.outputStack >>>= 2;
    }

    public void beginArray(int n, Type type) throws IOException {
        this.pushOutput();
        switch (this.outputContext) {
            case 2: {
                this.arrayFieldName = this.fieldName;
            }
            case 0: 
            case 1: {
                this.beginWrite('{');
                this.outputContext = 0;
                break;
            }
            case 3: {
                this.atts.clear();
                if (this.fieldName != null) {
                    this.add("name", "gx:name", this.fieldName);
                }
                if (Reflection.isPrimitive(type)) {
                    this.outputContext = 0;
                    this.buffer.setLength(0);
                    break;
                }
                this.startElement("array", this.atts);
            }
        }
        this.fieldName = null;
    }

    public void endArray() throws IOException {
        int n = this.outputContext;
        this.popOutput();
        switch (this.outputContext) {
            case 0: 
            case 1: {
                this.buffer.append('}');
                break;
            }
            case 2: {
                this.buffer.append('}');
                this.fieldName = this.arrayFieldName;
                this.endWrite(null);
                break;
            }
            case 3: {
                if (n == 3) {
                    this.endElement("array");
                    break;
                }
                this.add("value", "gx:value", this.buffer.toString());
                this.startElement("array", this.atts);
                this.endElement("array");
            }
        }
        this.fieldName = null;
    }

    public boolean beginManaged(ManageableType manageableType, boolean bl) throws IOException {
        this.pushOutput();
        block0 : switch (this.outputContext) {
            case 2: {
                this.managedFieldName = this.fieldName;
            }
            case 0: 
            case 1: {
                if (bl) {
                    this.beginWrite('[');
                    this.buffer.append(manageableType.getBinaryName());
                } else {
                    this.beginWrite('(');
                }
                this.outputContext = manageableType.getSerializationMethod() != 0 ? 1 : 0;
                break;
            }
            case 3: {
                this.atts.clear();
                if (this.fieldName != null) {
                    this.add("name", "gx:name", this.fieldName);
                }
                if (bl) {
                    this.add("type", "gx:type", manageableType.getBinaryName());
                }
                switch (manageableType.getSerializationMethod()) {
                    case 0: {
                        this.outputContext = 0;
                        this.buffer.setLength(0);
                        break block0;
                    }
                    case 1: {
                        this.outputContext = 2;
                        break block0;
                    }
                    case 2: {
                        this.startElement("object", this.atts);
                    }
                }
            }
        }
        return this.outputContext != 0;
    }

    public void endManaged(Object object, boolean bl) throws IOException {
        int n = this.outputContext;
        this.popOutput();
        block0 : switch (this.outputContext) {
            case 0: 
            case 1: {
                this.buffer.append(bl ? (char)']' : ')');
                break;
            }
            case 2: {
                this.buffer.append(bl ? (char)']' : ')');
                this.fieldName = this.managedFieldName;
                this.endWrite(null);
                break;
            }
            case 3: {
                switch (n) {
                    case 0: {
                        this.add("value", "gx:value", this.buffer.toString());
                        this.startElement("object", this.atts);
                        this.endElement("object");
                        break block0;
                    }
                    case 2: {
                        this.startElement("object", this.atts);
                        this.endElement("object");
                        break block0;
                    }
                    case 3: {
                        this.endElement("object");
                        break block0;
                    }
                }
                throw new AssertionError();
            }
        }
        this.fieldName = null;
        if (this.listener != null) {
            this.listener.objectWritten(object);
        }
    }

    protected void startElement(String string, Attributes attributes) throws IOException {
        try {
            this.ch.startElement(NAMESPACE, string, string, attributes);
        }
        catch (SAXException sAXException) {
            throw new IOWrapException(sAXException);
        }
    }

    protected void endElement(String string) throws IOException {
        try {
            this.ch.endElement(NAMESPACE, string, string);
        }
        catch (SAXException sAXException) {
            throw new IOWrapException(sAXException);
        }
    }

    public void beginFields() {
    }

    public void beginField(ManageableType.Field field) throws IOException {
        this.fieldName = field.getSimpleName();
    }

    public void endField(ManageableType.Field field) throws IOException {
    }

    public void endFields() {
    }

    public void setNested(boolean bl) {
    }

    public void getAttributes(PersistenceCapable persistenceCapable, AttributesImpl attributesImpl) throws IOException {
        this.outputContext = 2;
        this.atts.setAttributes(attributesImpl);
        persistenceCapable.getManageableType().write(persistenceCapable, this, true);
        attributesImpl.setAttributes(this.atts);
    }

    public void writeFields(Manageable manageable) throws IOException {
        this.outputContext = 3;
        manageable.getManageableType().write(manageable, this, true);
    }

    public String toString(Manageable manageable) {
        this.outputContext = 1;
        this.buffer.setLength(0);
        try {
            manageable.getManageableType().write(manageable, this, false);
        }
        catch (IOException iOException) {
            throw new WrapException(iOException);
        }
        return this.buffer.toString();
    }

    public String toString(Type type, Object object) {
        String string;
        if (object == null) {
            return "null";
        }
        if (object instanceof Manageable) {
            string = this.toString((Manageable)object);
        } else if (object instanceof CharSequence || type.isStringSerializable()) {
            string = object.toString();
        } else if (object instanceof Class) {
            string = ((Class)object).getName();
        } else if (object instanceof Serializable) {
            try {
                StringBuffer stringBuffer = new StringBuffer(SERIALIZED_PREFIX);
                Utils.encodeBase64(object, stringBuffer);
                string = stringBuffer.toString();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return "null";
            }
        } else {
            return "null";
        }
        return string.equals("null") ? "\"null\"" : (string.indexOf(34) >= 0 ? Utils.quote(string) : string);
    }

    static {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("http://www.w3.org/2000/xmlns/", "xmlns", "xmlns", "CDATA", NAMESPACE);
        NS_ATTRIBUTE = attributesImpl;
    }
}

