/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.io;

import de.grogra.pf.io.FileSource;
import de.grogra.pf.io.FilterBase;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.GraphLoader;
import de.grogra.pf.io.IO;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.ObjectSource;
import de.grogra.pf.io.ProjectLoader;
import de.grogra.pf.io.RegistryLoader;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.ItemVisitor;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.vfs.FileSystem;
import de.grogra.vfs.LocalFileSystem;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Manifest;

public class GSReader
extends FilterBase
implements ObjectSource,
ProjectLoader {
    private LocalFileSystem fs;
    private File project;

    public GSReader(FilterItem filterItem, FilterSource filterSource) {
        super(filterItem, filterSource);
        this.setFlavor(IOFlavor.PROJECT_LOADER);
    }

    public Object getObject() throws IOException {
        this.project = ((FileSource)this.source).getInputFile();
        this.fs = new LocalFileSystem("pfs", this.project.getParentFile());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRegistry(Registry registry) throws IOException {
        Object object;
        registry.initFileSystem(this.fs);
        File file = new File(new File(this.project.getParentFile(), "META-INF"), "MANIFEST.MF");
        if (file.isFile()) {
            Manifest manifest;
            object = new BufferedInputStream(new FileInputStream(file));
            try {
                manifest = new Manifest((InputStream)object);
            }
            finally {
                ((BufferedInputStream)object).close();
            }
            this.fs.setManifest(manifest);
        }
        object = new FileSource(this.fs, this.project, IO.toSystemId((FileSystem)this.fs, this.project), Registry.MIME_TYPE, registry, null);
        if (!((object = IO.createPipeline((FilterSource)object, IOFlavor.REGISTRY_LOADER)) instanceof ObjectSource)) {
            throw new AssertionError((Object)("gs-pipeline = " + object));
        }
        ((RegistryLoader)((ObjectSource)object).getObject()).loadRegistry(registry);
    }

    public void loadGraph(Registry registry) throws IOException {
        GSReader.loadGraph(this.fs, registry);
    }

    public static void loadGraph(FileSystem fileSystem, Registry registry) throws IOException {
        String string = (String)registry.getImportAttribute("graph");
        if (string == null) {
            throw new IOException(IO.I18N.msg("gs.graphfile-not-specified"));
        }
        Object object = fileSystem.getFile(string);
        if (object == null) {
            throw new IOException(IO.I18N.msg("gs.file-not-found", string));
        }
        FilterSource filterSource = new FileSource(fileSystem, object, (RegistryContext)registry, null);
        if (!((filterSource = IO.createPipeline(filterSource, IOFlavor.GRAPH_LOADER)) instanceof ObjectSource)) {
            throw new IOException(IO.I18N.msg("gs.invalid-file-type", string));
        }
        ((GraphLoader)((ObjectSource)filterSource).getObject()).loadGraph(registry);
        registry.forAll(null, null, new ItemVisitor(){

            public void visit(Item item, Object object) {
                if (!item.validate()) {
                    System.err.println("Removed " + item);
                    item.removeFromChain();
                }
            }
        }, null, false);
    }
}

