/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.io;

import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.OutputStreamSource;
import de.grogra.pf.io.SAXFilterBase;
import de.grogra.pf.io.SAXSource;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.expr.Expression;
import de.grogra.util.IOWrapException;
import de.grogra.util.StringMap;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.LexicalHandler;

public class XSLTFilter
extends SAXFilterBase
implements OutputStreamSource {
    private final Templates xslt;

    public XSLTFilter(FilterItem filterItem, FilterSource filterSource, Templates templates, IOFlavor iOFlavor) {
        super(filterItem, filterSource, iOFlavor);
        this.xslt = templates;
    }

    public void parse(ContentHandler contentHandler, ErrorHandler errorHandler, LexicalHandler lexicalHandler, DTDHandler dTDHandler, EntityResolver entityResolver) throws IOException, SAXException {
        SAXResult sAXResult = new SAXResult(contentHandler);
        if (lexicalHandler != null) {
            sAXResult.setLexicalHandler(lexicalHandler);
        }
        this.transform(sAXResult);
    }

    public void write(OutputStream outputStream) throws IOException {
        try {
            this.transform(new StreamResult(outputStream));
        }
        catch (SAXException sAXException) {
            throw new IOWrapException(sAXException);
        }
    }

    private void transform(Result result) throws IOException, SAXException {
        try {
            Item item;
            Transformer transformer = this.xslt.newTransformer();
            Item item2 = this.item.getItem("params");
            if (item2 != null) {
                for (item = (Item)item2.getBranch(); item != null; item = (Item)item.getSuccessor()) {
                    if (!(item instanceof Expression)) continue;
                    transformer.setParameter(item.getName(), ((Expression)item).evaluate(this, new StringMap(this)));
                }
            }
            if ((item2 = this.item.getItem("output")) != null) {
                for (item = (Item)item2.getBranch(); item != null; item = (Item)item.getSuccessor()) {
                    if (!(item instanceof Expression)) continue;
                    transformer.setOutputProperty(item.getName(), String.valueOf(((Expression)item).evaluate(this, new StringMap())));
                }
            }
            transformer.transform(new javax.xml.transform.sax.SAXSource(this, new InputSource(this.source.getSystemId())), result);
        }
        catch (TransformerException transformerException) {
            throw new IOWrapException(transformerException);
        }
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return ((SAXSource)this.source).getFeature(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        ((SAXSource)this.source).setFeature(string, bl);
    }
}

