/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.reflect;

import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Member;
import de.grogra.reflect.Type;
import de.grogra.reflect.TypeDecorator;
import de.grogra.reflect.TypeLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyType<T>
extends TypeDecorator<T> {
    private final String binaryName;
    private final String descriptor;
    private ClassLoader classLoader;
    private TypeLoader loader;
    private Type<T> type;

    public LazyType(String string, ClassLoader classLoader) {
        super(null);
        this.binaryName = string;
        this.classLoader = classLoader;
        this.descriptor = 'L' + string.replace('.', '/') + ';';
    }

    public LazyType(String string, TypeLoader typeLoader) {
        super(null);
        this.binaryName = string;
        this.loader = typeLoader;
        this.descriptor = 'L' + string.replace('.', '/') + ';';
    }

    @Override
    public synchronized Member getDecoratedMember() {
        if (this.type == null) {
            try {
                this.type = this.classLoader != null ? ClassAdapter.wrap(Class.forName(this.binaryName, false, this.classLoader)) : this.loader.typeForName(this.binaryName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException);
            }
            this.loader = null;
            this.classLoader = null;
        }
        return this.type;
    }

    @Override
    public String getBinaryName() {
        return this.binaryName;
    }

    @Override
    public String getDescriptor() {
        return this.descriptor;
    }
}

