/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.reflect;

import de.grogra.reflect.Field;
import de.grogra.reflect.Method;
import de.grogra.reflect.Type;
import de.grogra.xl.util.XHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Lookup {
    private final Type type;
    private final XHashMap<String, Field> fields;
    private final XHashMap<String, Type> types;
    private final XHashMap<String, Method> methods;

    public Lookup(Type type) {
        this.type = type;
        this.fields = new XHashMap(type.getDeclaredFieldCount());
        this.types = new XHashMap(type.getDeclaredTypeCount());
        this.methods = new XHashMap(type.getDeclaredMethodCount());
        this.update();
    }

    public void update() {
        int n;
        this.fields.clear();
        int n2 = this.type.getDeclaredFieldCount();
        for (n = 0; n < n2; ++n) {
            Field field = this.type.getDeclaredField(n);
            this.fields.put(field.getSimpleName(), field);
        }
        this.types.clear();
        n2 = this.type.getDeclaredTypeCount();
        for (n = 0; n < n2; ++n) {
            Type<?> type = this.type.getDeclaredType(n);
            this.types.put(type.getSimpleName(), type);
        }
        this.methods.clear();
        n2 = this.type.getDeclaredMethodCount();
        for (n = 0; n < n2; ++n) {
            Method method = this.type.getDeclaredMethod(n);
            this.methods.add(method.getSimpleName(), method);
        }
    }

    public Type getType() {
        return this.type;
    }

    public Field getField(String string) {
        return this.fields.get(string);
    }

    public Type getType(String string) {
        return this.types.get(string);
    }

    public XHashMap.Entry<String, Method> getMethods(String string) {
        return this.methods.getEntry(string);
    }
}

