/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends FilterInputStream {
    protected long bytesRead = 0L;
    private long markRead;
    private long resolution;
    private long nextToMonitor;
    private Monitor monitor;

    public CountingInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public void setMonitor(Monitor monitor, long l) {
        this.monitor = monitor;
        this.resolution = Math.max(l, 1L);
    }

    public void mark(int n) {
        this.in.mark(n);
        this.markRead = this.bytesRead;
    }

    public void reset() throws IOException {
        this.in.reset();
        this.bytesRead = this.markRead;
        if (this.monitor != null) {
            this.monitor.bytesRead(this.bytesRead);
            this.nextToMonitor = this.bytesRead + this.resolution;
        }
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n >= 0) {
            ++this.bytesRead;
            if (this.monitor != null && this.bytesRead >= this.nextToMonitor) {
                this.monitor.bytesRead(this.bytesRead);
                this.nextToMonitor = this.bytesRead + this.resolution;
            }
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.in.read(byArray);
        if (n >= 0) {
            this.bytesRead += (long)n;
            if (this.monitor != null && this.bytesRead >= this.nextToMonitor) {
                this.monitor.bytesRead(this.bytesRead);
                this.nextToMonitor = this.bytesRead + this.resolution;
            }
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 >= 0) {
            this.bytesRead += (long)n3;
            if (this.monitor != null && this.bytesRead >= this.nextToMonitor) {
                this.monitor.bytesRead(this.bytesRead);
                this.nextToMonitor = this.bytesRead + this.resolution;
            }
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        long l2 = this.in.skip(l);
        this.bytesRead += l2;
        if (this.monitor != null && this.bytesRead >= this.nextToMonitor) {
            this.monitor.bytesRead(this.bytesRead);
            this.nextToMonitor = this.bytesRead + this.resolution;
        }
        return l2;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public void close() throws IOException {
        this.in.close();
        if (this.monitor != null) {
            this.monitor.streamClosed();
        }
    }

    public static interface Monitor {
        public void bytesRead(long var1);

        public void streamClosed();
    }
}

