/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.util;

import de.grogra.reflect.Type;
import de.grogra.reflect.TypeImpl;
import de.grogra.util.I18NBundle;
import de.grogra.xl.util.ObjectList;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;

public class EnumerationType
extends TypeImpl
implements ListModel {
    public static final EnumerationType INT_ENUMERATION = new EnumerationType("intenum", INT);
    public static final EnumerationType OBJECT_ENUMERATION = new EnumerationType("objectenum", OBJECT);
    protected ObjectList values;
    protected ObjectList descriptions;
    private final Type implType;

    private EnumerationType(String string, Type type) {
        super(string, type);
        this.implType = OBJECT;
    }

    public EnumerationType(String string, Object[] objectArray, EnumerationType enumerationType, Type type) {
        super(string, enumerationType);
        this.descriptions = this.values = new ObjectList<Object>(objectArray);
        this.implType = type;
    }

    public EnumerationType(String string, String[] stringArray) {
        super(string, INT_ENUMERATION);
        this.implType = INT;
        this.descriptions = new ObjectList<String>(stringArray);
        this.initIntValues();
    }

    public EnumerationType(String string, I18NBundle i18NBundle, String[] stringArray) {
        super(string, INT_ENUMERATION);
        this.implType = INT;
        this.descriptions = new ObjectList();
        for (int i = 0; i < stringArray.length; ++i) {
            this.descriptions.add(i18NBundle.keyToDescribed(string + '.' + stringArray[i]));
        }
        this.initIntValues();
    }

    public EnumerationType(String string, I18NBundle i18NBundle, String[] stringArray, Object[] objectArray, Type type) {
        super(string, OBJECT_ENUMERATION);
        this.implType = type;
        this.values = new ObjectList<Object>(objectArray);
        this.descriptions = new ObjectList();
        for (int i = 0; i < stringArray.length; ++i) {
            this.descriptions.add(i18NBundle.keyToDescribed(string + '.' + stringArray[i]));
        }
    }

    public EnumerationType(String string, I18NBundle i18NBundle, int n) {
        super(string, INT_ENUMERATION);
        this.implType = INT;
        this.descriptions = new ObjectList();
        for (int i = 0; i < n; ++i) {
            this.descriptions.add(i18NBundle.keyToDescribed(string + '.' + i));
        }
        this.initIntValues();
    }

    private void initIntValues() {
        this.values = new ObjectList();
        for (int i = 0; i < this.descriptions.size(); ++i) {
            this.values.add(i);
        }
    }

    public Class getImplementationClass() {
        return this.implType.getImplementationClass();
    }

    public Object getElementAt(int n) {
        return this.descriptions.get(n);
    }

    public int getSize() {
        return this.descriptions.size();
    }

    public Object getDescriptionFor(Object object) {
        int n = this.values.indexOf(object);
        return n >= 0 ? this.descriptions.get(n) : null;
    }

    public Object getValueFor(Object object) {
        int n = this.descriptions.indexOf(object);
        return n >= 0 ? this.values.get(n) : null;
    }

    public void addListDataListener(ListDataListener listDataListener) {
    }

    public void removeListDataListener(ListDataListener listDataListener) {
    }

    public boolean isStringSerializable() {
        return this.implType.isStringSerializable();
    }

    public Object valueOf(String string) {
        return this.implType.valueOf(string);
    }
}

