/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.util;

import de.grogra.xl.util.ObjectList;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class OutputQueue
extends OutputStream
implements DataOutput {
    static final int LOW_BITS = 12;
    static final int LOW_SIZE = 4096;
    static final int LOW_MASK = 4095;
    int bindex = 0;
    byte[][] bqueue = new byte[1][4096];
    int iindex = 0;
    int[][] iqueue = new int[1][4096];
    int lindex = 0;
    long[][] lqueue = new long[1][4096];
    int findex = 0;
    float[][] fqueue = new float[1][4096];
    int dindex = 0;
    double[][] dqueue = new double[1][4096];
    int aindex = 0;
    Object[][] aqueue;

    public OutputQueue(boolean bl) {
        this.aqueue = bl ? new Object[1][4096] : (Object[][])null;
    }

    public void clear() {
        if (this.aqueue != null) {
            for (int i = 0; i < this.aqueue.length; ++i) {
                if (this.aqueue[i] == null) continue;
                ObjectList.clear(this.aqueue[i], 0, 4096);
            }
        }
        this.bindex = 0;
        this.iindex = 0;
        this.lindex = 0;
        this.findex = 0;
        this.dindex = 0;
        this.aindex = 0;
    }

    public final void write(int n) {
        this.writeByte(n);
    }

    public final void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public final void write(byte[] byArray, int n, int n2) {
        while (n2 > 0) {
            byte[] byArray2;
            int n3 = Math.min(n2, 4096 - (this.bindex & 0xFFF));
            int n4 = this.bindex >> 12;
            if (n4 == this.bqueue.length) {
                byte[][] byArrayArray = new byte[Math.max(n4 * 2, 2)][];
                this.bqueue = byArrayArray;
                System.arraycopy(this.bqueue, 0, byArrayArray, 0, n4);
            }
            if ((byArray2 = this.bqueue[n4]) == null) {
                byArray2 = new byte[4096];
                this.bqueue[n4] = byArray2;
            }
            System.arraycopy(byArray, n, byArray2, this.bindex & 0xFFF, n3);
            this.bindex += n3;
            n += n3;
            n2 -= n3;
        }
    }

    public final void writeBytes(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.writeByte(string.charAt(i));
        }
    }

    public final void writeChars(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            this.writeByte(c >> 8);
            this.writeByte(c);
        }
    }

    public void flush() {
    }

    public void close() {
    }

    public final void writeBoolean(boolean bl) {
        this.writeByte(bl ? 1 : 0);
    }

    public final void writeShort(int n) {
        this.writeByte(n >> 8);
        this.writeByte(n & 0xFF);
    }

    public final void writeChar(int n) {
        this.writeByte(n >> 8);
        this.writeByte(n & 0xFF);
    }

    public final void writeByte(int n) {
        byte[] byArray;
        int n2 = this.bindex >> 12;
        if (n2 == this.bqueue.length) {
            byte[][] byArrayArray = new byte[Math.max(n2 * 2, 2)][];
            this.bqueue = byArrayArray;
            System.arraycopy(this.bqueue, 0, byArrayArray, 0, n2);
        }
        if ((byArray = this.bqueue[n2]) == null) {
            byArray = new byte[4096];
            this.bqueue[n2] = byArray;
        }
        byArray[this.bindex++ & 0xFFF] = (byte)n;
    }

    public final void writeInt(int n) {
        int[] nArray;
        int n2 = this.iindex >> 12;
        if (n2 == this.iqueue.length) {
            int[][] nArrayArray = new int[Math.max(n2 * 2, 2)][];
            this.iqueue = nArrayArray;
            System.arraycopy(this.iqueue, 0, nArrayArray, 0, n2);
        }
        if ((nArray = this.iqueue[n2]) == null) {
            nArray = new int[4096];
            this.iqueue[n2] = nArray;
        }
        nArray[this.iindex++ & 0xFFF] = n;
    }

    public final void writeLong(long l) {
        long[] lArray;
        int n = this.lindex >> 12;
        if (n == this.lqueue.length) {
            long[][] lArrayArray = new long[Math.max(n * 2, 2)][];
            this.lqueue = lArrayArray;
            System.arraycopy(this.lqueue, 0, lArrayArray, 0, n);
        }
        if ((lArray = this.lqueue[n]) == null) {
            lArray = new long[4096];
            this.lqueue[n] = lArray;
        }
        lArray[this.lindex++ & 0xFFF] = l;
    }

    public final void writeFloat(float f) {
        float[] fArray;
        int n = this.findex >> 12;
        if (n == this.fqueue.length) {
            float[][] fArrayArray = new float[Math.max(n * 2, 2)][];
            this.fqueue = fArrayArray;
            System.arraycopy(this.fqueue, 0, fArrayArray, 0, n);
        }
        if ((fArray = this.fqueue[n]) == null) {
            fArray = new float[4096];
            this.fqueue[n] = fArray;
        }
        fArray[this.findex++ & 0xFFF] = f;
    }

    public final void writeDouble(double d) {
        double[] dArray;
        int n = this.dindex >> 12;
        if (n == this.dqueue.length) {
            double[][] dArrayArray = new double[Math.max(n * 2, 2)][];
            this.dqueue = dArrayArray;
            System.arraycopy(this.dqueue, 0, dArrayArray, 0, n);
        }
        if ((dArray = this.dqueue[n]) == null) {
            dArray = new double[4096];
            this.dqueue[n] = dArray;
        }
        dArray[this.dindex++ & 0xFFF] = d;
    }

    public final void writeObjectInQueue(Object object) {
        Object[] objectArray;
        int n = this.aindex >> 12;
        if (n == this.aqueue.length) {
            this.aqueue = new Object[Math.max(n * 2, 2)][];
            System.arraycopy(this.aqueue, 0, this.aqueue, 0, n);
        }
        if ((objectArray = this.aqueue[n]) == null) {
            objectArray = new Object[4096];
            this.aqueue[n] = objectArray;
        }
        objectArray[this.aindex++ & 0xFFF] = object;
    }

    public void writeObject(Object object) throws IOException {
        this.writeObjectInQueue(object);
    }

    public final void writeUTF(String string) {
        int n = this.bindex;
        int n2 = string.length();
        this.writeByte(0);
        this.writeByte(0);
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c != '\u0000' && c < '\u0080') {
                this.writeByte(c);
                continue;
            }
            if (c < '\u0800') {
                this.writeByte(0xC0 | 0x1F & c >> 6);
                this.writeByte(0x80 | 0x3F & c);
                continue;
            }
            this.writeByte(0xE0 | 0xF & c >> 12);
            this.writeByte(0x80 | 0x3F & c >> 6);
            this.writeByte(0x80 | 0x3F & c);
        }
        n2 = this.bindex - n - 2;
        this.bqueue[n >> 12][n & 0xFFF] = (byte)(n2 >> 8);
        this.bqueue[n >> 12][++n & 0xFFF] = (byte)(n2 & 0xFF);
    }

    public void dump(PrintStream printStream) {
        int n;
        printStream.println(this);
        printStream.print(this.bindex);
        printStream.println(":");
        for (n = 0; n < this.bindex; ++n) {
            printStream.print(this.bqueue[n >> 12][n & 0xFFF]);
            printStream.print(' ');
        }
        printStream.println();
        printStream.print(this.iindex);
        printStream.println(":");
        for (n = 0; n < this.iindex; ++n) {
            printStream.print(this.iqueue[n >> 12][n & 0xFFF]);
            printStream.print(' ');
        }
        printStream.println();
        printStream.print(this.lindex);
        printStream.println(":");
        for (n = 0; n < this.lindex; ++n) {
            printStream.print(this.lqueue[n >> 12][n & 0xFFF]);
            printStream.print(' ');
        }
        printStream.println();
        printStream.print(this.findex);
        printStream.println(":");
        for (n = 0; n < this.findex; ++n) {
            printStream.print(this.fqueue[n >> 12][n & 0xFFF]);
            printStream.print(' ');
        }
        printStream.println();
        printStream.print(this.dindex);
        printStream.println(":");
        for (n = 0; n < this.dindex; ++n) {
            printStream.print(this.dqueue[n >> 12][n & 0xFFF]);
            printStream.print(' ');
        }
        printStream.println();
        printStream.print(this.aindex);
        printStream.println(":");
        for (n = 0; n < this.aindex; ++n) {
            printStream.print(this.aqueue[n >> 12][n & 0xFFF]);
            printStream.print(' ');
        }
        printStream.println();
    }
}

