/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.vfs;

import de.grogra.util.Utils;
import de.grogra.vfs.FileSystem;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public final class LocalFileSystem
extends FileSystem {
    public static final LocalFileSystem FILE_ADAPTER = new LocalFileSystem(null, null);
    protected final File root;

    public LocalFileSystem(String string, File file) {
        super(string, "file");
        File file2 = this.root = file != null ? file.getAbsoluteFile() : null;
        if (file != null) {
            FILE_ADAPTER.addTreeModelListener(new Listener(this));
        }
    }

    public boolean isPersistent() {
        return true;
    }

    protected Object createImpl(Object object, String string, boolean bl) throws IOException {
        File file = new File((File)object, string);
        if (bl) {
            if (!file.isDirectory()) {
                if (file.mkdir()) {
                    return this.getEventFor(file);
                }
                throw new IOException("Directory " + file + " could not be created.");
            }
        } else if (!file.exists()) {
            file.createNewFile();
            return this.getEventFor(file);
        }
        return file;
    }

    protected Object fireInserted(Object object) {
        if (object instanceof TreeModelEvent) {
            FILE_ADAPTER.fireTreeModelEvent(1, (TreeModelEvent)object);
            return LocalFileSystem.getFile((TreeModelEvent)object);
        }
        return object;
    }

    public void delete(Object object) throws IOException {
        TreeModelEvent treeModelEvent = this.getEventFor(object);
        if (!((File)object).delete()) {
            throw new IOException("File " + object + " could not be deleted.");
        }
        FILE_ADAPTER.fireTreeModelEvent(2, treeModelEvent);
    }

    public String getName(Object object) {
        return ((File)object).getName();
    }

    public URL toURL(Object object) {
        return Utils.fileToURL((File)object);
    }

    public Object toFile(URL uRL) {
        File file;
        if (!"file".equals(uRL.getProtocol())) {
            return null;
        }
        for (File file2 = file = Utils.urlToFile(uRL).getAbsoluteFile(); file2 != null; file2 = file2.getParentFile()) {
            if (!this.equals(file2, this.root)) continue;
            return file;
        }
        return null;
    }

    public Object getParent(Object object) {
        return this.root == null || this.equals(object, this.root) ? null : ((File)object).getParentFile();
    }

    public Object getRoot() {
        return this.root;
    }

    public Object[] listFiles(Object object) {
        return ((File)object).listFiles();
    }

    public Object getFile(Object object, String string) {
        File file = new File((File)object, string);
        return file.exists() ? file : null;
    }

    public boolean isLeaf(Object object) {
        return !((File)object).isDirectory();
    }

    public boolean isReadOnly(Object object) {
        return !((File)object).canWrite();
    }

    public long getTime(Object object) {
        return ((File)object).lastModified();
    }

    public void setTime(Object object, long l) {
        ((File)object).setLastModified(l);
    }

    public long getSize(Object object) {
        return ((File)object).length();
    }

    public OutputStream getOutputStream(Object object, boolean bl) throws IOException {
        return new BufferedOutputStream(new FileSystem.Out(new FileOutputStream((File)object, bl), object));
    }

    public InputStream getInputStream(Object object) throws IOException {
        return new BufferedInputStream(new FileInputStream((File)object));
    }

    public Object addLocalFile(File file, Object object, String string) throws IOException {
        File file2 = new File((File)object, string);
        return file2.getCanonicalPath().equals(file.getCanonicalPath()) ? file2 : super.addLocalFile(file, object, string);
    }

    private static class Listener
    implements TreeModelListener {
        private final WeakReference ref;

        Listener(LocalFileSystem localFileSystem) {
            this.ref = new WeakReference<LocalFileSystem>(localFileSystem);
        }

        private void handle(int n, TreeModelEvent treeModelEvent) {
            LocalFileSystem localFileSystem = (LocalFileSystem)this.ref.get();
            if (localFileSystem == null) {
                FILE_ADAPTER.removeTreeModelListener(this);
            } else {
                for (TreePath treePath = treeModelEvent.getTreePath(); treePath != null; treePath = treePath.getParentPath()) {
                    if (!localFileSystem.equals(localFileSystem.getRoot(), treePath.getLastPathComponent())) continue;
                    localFileSystem.fireTreeModelEvent(n, new TreeModelEvent((Object)localFileSystem, localFileSystem.getTreePath(treeModelEvent.getTreePath().getLastPathComponent()), treeModelEvent.getChildIndices(), treeModelEvent.getChildren()));
                    return;
                }
            }
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            this.handle(1, treeModelEvent);
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            this.handle(2, treeModelEvent);
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            this.handle(0, treeModelEvent);
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            this.handle(3, treeModelEvent);
        }
    }
}

