/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.util;

import de.grogra.xl.lang.ByteConsumer;
import de.grogra.xl.lang.VoidToByteGenerator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class ByteList
implements Cloneable,
Serializable,
ByteConsumer,
VoidToByteGenerator {
    private static final long serialVersionUID = -1968627688492821008L;
    public transient byte[] elements;
    public int size = 0;
    private static final byte[] EMPTY = new byte[0];
    private static final byte[] BYTE_NULL = new byte[1024];

    public ByteList(int n) {
        this.elements = new byte[Math.max(n, 8)];
    }

    public ByteList() {
        this(16);
    }

    public ByteList(byte[] byArray) {
        this(byArray.length);
        this.size = byArray.length;
        ByteList.arraycopy(byArray, 0, this.elements, 0, this.size);
    }

    public Object clone() {
        try {
            ByteList byteList = (ByteList)super.clone();
            byteList.elements = new byte[Math.max(this.size, 8)];
            ByteList.arraycopy(this.elements, 0, byteList.elements, 0, this.size);
            return byteList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }

    public void ensureCapacity(int n) {
        if (n > this.elements.length) {
            byte[] byArray = new byte[Math.max(n, this.elements.length * 2)];
            ByteList.arraycopy(this.elements, 0, byArray, 0, this.size);
            this.elements = byArray;
        }
    }

    public void trimToSize() {
        if (this.size < this.elements.length) {
            if (this.size == 0) {
                this.elements = EMPTY;
            } else {
                this.elements = new byte[this.size];
                ByteList.arraycopy(this.elements, 0, this.elements, 0, this.size);
            }
        }
    }

    public final ByteList push(byte by) {
        this.add(by);
        return this;
    }

    public final ByteList push(byte by, byte by2) {
        this.add(by);
        this.add(by2);
        return this;
    }

    public final ByteList push(byte by, byte by2, byte by3) {
        this.add(by);
        this.add(by2);
        this.add(by3);
        return this;
    }

    public boolean add(byte by) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size] = by;
        ++this.size;
        return true;
    }

    public void add(int n, byte by) {
        if (n >= this.size) {
            this.ensureCapacity(n + 1);
            ByteList.clear(this.elements, this.size, n - this.size);
        } else {
            this.ensureCapacity(this.size + 1);
            ByteList.arraycopy(this.elements, n, this.elements, n + 1, this.size - n);
        }
        this.elements[n] = by;
        ++this.size;
    }

    public void addIfNotContained(byte by) {
        if (!this.contains(by)) {
            this.add(by);
        }
    }

    public ByteList addAll(ByteList byteList) {
        return this.addAll(byteList.elements, 0, byteList.size);
    }

    public ByteList addAll(byte[] byArray, int n, int n2) {
        if (n2 <= 0) {
            return this;
        }
        this.ensureCapacity(this.size + n2);
        ByteList.arraycopy(byArray, n, this.elements, this.size, n2);
        this.size += n2;
        return this;
    }

    public byte removeAt(int n) {
        byte by = this.elements[n];
        ByteList.arraycopy(this.elements, n + 1, this.elements, n, --this.size - n);
        return by;
    }

    public boolean remove(byte by) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (by != this.elements[i]) continue;
            this.removeAt(i);
            return true;
        }
        return false;
    }

    public byte set(int n, byte by) {
        byte by2;
        if (n >= this.size) {
            this.ensureCapacity(n + 1);
            ByteList.clear(this.elements, this.size, n - this.size);
            by2 = this.elements[n];
            this.elements[n] = by;
            this.size = n + 1;
        } else {
            by2 = this.elements[n];
            this.elements[n] = by;
        }
        return by2;
    }

    public byte get(int n) {
        return n < this.size ? this.elements[n] : (byte)0;
    }

    public byte peek(int n) {
        return n > 0 ? this.elements[this.size - n] : (byte)0;
    }

    public boolean contains(byte by) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (by != this.elements[i]) continue;
            return true;
        }
        return false;
    }

    public int indexOf(byte by) {
        for (int i = 0; i < this.size; ++i) {
            if (by != this.elements[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(byte by) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (by != this.elements[i]) continue;
            return i;
        }
        return -1;
    }

    public int binarySearch(byte by) {
        return ByteList.binarySearch(this.elements, by, 0, this.size);
    }

    public static int binarySearch(byte[] byArray, byte by) {
        return ByteList.binarySearch(byArray, by, 0, byArray.length);
    }

    public static int binarySearch(byte[] byArray, byte by, int n, int n2) {
        while (n < n2) {
            int n3 = n + n2 >> 1;
            byte by2 = byArray[n3];
            if (by2 < by) {
                n = n3 + 1;
                continue;
            }
            if (by2 > by) {
                n2 = n3;
                continue;
            }
            return n3;
        }
        return ~n;
    }

    public void writeTo(ByteBuffer byteBuffer) {
        byteBuffer.put(this.elements, 0, this.size);
    }

    public void clear() {
        this.size = 0;
    }

    public static void arraycopy(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (n3 < 20) {
            if (byArray2 != byArray || n2 > n) {
                while (--n3 >= 0) {
                    byArray2[n2 + n3] = byArray[n + n3];
                }
            } else {
                for (int i = 0; i < n3; ++i) {
                    byArray2[n2 + i] = byArray[n + i];
                }
            }
        } else {
            System.arraycopy(byArray, n, byArray2, n2, n3);
        }
    }

    public static void clear(byte[] byArray, int n, int n2) {
        if (n2 < 20) {
            while (--n2 >= 0) {
                byArray[n + n2] = 0;
            }
        } else {
            while (n2 > 0) {
                int n3 = n2 > 1024 ? 1024 : n2;
                ByteList.arraycopy(BYTE_NULL, 0, byArray, n, n3);
                n2 -= n3;
                n += n3;
            }
        }
    }

    public byte pop() {
        return this.elements[--this.size];
    }

    public void setSize(int n) {
        if (n > this.size) {
            this.ensureCapacity(n);
        }
        this.size = n;
    }

    public final int size() {
        return this.size;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public byte[] toArray() {
        byte[] byArray = new byte[this.size];
        ByteList.arraycopy(this.elements, 0, byArray, 0, this.size);
        return byArray;
    }

    public byte[] toArray(byte[] byArray) {
        int n = byArray.length;
        if (n > this.size) {
            byArray[this.size] = 0;
        } else if (n < this.size) {
            byArray = new byte[this.size];
        }
        ByteList.arraycopy(this.elements, 0, byArray, 0, this.size);
        return byArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString()).append('{');
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.elements[i]);
        }
        return stringBuffer.append('}').toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ByteList)) {
            return false;
        }
        ByteList byteList = (ByteList)object;
        if (this.size != byteList.size()) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.elements[i] == byteList.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = 31 * n + this.elements[i];
        }
        return n;
    }

    public void consume(byte by) {
        this.add(by);
    }

    public void evaluateByte(ByteConsumer byteConsumer) {
        for (int i = 0; i < this.size; ++i) {
            byteConsumer.consume(this.elements[i]);
        }
    }

    public void values(ByteConsumer byteConsumer) {
        this.evaluateByte(byteConsumer);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (int i = 0; i < this.size; ++i) {
            objectOutputStream.writeByte(this.elements[i]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.elements = new byte[this.size];
        byte[] byArray = this.elements;
        for (int i = 0; i < this.size; ++i) {
            byArray[i] = objectInputStream.readByte();
        }
    }
}

