/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.util;

import de.grogra.xl.lang.LongConsumer;
import de.grogra.xl.lang.VoidToLongGenerator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.LongBuffer;

public class LongList
implements Cloneable,
Serializable,
LongConsumer,
VoidToLongGenerator {
    private static final long serialVersionUID = 6294004604871934110L;
    public transient long[] elements;
    public int size = 0;
    private static final long[] EMPTY = new long[0];
    private static final long[] LONG_NULL = new long[1024];

    public LongList(int n) {
        this.elements = new long[Math.max(n, 8)];
    }

    public LongList() {
        this(16);
    }

    public LongList(long[] lArray) {
        this(lArray.length);
        this.size = lArray.length;
        LongList.arraycopy(lArray, 0, this.elements, 0, this.size);
    }

    public Object clone() {
        try {
            LongList longList = (LongList)super.clone();
            longList.elements = new long[Math.max(this.size, 8)];
            LongList.arraycopy(this.elements, 0, longList.elements, 0, this.size);
            return longList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }

    public void ensureCapacity(int n) {
        if (n > this.elements.length) {
            long[] lArray = new long[Math.max(n, this.elements.length * 2)];
            LongList.arraycopy(this.elements, 0, lArray, 0, this.size);
            this.elements = lArray;
        }
    }

    public void trimToSize() {
        if (this.size < this.elements.length) {
            if (this.size == 0) {
                this.elements = EMPTY;
            } else {
                this.elements = new long[this.size];
                LongList.arraycopy(this.elements, 0, this.elements, 0, this.size);
            }
        }
    }

    public final LongList push(long l) {
        this.add(l);
        return this;
    }

    public final LongList push(long l, long l2) {
        this.add(l);
        this.add(l2);
        return this;
    }

    public final LongList push(long l, long l2, long l3) {
        this.add(l);
        this.add(l2);
        this.add(l3);
        return this;
    }

    public boolean add(long l) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size] = l;
        ++this.size;
        return true;
    }

    public void add(int n, long l) {
        if (n >= this.size) {
            this.ensureCapacity(n + 1);
            LongList.clear(this.elements, this.size, n - this.size);
        } else {
            this.ensureCapacity(this.size + 1);
            LongList.arraycopy(this.elements, n, this.elements, n + 1, this.size - n);
        }
        this.elements[n] = l;
        ++this.size;
    }

    public void addIfNotContained(long l) {
        if (!this.contains(l)) {
            this.add(l);
        }
    }

    public LongList addAll(LongList longList) {
        return this.addAll(longList.elements, 0, longList.size);
    }

    public LongList addAll(long[] lArray, int n, int n2) {
        if (n2 <= 0) {
            return this;
        }
        this.ensureCapacity(this.size + n2);
        LongList.arraycopy(lArray, n, this.elements, this.size, n2);
        this.size += n2;
        return this;
    }

    public long removeAt(int n) {
        long l = this.elements[n];
        LongList.arraycopy(this.elements, n + 1, this.elements, n, --this.size - n);
        return l;
    }

    public boolean remove(long l) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (l != this.elements[i]) continue;
            this.removeAt(i);
            return true;
        }
        return false;
    }

    public long set(int n, long l) {
        long l2;
        if (n >= this.size) {
            this.ensureCapacity(n + 1);
            LongList.clear(this.elements, this.size, n - this.size);
            l2 = this.elements[n];
            this.elements[n] = l;
            this.size = n + 1;
        } else {
            l2 = this.elements[n];
            this.elements[n] = l;
        }
        return l2;
    }

    public long get(int n) {
        return n < this.size ? this.elements[n] : 0L;
    }

    public long peek(int n) {
        return n > 0 ? this.elements[this.size - n] : 0L;
    }

    public boolean contains(long l) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (l != this.elements[i]) continue;
            return true;
        }
        return false;
    }

    public int indexOf(long l) {
        for (int i = 0; i < this.size; ++i) {
            if (l != this.elements[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(long l) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (l != this.elements[i]) continue;
            return i;
        }
        return -1;
    }

    public int binarySearch(long l) {
        return LongList.binarySearch(this.elements, l, 0, this.size);
    }

    public static int binarySearch(long[] lArray, long l) {
        return LongList.binarySearch(lArray, l, 0, lArray.length);
    }

    public static int binarySearch(long[] lArray, long l, int n, int n2) {
        while (n < n2) {
            int n3 = n + n2 >> 1;
            long l2 = lArray[n3];
            if (l2 < l) {
                n = n3 + 1;
                continue;
            }
            if (l2 > l) {
                n2 = n3;
                continue;
            }
            return n3;
        }
        return ~n;
    }

    public void writeTo(LongBuffer longBuffer) {
        longBuffer.put(this.elements, 0, this.size);
    }

    public void clear() {
        this.size = 0;
    }

    public static void arraycopy(long[] lArray, int n, long[] lArray2, int n2, int n3) {
        if (n3 < 20) {
            if (lArray2 != lArray || n2 > n) {
                while (--n3 >= 0) {
                    lArray2[n2 + n3] = lArray[n + n3];
                }
            } else {
                for (int i = 0; i < n3; ++i) {
                    lArray2[n2 + i] = lArray[n + i];
                }
            }
        } else {
            System.arraycopy(lArray, n, lArray2, n2, n3);
        }
    }

    public static void clear(long[] lArray, int n, int n2) {
        if (n2 < 20) {
            while (--n2 >= 0) {
                lArray[n + n2] = 0L;
            }
        } else {
            while (n2 > 0) {
                int n3 = n2 > 1024 ? 1024 : n2;
                LongList.arraycopy(LONG_NULL, 0, lArray, n, n3);
                n2 -= n3;
                n += n3;
            }
        }
    }

    public long pop() {
        return this.elements[--this.size];
    }

    public void setSize(int n) {
        if (n > this.size) {
            this.ensureCapacity(n);
        }
        this.size = n;
    }

    public final int size() {
        return this.size;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public long[] toArray() {
        long[] lArray = new long[this.size];
        LongList.arraycopy(this.elements, 0, lArray, 0, this.size);
        return lArray;
    }

    public long[] toArray(long[] lArray) {
        int n = lArray.length;
        if (n > this.size) {
            lArray[this.size] = 0L;
        } else if (n < this.size) {
            lArray = new long[this.size];
        }
        LongList.arraycopy(this.elements, 0, lArray, 0, this.size);
        return lArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString()).append('{');
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.elements[i]);
        }
        return stringBuffer.append('}').toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LongList)) {
            return false;
        }
        LongList longList = (LongList)object;
        if (this.size != longList.size()) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.elements[i] == longList.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = this.elements[i];
            n = 31 * n + ((int)l ^ (int)(l >>> 32));
        }
        return n;
    }

    public void consume(long l) {
        this.add(l);
    }

    public void evaluateLong(LongConsumer longConsumer) {
        for (int i = 0; i < this.size; ++i) {
            longConsumer.consume(this.elements[i]);
        }
    }

    public void values(LongConsumer longConsumer) {
        this.evaluateLong(longConsumer);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (int i = 0; i < this.size; ++i) {
            objectOutputStream.writeLong(this.elements[i]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.elements = new long[this.size];
        long[] lArray = this.elements;
        for (int i = 0; i < this.size; ++i) {
            lArray[i] = objectInputStream.readLong();
        }
    }
}

