/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.runtime.java.lang;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import net.sourceforge.retroweaver.runtime.java.lang.Enum;
import net.sourceforge.retroweaver.runtime.java.lang.TypeNotPresentException;
import net.sourceforge.retroweaver.runtime.java.lang.annotation.AIB;
import net.sourceforge.retroweaver.runtime.java.lang.annotation.Annotation;
import net.sourceforge.retroweaver.runtime.java.lang.reflect.GenericSignatureFormatError;
import net.sourceforge.retroweaver.runtime.java.lang.reflect.MalformedParameterizedTypeException;
import net.sourceforge.retroweaver.runtime.java.lang.reflect.ReflectionDescriptor;
import net.sourceforge.retroweaver.runtime.java.lang.reflect.Type;
import net.sourceforge.retroweaver.runtime.java.lang.reflect.TypeVariable;

public final class Class_ {
    private Class_() {
    }

    public static boolean isAnnotation(Class clazz) {
        return Annotation.class.isAssignableFrom(clazz);
    }

    public static <T extends Annotation> T getAnnotation(Class clazz, Class<T> clazz2) {
        if (clazz2 == null) {
            throw new NullPointerException("Null annotationType");
        }
        return AIB.getAib(clazz).getClassAnnotation(clazz2);
    }

    public static Annotation[] getAnnotations(Class clazz) {
        return AIB.getAib(clazz).getClassAnnotations();
    }

    public static Annotation[] getDeclaredAnnotations(Class clazz) {
        return AIB.getAib(clazz).getDeclaredClassAnnotations();
    }

    public static boolean isAnnotationPresent(Class clazz, Class<? extends Annotation> clazz2) {
        return Class_.getAnnotation(clazz, clazz2) != null;
    }

    public static Class asSubclass(Class<?> clazz, Class<?> clazz2) {
        if (!clazz2.isAssignableFrom(clazz)) {
            throw new ClassCastException(clazz2.getName());
        }
        return clazz;
    }

    public static Object cast(Class clazz, Object object) {
        if (object == null || clazz.isInstance(object)) {
            return object;
        }
        throw new ClassCastException(clazz.getName());
    }

    public static <T> boolean isEnum(Class<T> clazz) {
        Class<T> clazz2 = clazz.getSuperclass();
        if (clazz2 == null) {
            return false;
        }
        return Enum.class.isAssignableFrom(clazz2);
    }

    public static <T> T[] getEnumConstants(Class<T> clazz) {
        if (!Class_.isEnum(clazz)) {
            return null;
        }
        return (Object[])Enum.getEnumValues(clazz).clone();
    }

    public static boolean isAnonymousClass(Class clazz) {
        return Class_.getSimpleName(clazz).length() == 0;
    }

    public static String getSimpleName(Class clazz) {
        if (clazz.isArray()) {
            return Class_.getSimpleName(clazz.getComponentType()) + "[]";
        }
        String string = clazz.getName();
        int n = string.lastIndexOf(36);
        if (n != -1) {
            while (++n < string.length() && Character.isDigit(string.charAt(n))) {
            }
            return string.substring(n);
        }
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public static boolean isSynthetic(Class clazz) {
        throw new UnsupportedOperationException("NotImplemented");
    }

    public static TypeVariable[] getTypeParameters(Class clazz) throws GenericSignatureFormatError {
        return ReflectionDescriptor.getReflectionDescriptor(clazz).getTypeParameters();
    }

    public static Type getGenericSuperclass(Class clazz) throws GenericSignatureFormatError, TypeNotPresentException, MalformedParameterizedTypeException {
        return ReflectionDescriptor.getReflectionDescriptor(clazz).getGenericSuperclass();
    }

    public static Type[] getGenericInterfaces(Class clazz) throws GenericSignatureFormatError, TypeNotPresentException, MalformedParameterizedTypeException {
        return ReflectionDescriptor.getReflectionDescriptor(clazz).getGenericInterfaces();
    }

    public static Method getEnclosingMethod(Class clazz) {
        return ReflectionDescriptor.getReflectionDescriptor(clazz).getEnclosingMethod();
    }

    public static Constructor<?> getEnclosingConstructor(Class clazz) {
        return ReflectionDescriptor.getReflectionDescriptor(clazz).getEnclosingConstructor();
    }

    public static Class<?> getEnclosingClass(Class clazz) {
        return ReflectionDescriptor.getReflectionDescriptor(clazz).getEnclosingClass();
    }

    public static String getCanonicalName(Class clazz) {
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            String string = Class_.getCanonicalName(clazz2);
            return string == null ? null : string + "[]";
        }
        if (Class_.isLocalClass(clazz) || Class_.isAnonymousClass(clazz)) {
            return null;
        }
        return clazz.getName().replace('$', '.');
    }

    public static boolean isLocalClass(Class clazz) {
        return Class_.getEnclosingMethod(clazz) != null && !Class_.isAnonymousClass(clazz);
    }

    public static boolean isMemberClass(Class clazz) {
        if (Class_.getEnclosingClass(clazz) != null) {
            return !Class_.isLocalClass(clazz) && !Class_.isAnonymousClass(clazz);
        }
        return false;
    }
}

