/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.runtime.java.lang.annotation;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sourceforge.retroweaver.runtime.java.lang.Enum;
import net.sourceforge.retroweaver.runtime.java.lang.annotation.Annotation;
import net.sourceforge.retroweaver.runtime.java.lang.annotation.AnnotationFormatError;
import net.sourceforge.retroweaver.runtime.java.lang.annotation.AnnotationImpl;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class AIB
implements ClassVisitor {
    private Class class_;
    private Map<String, Annotation> classAnnotations = new HashMap<String, Annotation>();
    private Map<String, Map<String, Annotation>> methodAnnotations = new HashMap<String, Map<String, Annotation>>();
    private Map<String, ArrayList<Map<String, Annotation>>> methodParameterAnnotations = new HashMap<String, ArrayList<Map<String, Annotation>>>();
    private Map<String, Map<String, Annotation>> fieldAnnotations = new HashMap<String, Map<String, Annotation>>();
    private Map<String, Annotation> inheritedClassAnnotations = new HashMap<String, Annotation>();
    private Map<String, Object> cachedMethodDefaults;
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private static final Annotation[][] EMPTY_ANNOTATION_ARRAY_ARRAY = new Annotation[0][];
    private static final Method cloneMethod;
    private static final Map<Class, AIB> classDescriptors;
    public static final AIBEmptyVisitor EMPTY_VISITOR;

    private AIB(Class clazz) {
        this.class_ = clazz;
        classDescriptors.put(clazz, this);
        this.readClassStream(clazz.getName(), this);
    }

    private void readClassStream(String string, ClassVisitor classVisitor) {
        String string2 = "/" + string.replace('.', '/') + ".class";
        InputStream inputStream = this.class_.getResourceAsStream(string2);
        try {
            ClassReader classReader = new ClassReader(inputStream);
            classReader.accept(classVisitor, 7);
            Class clazz = this.class_.getSuperclass();
            if (clazz != null) {
                AIB aIB = AIB.getAib(clazz);
                for (Map.Entry<String, Annotation> entry : aIB.inheritedClassAnnotations.entrySet()) {
                    this.inheritedClassAnnotations.put(entry.getKey(), entry.getValue());
                }
            }
            for (Map.Entry entry : this.classAnnotations.entrySet()) {
                this.inheritedClassAnnotations.put((String)entry.getKey(), (Annotation)entry.getValue());
            }
        }
        catch (IOException iOException) {
            throw new AnnotationFormatError("[Retroweaver] Unable to read annotation data for: " + string, iOException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public Annotation[] getClassAnnotations() {
        return this.inheritedClassAnnotations.values().toArray(EMPTY_ANNOTATION_ARRAY);
    }

    public Annotation[] getDeclaredClassAnnotations() {
        return this.classAnnotations.values().toArray(EMPTY_ANNOTATION_ARRAY);
    }

    public <T extends Annotation> T getClassAnnotation(Class<T> clazz) {
        return (T)this.inheritedClassAnnotations.get(clazz.getName());
    }

    public Annotation[] getFieldAnnotations(String string) {
        Map<String, Annotation> map = this.fieldAnnotations.get(string);
        return map.values().toArray(EMPTY_ANNOTATION_ARRAY);
    }

    public <T extends Annotation> T getFieldAnnotation(String string, Class<T> clazz) {
        Map<String, Annotation> map = this.fieldAnnotations.get(string);
        return (T)map.get(clazz.getName());
    }

    private String getMethodIdentifier(String string, Class[] classArray, Class clazz) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append('(');
        for (Class clazz2 : classArray) {
            stringBuilder.append(Type.getDescriptor(clazz2));
        }
        stringBuilder.append(')').append(Type.getDescriptor(clazz));
        return stringBuilder.toString();
    }

    public Annotation[] getMethodAnnotations(String string, Class[] classArray, Class clazz) {
        Map<String, Annotation> map = this.methodAnnotations.get(this.getMethodIdentifier(string, classArray, clazz));
        if (map == null) {
            return EMPTY_ANNOTATION_ARRAY;
        }
        return map.values().toArray(EMPTY_ANNOTATION_ARRAY);
    }

    public <T extends Annotation> T getMethodAnnotation(String string, Class[] classArray, Class clazz, Class<T> clazz2) {
        Map<String, Annotation> map = this.methodAnnotations.get(this.getMethodIdentifier(string, classArray, clazz));
        if (map == null) {
            return null;
        }
        return (T)map.get(clazz2.getName());
    }

    private Map<String, Object> getMethodDefaults() {
        assert (this.class_.isAnnotation());
        if (this.cachedMethodDefaults == null) {
            DefaultValueVisitor defaultValueVisitor = new DefaultValueVisitor();
            this.cachedMethodDefaults = defaultValueVisitor.parseAttributes(this.class_.getName());
        }
        return this.cachedMethodDefaults;
    }

    public Object getDefaultValue(String string) {
        assert (this.class_.isAnnotation());
        Object object = this.getMethodDefaults().get(string);
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            try {
                object = cloneMethod.invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }
        return object;
    }

    public Annotation[][] getMethodParameterAnnotations(String string, Class[] classArray, Class clazz) {
        ArrayList<Map<String, Annotation>> arrayList = this.methodParameterAnnotations.get(this.getMethodIdentifier(string, classArray, clazz));
        if (arrayList == null) {
            return EMPTY_ANNOTATION_ARRAY_ARRAY;
        }
        Annotation[][] annotationArray = new Annotation[classArray.length][];
        for (int i = 0; i < classArray.length; ++i) {
            Map<String, Annotation> map = i < arrayList.size() ? arrayList.get(i) : null;
            annotationArray[i] = map == null ? EMPTY_ANNOTATION_ARRAY : map.values().toArray(EMPTY_ANNOTATION_ARRAY);
        }
        return annotationArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AIB getAib(Class clazz) {
        Map<Class, AIB> map = classDescriptors;
        synchronized (map) {
            AIB aIB = classDescriptors.get(clazz);
            if (aIB == null) {
                aIB = new AIB(clazz);
            }
            return aIB;
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        if (!bl) {
            return EMPTY_VISITOR;
        }
        return new TopLevelAnnotation(string, this.classAnnotations);
    }

    @Override
    public FieldVisitor visitField(int n, final String string, String string2, String string3, Object object) {
        return new FieldVisitor(){
            Map<String, Annotation> annotations = new HashMap<String, Annotation>();

            @Override
            public AnnotationVisitor visitAnnotation(String string2, boolean bl) {
                if (!bl) {
                    return EMPTY_VISITOR;
                }
                return new TopLevelAnnotation(string2, this.annotations);
            }

            @Override
            public void visitAttribute(Attribute attribute) {
            }

            @Override
            public void visitEnd() {
                AIB.this.fieldAnnotations.put(string, this.annotations);
            }
        };
    }

    @Override
    public MethodVisitor visitMethod(int n, final String string, final String string2, String string3, String[] stringArray) {
        return new MethodAdapter(EMPTY_VISITOR){
            Map<String, Annotation> ma;
            ArrayList<Map<String, Annotation>> pa;
            {
                super(methodVisitor);
                this.ma = new HashMap<String, Annotation>();
                this.pa = new ArrayList();
            }

            @Override
            public AnnotationVisitor visitAnnotationDefault() {
                return EMPTY_VISITOR;
            }

            @Override
            public AnnotationVisitor visitAnnotation(String string3, boolean bl) {
                if (!bl) {
                    return EMPTY_VISITOR;
                }
                return new TopLevelAnnotation(string3, this.ma);
            }

            @Override
            public AnnotationVisitor visitParameterAnnotation(int n, String string3, boolean bl) {
                if (!bl) {
                    return EMPTY_VISITOR;
                }
                while (n >= this.pa.size()) {
                    this.pa.add(null);
                }
                Map<String, Annotation> map = this.pa.get(n);
                if (map == null) {
                    map = new HashMap<String, Annotation>();
                    this.pa.set(n, map);
                }
                return new TopLevelAnnotation(string3, map);
            }

            @Override
            public void visitEnd() {
                String string3 = string + string2;
                AIB.this.methodAnnotations.put(string3, this.ma);
                AIB.this.methodParameterAnnotations.put(string3, this.pa);
            }
        };
    }

    @Override
    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
    }

    @Override
    public void visitSource(String string, String string2) {
    }

    @Override
    public void visitOuterClass(String string, String string2, String string3) {
    }

    @Override
    public void visitAttribute(Attribute attribute) {
    }

    @Override
    public void visitInnerClass(String string, String string2, String string3, int n) {
    }

    @Override
    public void visitEnd() {
    }

    static {
        try {
            cloneMethod = Object.class.getDeclaredMethod("clone", new Class[0]);
            cloneMethod.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException.getMessage());
        }
        classDescriptors = new Hashtable<Class, AIB>();
        EMPTY_VISITOR = new AIBEmptyVisitor();
    }

    public static final class AIBEmptyVisitor
    implements ClassVisitor,
    FieldVisitor,
    MethodVisitor,
    AnnotationVisitor {
        @Override
        public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        }

        @Override
        public void visitSource(String string, String string2) {
        }

        @Override
        public void visitOuterClass(String string, String string2, String string3) {
        }

        @Override
        public AnnotationVisitor visitAnnotation(String string, boolean bl) {
            return this;
        }

        @Override
        public void visitAttribute(Attribute attribute) {
        }

        @Override
        public void visitInnerClass(String string, String string2, String string3, int n) {
        }

        @Override
        public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
            return this;
        }

        @Override
        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            return this;
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public AnnotationVisitor visitAnnotationDefault() {
            return this;
        }

        @Override
        public AnnotationVisitor visitParameterAnnotation(int n, String string, boolean bl) {
            return this;
        }

        @Override
        public void visitCode() {
        }

        @Override
        public void visitFrame(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        }

        @Override
        public void visitInsn(int n) {
        }

        @Override
        public void visitIntInsn(int n, int n2) {
        }

        @Override
        public void visitVarInsn(int n, int n2) {
        }

        @Override
        public void visitTypeInsn(int n, String string) {
        }

        @Override
        public void visitFieldInsn(int n, String string, String string2, String string3) {
        }

        @Override
        public void visitMethodInsn(int n, String string, String string2, String string3) {
        }

        @Override
        public void visitJumpInsn(int n, Label label) {
        }

        @Override
        public void visitLabel(Label label) {
        }

        @Override
        public void visitLdcInsn(Object object) {
        }

        @Override
        public void visitIincInsn(int n, int n2) {
        }

        @Override
        public void visitTableSwitchInsn(int n, int n2, Label label, Label[] labelArray) {
        }

        @Override
        public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        }

        @Override
        public void visitMultiANewArrayInsn(String string, int n) {
        }

        @Override
        public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        }

        @Override
        public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
        }

        @Override
        public void visitLineNumber(int n, Label label) {
        }

        @Override
        public void visitMaxs(int n, int n2) {
        }

        @Override
        public void visit(String string, Object object) {
        }

        @Override
        public void visitEnum(String string, String string2, String string3) {
        }

        @Override
        public AnnotationVisitor visitAnnotation(String string, String string2) {
            return this;
        }

        @Override
        public AnnotationVisitor visitArray(String string) {
            return this;
        }
    }

    private class TopLevelAnnotation
    extends AbstractAnnotationVisitor {
        private final Map<String, Annotation> annotations;
        private final Map<String, Object> attributes;

        TopLevelAnnotation(String string, Map<String, Annotation> map) {
            super(null, string);
            this.annotations = map;
            String string2 = Type.getType(string).getClassName();
            this.attributes = new HashMap<String, Object>(AIB.getAib(this.getClass(string2)).getMethodDefaults());
        }

        private String getClassNameFromInternalName(String string) {
            if (string.charAt(0) != 'L') {
                return string;
            }
            return string.replace('/', '.').substring(1, string.length() - 1);
        }

        @Override
        void insertValue(String string, Object object) {
            String string2 = this.getClassNameFromInternalName(string);
            this.attributes.put(string2, object);
        }

        @Override
        public AnnotationVisitor visitArray(String string) {
            try {
                String string2 = Type.getType(this.className).getClassName();
                Method method = Class.forName(string2).getMethod(string, new Class[0]);
                string2 = method.getReturnType().getName();
                return new ArrayAnnotation(this, string, string2);
            }
            catch (Exception exception) {
                throw new AnnotationFormatError(exception);
            }
        }

        @Override
        public void visitEnd() {
            Annotation annotation = this.createAnnotation(this.className, this.attributes);
            String string = this.getClassNameFromInternalName(this.className);
            this.annotations.put(string, annotation);
        }
    }

    private class DefaultAnnotation
    extends AbstractAnnotationVisitor {
        private final String type;
        private final Map<String, Object> attributes;

        DefaultAnnotation(String string, String string2, Map<String, Object> map) {
            super(null, string);
            this.type = string2;
            this.attributes = map;
        }

        @Override
        void insertValue(String string, Object object) {
            this.attributes.put(this.className, object);
        }

        @Override
        public AnnotationVisitor visitArray(String string) {
            return new ArrayAnnotation(this, this.className, this.type);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String string, String string2) {
            return new NestedAnnotation(this, this.className);
        }

        @Override
        public void visitEnd() {
        }
    }

    private class NestedAnnotation
    extends AbstractAnnotationVisitor {
        private final Map<String, Object> attributes;

        NestedAnnotation(AbstractAnnotationVisitor abstractAnnotationVisitor, String string) {
            super(abstractAnnotationVisitor, string);
            this.attributes = new HashMap<String, Object>();
        }

        @Override
        void insertValue(String string, Object object) {
            this.attributes.put(string, object);
        }

        @Override
        public AnnotationVisitor visitArray(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visitEnd() {
            Annotation annotation = this.createAnnotation(this.className, this.attributes);
            this.parent.insertValue(this.className, annotation);
        }
    }

    private class ArrayAnnotation
    extends AbstractAnnotationVisitor {
        private final String type;
        private final List<Object> values;

        ArrayAnnotation(AbstractAnnotationVisitor abstractAnnotationVisitor, String string, String string2) {
            super(abstractAnnotationVisitor, string);
            this.values = new LinkedList<Object>();
            this.type = string2;
        }

        @Override
        void insertValue(String string, Object object) {
            this.values.add(object);
        }

        @Override
        public AnnotationVisitor visitArray(String string) {
            throw new UnsupportedOperationException("Nested arrays are not allowed");
        }

        @Override
        public void visitEnd() {
            Class<?> clazz = this.getClass(this.type.replace('/', '.'));
            clazz = clazz.getComponentType();
            Object[] objectArray = Array.newInstance(clazz, this.values.size());
            if (!this.values.isEmpty()) {
                objectArray = this.values.toArray((Object[])objectArray);
            }
            this.parent.insertValue(this.className, objectArray);
        }
    }

    abstract class AbstractAnnotationVisitor
    implements AnnotationVisitor {
        protected final AbstractAnnotationVisitor parent;
        protected final String className;

        AbstractAnnotationVisitor(AbstractAnnotationVisitor abstractAnnotationVisitor, String string) {
            this.parent = abstractAnnotationVisitor;
            this.className = string;
        }

        protected Class getClass(String string) {
            try {
                return Class.forName(string, true, AIB.this.class_.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AnnotationFormatError("[Retroweaver] Unable to find class: " + string, classNotFoundException);
            }
        }

        protected Annotation createAnnotation(String string, Map<String, Object> map) {
            String string2 = Type.getType(string).getClassName();
            Class clazz = this.getClass(string2);
            Annotation annotation = AnnotationImpl.createAnnotation(clazz, map);
            return annotation;
        }

        private Object getEnumValue(String string, String string2) {
            String string3 = Type.getType(string).getClassName();
            Class clazz = this.getClass(string3);
            return Enum.valueOf(clazz, string2);
        }

        abstract void insertValue(String var1, Object var2);

        @Override
        public void visit(String string, Object object) {
            Object object2;
            if (object instanceof Type) {
                Type type = (Type)object;
                object2 = this.getClass(type.getClassName());
            } else {
                object2 = object;
            }
            this.insertValue(string, object2);
        }

        @Override
        public void visitEnum(String string, String string2, String string3) {
            this.insertValue(string, this.getEnumValue(string2, string3));
        }

        @Override
        public AnnotationVisitor visitAnnotation(String string, String string2) {
            return new NestedAnnotation(this, string2);
        }
    }

    class DefaultValueVisitor
    implements ClassVisitor {
        private final Map<String, Object> attributes = new HashMap<String, Object>();

        DefaultValueVisitor() {
        }

        Map<String, Object> parseAttributes(String string) {
            AIB.this.readClassStream(string, this);
            return this.attributes;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String string, boolean bl) {
            return EMPTY_VISITOR;
        }

        @Override
        public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
            return EMPTY_VISITOR;
        }

        @Override
        public MethodVisitor visitMethod(int n, final String string, final String string2, String string3, String[] stringArray) {
            return new MethodAdapter(EMPTY_VISITOR){

                @Override
                public AnnotationVisitor visitAnnotationDefault() {
                    String string3 = string2.substring(2);
                    return new DefaultAnnotation(string, string3, DefaultValueVisitor.this.attributes);
                }

                @Override
                public AnnotationVisitor visitAnnotation(String string3, boolean bl) {
                    return EMPTY_VISITOR;
                }

                @Override
                public AnnotationVisitor visitParameterAnnotation(int n, String string3, boolean bl) {
                    return EMPTY_VISITOR;
                }
            };
        }

        @Override
        public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        }

        @Override
        public void visitSource(String string, String string2) {
        }

        @Override
        public void visitOuterClass(String string, String string2, String string3) {
        }

        @Override
        public void visitAttribute(Attribute attribute) {
        }

        @Override
        public void visitInnerClass(String string, String string2, String string3, int n) {
        }

        @Override
        public void visitEnd() {
        }
    }
}

