/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.runtime.java.lang.reflect;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.sourceforge.retroweaver.runtime.java.lang.TypeNotPresentException;
import net.sourceforge.retroweaver.runtime.java.lang.annotation.AIB;
import net.sourceforge.retroweaver.runtime.java.lang.reflect.GenericArrayType;
import net.sourceforge.retroweaver.runtime.java.lang.reflect.GenericDeclaration;
import net.sourceforge.retroweaver.runtime.java.lang.reflect.GenericSignatureFormatError;
import net.sourceforge.retroweaver.runtime.java.lang.reflect.MalformedParameterizedTypeException;
import net.sourceforge.retroweaver.runtime.java.lang.reflect.ParameterizedType;
import net.sourceforge.retroweaver.runtime.java.lang.reflect.Type;
import net.sourceforge.retroweaver.runtime.java.lang.reflect.TypeVariable;
import net.sourceforge.retroweaver.runtime.java.lang.reflect.WildcardType;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public class ReflectionDescriptor
implements ClassVisitor {
    private static final boolean DEBUG = false;
    private static final Map<Class, ReflectionDescriptor> descriptors = new HashMap<Class, ReflectionDescriptor>();
    private final Class class_;
    private String internalName;
    private String enclosingClassName;
    private String enclosingMethodName;
    private String enclosingMethodDesc;
    private HashMap<String, Integer> fieldAccessTable = new HashMap();
    private HashMap<String, Integer> methodAccessTable = new HashMap();
    private TypeVariable[] typeParameters;
    private Type genericSuperclass;
    private Type[] genericInterfaces;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReflectionDescriptor getReflectionDescriptor(Class clazz) {
        Map<Class, ReflectionDescriptor> map = descriptors;
        synchronized (map) {
            ReflectionDescriptor reflectionDescriptor = descriptors.get(clazz);
            if (reflectionDescriptor == null) {
                reflectionDescriptor = new ReflectionDescriptor(clazz);
                descriptors.put(clazz, reflectionDescriptor);
            }
            return reflectionDescriptor;
        }
    }

    private ReflectionDescriptor(Class clazz) {
        this.class_ = clazz;
        String string = clazz.getName();
        String string2 = "/" + string.replace('.', '/') + ".class";
        InputStream inputStream = clazz.getResourceAsStream(string2);
        this.parseStream(string, inputStream);
    }

    protected ReflectionDescriptor(String string, InputStream inputStream) {
        this.class_ = null;
        this.parseStream(string, inputStream);
    }

    private void parseStream(String string, InputStream inputStream) {
        try {
            ClassReader classReader = new ClassReader(inputStream);
            classReader.accept(this, 7);
        }
        catch (IOException iOException) {
            throw new TypeNotPresentException("[Retroweaver] Unable to read reflection data for: " + string, iOException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public String getEnclosingClassName() {
        return this.enclosingClassName;
    }

    public void debugMessage(String string) {
        System.out.println(string + "\n\tclass: " + this.class_.getName() + "\n\tenclosingClassName: " + this.enclosingClassName + "\n\tenclosingMethodName: " + this.enclosingMethodName + ' ' + this.enclosingMethodDesc);
    }

    public Class getEnclosingClass() {
        if (this.enclosingClassName == null) {
            return null;
        }
        try {
            String string = this.enclosingClassName.replace('/', '.');
            Class<?> clazz = this.class_.getClassLoader().loadClass(string);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public Method getEnclosingMethod() {
        if (this.enclosingMethodName == null) {
            return null;
        }
        return this.getMethod(this.getEnclosingClass(), this.enclosingMethodName, this.enclosingMethodDesc);
    }

    public Constructor getEnclosingConstructor() {
        if (this.enclosingMethodName == null) {
            return null;
        }
        return this.getConstructor(this.getEnclosingClass(), this.enclosingMethodDesc);
    }

    public boolean testFieldAccess(Field field, int n) {
        String string = field.getName();
        return (this.fieldAccessTable.get(string) & n) != 0;
    }

    public boolean testMethodAccess(Method method, int n) {
        String string = method.getName();
        String string2 = org.objectweb.asm.Type.getMethodDescriptor(method);
        return (this.methodAccessTable.get(string + string2) & n) != 0;
    }

    public boolean testConstructorAccess(Constructor constructor, int n) {
        String string = "<init>";
        String string2 = org.objectweb.asm.Type.getConstructorDescriptor(constructor);
        return (this.methodAccessTable.get(string + string2) & n) != 0;
    }

    private Method getMethod(Class clazz, String string, String string2) {
        org.objectweb.asm.Type[] typeArray = org.objectweb.asm.Type.getArgumentTypes(string2);
        block0: for (Method method : clazz.getDeclaredMethods()) {
            org.objectweb.asm.Type[] typeArray2 = org.objectweb.asm.Type.getArgumentTypes(method);
            if (!method.getName().equals(string) || typeArray2.length != typeArray.length) continue;
            for (int i = 0; i < typeArray.length; ++i) {
                if (!typeArray[i].equals(typeArray2[i])) continue block0;
            }
            return method;
        }
        return null;
    }

    private Constructor getConstructor(Class clazz, String string) {
        org.objectweb.asm.Type[] typeArray = org.objectweb.asm.Type.getArgumentTypes(string);
        block0: for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            Class<?>[] classArray = constructor.getParameterTypes();
            if (classArray.length != typeArray.length) continue;
            for (int i = 0; i < typeArray.length; ++i) {
                if (!typeArray[i].equals(org.objectweb.asm.Type.getType(classArray[i]))) continue block0;
            }
            return constructor;
        }
        return null;
    }

    private void parseSignature(String string, boolean bl, String string2, String[] stringArray) {
        if (string == null) {
            this.typeParameters = new TypeVariable[0];
            Type type = this.genericSuperclass = string2 == null ? null : new ClassTypeImpl(string2.replaceAll("/", "."));
            if (stringArray == null) {
                this.genericInterfaces = new Type[0];
            } else {
                this.genericInterfaces = new Type[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    this.genericInterfaces[i] = new ClassTypeImpl(stringArray[i].replaceAll("/", "."), true);
                }
            }
        } else {
            SignatureReader signatureReader = new SignatureReader(string);
            ClassTypeImpl classTypeImpl = new ClassTypeImpl(this.internalName.replaceAll("/", "."), bl);
            SigVisitor sigVisitor = new SigVisitor(classTypeImpl, false);
            signatureReader.accept(sigVisitor);
            sigVisitor.endParsing();
            this.typeParameters = sigVisitor.typeParameters;
            this.genericSuperclass = sigVisitor.genericSuperclass;
            this.genericInterfaces = sigVisitor.genericInterfaces;
        }
        if (bl) {
            this.genericSuperclass = null;
        }
    }

    public TypeVariable[] getTypeParameters() throws GenericSignatureFormatError {
        return this.typeParameters;
    }

    public Type getGenericSuperclass() throws GenericSignatureFormatError, TypeNotPresentException, MalformedParameterizedTypeException {
        return this.genericSuperclass;
    }

    public Type[] getGenericInterfaces() throws GenericSignatureFormatError, TypeNotPresentException, MalformedParameterizedTypeException {
        return this.genericInterfaces;
    }

    @Override
    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        this.internalName = string;
        boolean bl = (n2 & 0x200) == 512;
        this.parseSignature(string2, bl, string3, stringArray);
    }

    @Override
    public void visitSource(String string, String string2) {
    }

    @Override
    public void visitOuterClass(String string, String string2, String string3) {
        this.enclosingClassName = string;
        this.enclosingMethodName = string2;
        this.enclosingMethodDesc = string3;
    }

    @Override
    public void visitInnerClass(String string, String string2, String string3, int n) {
        if (string.equals(this.internalName) && string2 != null) {
            this.enclosingClassName = string2;
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        return AIB.EMPTY_VISITOR;
    }

    @Override
    public void visitAttribute(Attribute attribute) {
    }

    @Override
    public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
        this.fieldAccessTable.put(string, n);
        return null;
    }

    @Override
    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        this.methodAccessTable.put(string + string2, n);
        return null;
    }

    @Override
    public void visitEnd() {
    }

    public static void main(String[] stringArray) {
        String string = "<E:Ljava/lang/String;>Ljava/util/LinkedList<TE;>;Ljava/io/Serializable;Ljava/lang/Comparable<TE;>;";
        String string2 = "blah.TopLevel";
        System.out.println("Parsing " + string);
        SignatureReader signatureReader = new SignatureReader(string);
        ClassTypeImpl classTypeImpl = new ClassTypeImpl(string2.replaceAll("/", "."), false);
        SigVisitor sigVisitor = new SigVisitor(classTypeImpl, false);
        signatureReader.accept(sigVisitor);
        sigVisitor.endParsing();
        System.out.println(sigVisitor.genericInterfaces.length);
        for (Type type : sigVisitor.genericInterfaces) {
            System.out.println(type);
        }
    }

    public static class WildcardTypeImpl
    implements WildcardType {
        @Override
        public Type[] getLowerBounds() throws TypeNotPresentException, MalformedParameterizedTypeException {
            throw new UnsupportedOperationException("NotImplemented");
        }

        @Override
        public Type[] getUpperBounds() throws TypeNotPresentException, MalformedParameterizedTypeException {
            throw new UnsupportedOperationException("NotImplemented");
        }
    }

    public static class TypeVariableImpl<D extends GenericDeclaration>
    implements TypeVariable {
        private final String name;
        private Type[] bounds;
        private D genericDeclaration;

        public TypeVariableImpl(String string) {
            this.name = string;
        }

        protected void setBounds(Type[] typeArray) {
            this.bounds = typeArray;
        }

        @Override
        public Type[] getBounds() throws TypeNotPresentException, MalformedParameterizedTypeException {
            return this.bounds;
        }

        protected void setGenericDeclaration(D d) {
            this.genericDeclaration = d;
        }

        @Override
        public D getGenericDeclaration() {
            return this.genericDeclaration;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class ParameterizedTypeImpl
    implements ParameterizedType {
        private Type owner;
        private Type[] args;
        private Type raw;

        public ParameterizedTypeImpl(Type type, Type[] typeArray, Type type2) {
            this.owner = type;
            this.args = typeArray;
            this.raw = type2;
        }

        @Override
        public Type[] getActualTypeArguments() throws TypeNotPresentException, MalformedParameterizedTypeException {
            return this.args;
        }

        @Override
        public Type getOwnerType() {
            return this.owner;
        }

        @Override
        public Type getRawType() {
            return this.raw;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.raw.toString();
            if (string.startsWith("class ")) {
                string = string.substring(6);
            } else if (string.startsWith("interface ")) {
                string = string.substring(10);
            }
            stringBuffer.append(string);
            if (this.args.length != 0) {
                stringBuffer.append('<');
                boolean bl = true;
                for (Type type : this.args) {
                    if (!bl) {
                        stringBuffer.append(", ");
                    }
                    bl = false;
                    string = type.toString();
                    if (string.startsWith("class ")) {
                        string = string.substring(6);
                    }
                    stringBuffer.append(string);
                }
                stringBuffer.append('>');
            }
            return stringBuffer.toString();
        }
    }

    public static class GenericArrayTypeImpl
    implements GenericArrayType {
        private Type genericComponentType;

        public GenericArrayTypeImpl(Type type) {
            this.genericComponentType = type;
        }

        @Override
        public Type getGenericComponentType() throws TypeNotPresentException, MalformedParameterizedTypeException {
            return this.genericComponentType;
        }
    }

    public static class ClassTypeImpl
    implements Type,
    GenericDeclaration {
        private final String name;
        private boolean isInterface;
        private TypeVariable<?>[] typeParameters;

        public ClassTypeImpl(String string) {
            this.name = string;
            this.isInterface = false;
        }

        public ClassTypeImpl(String string, boolean bl) {
            this.name = string;
            this.isInterface = bl;
        }

        public String toString() {
            return (this.isInterface ? "interface " : "class ") + this.name;
        }

        @Override
        public TypeVariable<?>[] getTypeParameters() {
            return this.typeParameters;
        }

        public void setTypeParameters(TypeVariable<?>[] typeVariableArray) {
            this.typeParameters = typeVariableArray;
        }
    }

    private static class SigVisitor
    implements SignatureVisitor {
        protected TypeVariable[] typeParameters;
        protected Type genericSuperclass;
        protected Type[] genericInterfaces;
        private Stack<Type> stack = new Stack();
        private Set<TypeVariableImpl> typeVariables = new HashSet<TypeVariableImpl>();
        private LinkedList<TypeVariableImpl> formalTypeParameters = new LinkedList();
        private StringBuffer declaration;
        private boolean isInterface;
        private ClassTypeImpl currentType;
        private boolean seenFormalParameter;
        private boolean seenInterfaceBound;
        private boolean seenParameter;
        private boolean seenInterface;
        private StringBuffer returnType;
        private StringBuffer exceptions;
        private int argumentStack;
        private Stack<Integer> argumentStackPosition = new Stack();
        private int arrayStack;
        private String separator = "";

        public SigVisitor(ClassTypeImpl classTypeImpl, boolean bl) {
            this.isInterface = bl;
            this.declaration = new StringBuffer();
            this.currentType = classTypeImpl;
        }

        private SigVisitor(StringBuffer stringBuffer) {
            this.declaration = stringBuffer;
        }

        @Override
        public void visitFormalTypeParameter(String string) {
            if (this.seenFormalParameter) {
                this.endFormal();
            }
            TypeVariableImpl typeVariableImpl = new TypeVariableImpl(string);
            this.typeVariables.add(typeVariableImpl);
            this.formalTypeParameters.add(typeVariableImpl);
            this.declaration.append(this.seenFormalParameter ? ", " : "<").append(string);
            this.seenFormalParameter = true;
            this.seenInterfaceBound = false;
        }

        @Override
        public SignatureVisitor visitClassBound() {
            this.separator = " extends ";
            this.startType();
            return this;
        }

        @Override
        public SignatureVisitor visitInterfaceBound() {
            this.separator = this.seenInterfaceBound ? ", " : " extends ";
            this.seenInterfaceBound = true;
            this.startType();
            return this;
        }

        @Override
        public SignatureVisitor visitSuperclass() {
            this.endFormals();
            this.separator = " extends ";
            this.startType();
            return this;
        }

        @Override
        public SignatureVisitor visitInterface() {
            if (!this.seenInterface) {
                this.endGenericSuperclass();
            }
            this.separator = this.seenInterface ? ", " : (this.isInterface ? " extends " : " implements ");
            this.seenInterface = true;
            this.startType();
            return this;
        }

        @Override
        public SignatureVisitor visitParameterType() {
            this.endFormals();
            if (!this.seenParameter) {
                this.seenParameter = true;
                this.declaration.append('(');
            } else {
                this.declaration.append(", ");
            }
            this.startType();
            return this;
        }

        @Override
        public SignatureVisitor visitReturnType() {
            this.endFormals();
            if (!this.seenParameter) {
                this.declaration.append('(');
            } else {
                this.seenParameter = false;
            }
            this.declaration.append(')');
            this.returnType = new StringBuffer();
            return new SigVisitor(this.returnType);
        }

        @Override
        public SignatureVisitor visitExceptionType() {
            if (this.exceptions == null) {
                this.exceptions = new StringBuffer();
            } else {
                this.exceptions.append(", ");
            }
            return new SigVisitor(this.exceptions);
        }

        @Override
        public void visitBaseType(char c) {
            switch (c) {
                case 'V': {
                    this.declaration.append("void");
                    break;
                }
                case 'B': {
                    this.declaration.append("byte");
                    break;
                }
                case 'J': {
                    this.declaration.append("long");
                    break;
                }
                case 'Z': {
                    this.declaration.append("boolean");
                    break;
                }
                case 'I': {
                    this.declaration.append("int");
                    break;
                }
                case 'S': {
                    this.declaration.append("short");
                    break;
                }
                case 'C': {
                    this.declaration.append("char");
                    break;
                }
                case 'F': {
                    this.declaration.append("float");
                    break;
                }
                default: {
                    this.declaration.append("double");
                }
            }
            this.endType();
        }

        @Override
        public void visitTypeVariable(String string) {
            TypeVariableImpl typeVariableImpl = new TypeVariableImpl(string);
            this.typeVariables.add(typeVariableImpl);
            this.stack.push(typeVariableImpl);
            this.declaration.append(string);
            this.endType();
        }

        @Override
        public SignatureVisitor visitArrayType() {
            this.startType();
            this.arrayStack |= 1;
            return this;
        }

        @Override
        public void visitClassType(String string) {
            ClassTypeImpl classTypeImpl = new ClassTypeImpl(string.replace('/', '.'));
            this.stack.push(classTypeImpl);
            if (!"java/lang/Object".equals(string)) {
                this.declaration.append(this.separator).append(string.replace('/', '.'));
            } else {
                boolean bl;
                boolean bl2 = bl = this.argumentStack % 2 != 0 || this.seenParameter;
                if (bl) {
                    this.declaration.append(this.separator).append(string.replace('/', '.'));
                }
            }
            this.separator = "";
            this.argumentStack *= 2;
            this.argumentStackPosition.push(this.stack.size());
        }

        @Override
        public void visitInnerClassType(String string) {
            if (this.argumentStack % 2 != 0) {
                this.declaration.append('>');
            }
            this.argumentStack /= 2;
            this.argumentStackPosition.pop();
            this.declaration.append('.');
            this.declaration.append(this.separator).append(string.replace('/', '.'));
            this.separator = "";
            this.argumentStack *= 2;
            this.argumentStackPosition.push(this.stack.size());
        }

        @Override
        public void visitTypeArgument() {
            if (this.argumentStack % 2 == 0) {
                ++this.argumentStack;
                this.declaration.append('<');
            } else {
                this.declaration.append(", ");
            }
            this.declaration.append('?');
        }

        @Override
        public SignatureVisitor visitTypeArgument(char c) {
            if (this.argumentStack % 2 == 0) {
                ++this.argumentStack;
                this.declaration.append('<');
            } else {
                this.declaration.append(", ");
            }
            if (c == '+') {
                this.declaration.append("? extends ");
            } else if (c == '-') {
                this.declaration.append("? super ");
            }
            this.startType();
            return this;
        }

        @Override
        public void visitEnd() {
            if (this.argumentStack % 2 != 0) {
                int n = this.argumentStackPosition.peek() - 1;
                Type type = (Type)this.stack.elementAt(n);
                Type type2 = null;
                int n2 = this.stack.size() - n - 1;
                Type[] typeArray = new Type[n2];
                for (int i = n2 - 1; i >= 0; --i) {
                    typeArray[i] = this.stack.pop();
                }
                this.stack.pop();
                ParameterizedTypeImpl parameterizedTypeImpl = new ParameterizedTypeImpl(type2, typeArray, type);
                this.stack.push(parameterizedTypeImpl);
                this.declaration.append('>');
            }
            this.argumentStack /= 2;
            this.argumentStackPosition.pop();
            this.endType();
        }

        public String getDeclaration() {
            return this.declaration.toString();
        }

        public String getReturnType() {
            return this.returnType == null ? null : this.returnType.toString();
        }

        public String getExceptions() {
            return this.exceptions == null ? null : this.exceptions.toString();
        }

        private void endFormal() {
            Type[] typeArray = this.stack.toArray(new Type[this.stack.size()]);
            this.stack.removeAllElements();
            this.formalTypeParameters.getLast().setBounds(typeArray);
        }

        private void endGenericSuperclass() {
            this.genericSuperclass = this.stack.pop();
        }

        public void endParsing() {
            if (!this.seenInterface) {
                this.endGenericSuperclass();
                this.genericInterfaces = new Type[0];
            } else {
                this.genericInterfaces = this.stack.toArray(new Type[this.stack.size()]);
                this.stack.removeAllElements();
                for (Type type : this.genericInterfaces) {
                    Type type2;
                    if (type instanceof ParameterizedTypeImpl) {
                        type2 = (ParameterizedTypeImpl)type;
                        type = ((ParameterizedTypeImpl)type2).raw;
                    }
                    if (!(type instanceof ClassTypeImpl)) continue;
                    type2 = (ClassTypeImpl)type;
                    ((ClassTypeImpl)type2).isInterface = true;
                }
            }
            this.currentType.setTypeParameters(this.typeParameters);
            for (TypeVariableImpl typeVariableImpl : this.typeVariables) {
                typeVariableImpl.setGenericDeclaration(this.currentType);
            }
        }

        private void endFormals() {
            if (this.seenFormalParameter) {
                this.endFormal();
                this.declaration.append('>');
                this.seenFormalParameter = false;
            }
            this.typeParameters = this.formalTypeParameters.toArray(new TypeVariable[this.formalTypeParameters.size()]);
        }

        private void startType() {
            this.arrayStack *= 2;
        }

        private void endType() {
            if (this.arrayStack % 2 != 0) {
                while (this.arrayStack % 2 != 0) {
                    Type type = this.stack.pop();
                    this.stack.push(new GenericArrayTypeImpl(type));
                    this.arrayStack /= 2;
                    this.declaration.append("[]");
                }
            } else {
                this.arrayStack /= 2;
            }
        }
    }
}

