/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.x3d;

import de.grogra.ext.x3d.X3DExport;
import de.grogra.ext.x3d.exportation.AppearanceExport;
import de.grogra.ext.x3d.exportation.IndexedFaceSetExport;
import de.grogra.ext.x3d.exportation.LightExport;
import de.grogra.ext.x3d.exportation.TransformExport;
import de.grogra.ext.x3d.xmlbeans.ProfileNames;
import de.grogra.ext.x3d.xmlbeans.SceneDocument;
import de.grogra.ext.x3d.xmlbeans.TransformDocument;
import de.grogra.ext.x3d.xmlbeans.X3DDocument;
import de.grogra.ext.x3d.xmlbeans.X3DVersion;
import de.grogra.imp3d.Polygonizable;
import de.grogra.imp3d.View3D;
import de.grogra.imp3d.io.SceneGraphExport;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.SceneTree;
import de.grogra.imp3d.objects.SceneTreeWithShader;
import de.grogra.imp3d.shading.Light;
import de.grogra.pf.io.FileWriterSource;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.ui.Workbench;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Stack;
import javax.vecmath.Matrix4d;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xmlbeans.XmlOptions;

public class VRML97Export
extends X3DExport
implements FileWriterSource {
    private File outFile = null;
    private SceneDocument.Scene scene = null;
    private Stack<TransformDocument.Transform> transformStack = null;
    private Workbench workbench = null;
    private HashSet<String> createdFiles = new HashSet();

    public VRML97Export(FilterItem filterItem, FilterSource filterSource) {
        super(filterItem, filterSource);
        this.setFlavor(filterItem.getOutputFlavor());
        this.transformStack = new Stack();
        this.workbench = Workbench.current();
    }

    protected SceneTree createSceneTree(View3D view3D) {
        SceneTreeWithShader sceneTreeWithShader = new SceneTreeWithShader(view3D){

            protected boolean acceptLeaf(Object object, boolean bl) {
                if (bl) {
                    return VRML97Export.this.getExportFor(object, bl) != null;
                }
                return false;
            }

            protected SceneTreeWithShader.Leaf createLeaf(Object object, boolean bl, long l) {
                SceneTreeWithShader.Leaf leaf = new SceneTreeWithShader.Leaf(object, bl, l);
                this.init((SceneTree.Leaf)leaf);
                return leaf;
            }
        };
        sceneTreeWithShader.createTree(false);
        return sceneTreeWithShader;
    }

    public SceneGraphExport.NodeExport getExportFor(Object object, boolean bl) {
        SceneGraphExport.NodeExport nodeExport;
        Object object2 = this.getGraphState().getObjectDefault(object, bl, Attributes.SHAPE, null);
        if (object2 != null) {
            nodeExport = super.getExportFor(object2, bl);
            if (nodeExport != null) {
                return nodeExport;
            }
            if (object2 instanceof Polygonizable) {
                return new IndexedFaceSetExport();
            }
        }
        return (nodeExport = (Light)this.getGraphState().getObjectDefault(object, bl, Attributes.LIGHT, null)) != null && nodeExport.getLightType() != 4 ? new LightExport() : null;
    }

    protected void beginGroup(SceneTree.InnerNode innerNode) throws IOException {
        Matrix4d matrix4d = new Matrix4d();
        innerNode.get(matrix4d);
        TransformDocument.Transform transform = TransformExport.handleTransform(matrix4d, this.transformStack.peek());
        this.transformStack.push(transform);
    }

    protected void endGroup(SceneTree.InnerNode innerNode) throws IOException {
        this.transformStack.pop();
    }

    public void write(File file) throws IOException {
        this.workbench.beginStatus((Object)this);
        this.workbench.setStatus((Object)this, "Export X3D", -1.0f);
        this.outFile = file;
        X3DDocument x3DDocument = X3DDocument.Factory.newInstance();
        X3DDocument.X3D x3D = x3DDocument.addNewX3D();
        x3D.setProfile(ProfileNames.IMMERSIVE);
        x3D.setVersion(X3DVersion.X_3_0);
        this.scene = x3D.addNewScene();
        TransformDocument.Transform transform = this.scene.addNewTransform();
        this.transformStack.add(transform);
        AppearanceExport.imageFileMap.clear();
        this.write();
        XmlOptions xmlOptions = new XmlOptions();
        xmlOptions.setSavePrettyPrint();
        xmlOptions.setSavePrettyPrintIndent(2);
        String string = file.getParent() + File.separator + "temp.x3d";
        File file2 = new File(string);
        x3DDocument.save(file2, xmlOptions);
        System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.xsltc.trax.TransformerFactoryImpl");
        StreamSource streamSource = new StreamSource(file2);
        File file3 = new File(this.XSLT_PATH_X3D_TO_VRML97);
        StreamSource streamSource2 = new StreamSource(file3);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer(streamSource2);
            transformer.transform(streamSource, new StreamResult(file));
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
        file2.delete();
        this.workbench.clearStatusAndProgress((Object)this);
    }

    public File getOutFile() {
        return this.outFile;
    }

    public TransformDocument.Transform getLastTransform() {
        return this.transformStack.peek();
    }

    public SceneDocument.Scene getScene() {
        return this.scene;
    }

    public String getDirectory() {
        return this.outFile.getParent();
    }

    public Object getFile(String string) throws IOException {
        int n = string.lastIndexOf(46);
        String string2 = n < 0 ? string : string.substring(0, n);
        String string3 = n < 0 ? "" : string.substring(n);
        n = 0;
        string = string2 + n + string3;
        while (!this.createdFiles.add(string)) {
            string = string2 + ++n + string3;
        }
        String string4 = this.getDirectory();
        File file = new File(string4 + File.separator + string);
        return file;
    }

    public void increaseProgress() {
        this.workbench.setIndeterminateProgress((Object)this);
    }
}

