/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.x3d.exportation;

import de.grogra.ext.x3d.X3DExport;
import de.grogra.ext.x3d.exportation.BaseExport;
import de.grogra.ext.x3d.xmlbeans.DirectionalLightDocument;
import de.grogra.ext.x3d.xmlbeans.PointLightDocument;
import de.grogra.ext.x3d.xmlbeans.SceneDocument;
import de.grogra.ext.x3d.xmlbeans.ShapeDocument;
import de.grogra.ext.x3d.xmlbeans.SpotLightDocument;
import de.grogra.ext.x3d.xmlbeans.TransformDocument;
import de.grogra.graph.GraphState;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.DirectionalLight;
import de.grogra.imp3d.objects.GlobalTransformation;
import de.grogra.imp3d.objects.PointLight;
import de.grogra.imp3d.objects.SceneTree;
import de.grogra.imp3d.objects.SpotLight;
import de.grogra.math.RGBColor;
import java.io.IOException;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;

public class LightExport
extends BaseExport {
    protected void exportImpl(SceneTree.Leaf leaf, X3DExport x3DExport, ShapeDocument.Shape shape, TransformDocument.Transform transform) throws IOException {
        Object object = leaf.getObject(Attributes.LIGHT);
        if (object instanceof SpotLight) {
            this.handleSpotLight((SpotLight)object, transform);
        } else if (object instanceof PointLight) {
            this.handlePointLight((PointLight)object, transform);
        } else if (object instanceof DirectionalLight) {
            SceneDocument.Scene scene = x3DExport.getScene();
            this.handleDirectionalLight((DirectionalLight)object, leaf, scene, x3DExport.getGraphState());
        }
    }

    private void handleSpotLight(SpotLight spotLight, TransformDocument.Transform transform) {
        SpotLightDocument.SpotLight spotLight2 = transform.addNewSpotLight();
        RGBColor rGBColor = spotLight.getColor();
        if (!rGBColor.equals((Tuple3f)new RGBColor(1.0f, 1.0f, 1.0f))) {
            spotLight2.setColor(rGBColor.x + " " + rGBColor.y + " " + rGBColor.z);
        }
        Vector3d vector3d = new Vector3d(0.0, 0.0, 1.0);
        spotLight2.setDirection(vector3d.x + " " + vector3d.z + " " + -vector3d.y);
        float f = spotLight.getPower() / 100.0f;
        if (f != 1.0f) {
            spotLight2.setIntensity(f / 100.0f);
        }
    }

    private void handlePointLight(PointLight pointLight, TransformDocument.Transform transform) {
        float f;
        PointLightDocument.PointLight pointLight2 = transform.addNewPointLight();
        RGBColor rGBColor = pointLight.getColor();
        if (!rGBColor.equals((Tuple3f)new RGBColor(1.0f, 1.0f, 1.0f))) {
            pointLight2.setColor(rGBColor.x + " " + rGBColor.y + " " + rGBColor.z);
        }
        if ((f = pointLight.getPower() / 100.0f) != 1.0f) {
            pointLight2.setIntensity(f);
        }
    }

    private void handleDirectionalLight(DirectionalLight directionalLight, SceneTree.Leaf leaf, SceneDocument.Scene scene, GraphState graphState) {
        DirectionalLightDocument.DirectionalLight directionalLight2 = scene.addNewDirectionalLight();
        RGBColor rGBColor = directionalLight.getColor();
        if (!rGBColor.equals((Tuple3f)new RGBColor(1.0f, 1.0f, 1.0f))) {
            directionalLight2.setColor(rGBColor.x + " " + rGBColor.y + " " + rGBColor.z);
        }
        Matrix4d matrix4d = GlobalTransformation.get((Object)leaf.object, (boolean)true, (GraphState)graphState, (boolean)true).toMatrix4d();
        Vector3d vector3d = new Vector3d(0.0, 0.0, 1.0);
        matrix4d.transform(vector3d);
        directionalLight2.setDirection(vector3d.x + " " + vector3d.z + " " + -vector3d.y);
        float f = directionalLight.getPowerDensity() / 10.0f;
        if (f != 1.0f) {
            directionalLight2.setIntensity(f);
        }
    }
}

