/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.x3d.exportation;

import de.grogra.ext.x3d.X3DExport;
import de.grogra.ext.x3d.exportation.BaseExport;
import de.grogra.ext.x3d.xmlbeans.AppearanceDocument;
import de.grogra.ext.x3d.xmlbeans.CoordinateDocument;
import de.grogra.ext.x3d.xmlbeans.LineSetDocument;
import de.grogra.ext.x3d.xmlbeans.MaterialDocument;
import de.grogra.ext.x3d.xmlbeans.ShapeDocument;
import de.grogra.ext.x3d.xmlbeans.TransformDocument;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.SceneTree;
import java.io.IOException;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3f;

public class LineExport
extends BaseExport {
    protected void exportImpl(SceneTree.Leaf leaf, X3DExport x3DExport, ShapeDocument.Shape shape, TransformDocument.Transform transform) throws IOException {
        LineSetDocument.LineSet lineSet = shape.addNewLineSet();
        lineSet.setVertexCount("2");
        Vector3f vector3f = (Vector3f)leaf.getObject(Attributes.AXIS);
        CoordinateDocument.Coordinate coordinate = lineSet.addNewCoordinate();
        coordinate.setPoint("0 0 0 " + vector3f.x + " " + vector3f.z + " " + -vector3f.y);
        Color3f color3f = (Color3f)leaf.getObject(de.grogra.imp.objects.Attributes.COLOR);
        AppearanceDocument.Appearance appearance = shape.getAppearance();
        MaterialDocument.Material material = appearance.getMaterialArray(0);
        if (material.isSetDiffuseColor()) {
            material.unsetDiffuseColor();
        }
        if (material.isSetAmbientIntensity()) {
            material.unsetAmbientIntensity();
        }
        if (material.isSetShininess()) {
            material.unsetShininess();
        }
        if (material.isSetSpecularColor()) {
            material.unsetSpecularColor();
        }
        material.setEmissiveColor(color3f.x + " " + color3f.y + " " + color3f.z);
    }
}

