/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.x3d.importation;

import de.grogra.ext.x3d.ProtoInstanceImport;
import de.grogra.ext.x3d.X3DImport;
import de.grogra.ext.x3d.util.Util;
import de.grogra.ext.x3d.xmlbeans.BoxDocument;
import de.grogra.ext.x3d.xmlbeans.X3DNode;
import de.grogra.graph.impl.Node;
import de.grogra.imp.objects.ImageAdapter;
import de.grogra.imp3d.objects.Box;
import de.grogra.imp3d.objects.ShadedNull;
import de.grogra.imp3d.shading.AffineUVTransformation;
import de.grogra.imp3d.shading.ImageMap;
import de.grogra.imp3d.shading.Phong;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoxImport {
    public static ShadedNull createInstance(BoxDocument.Box box, Object object) {
        Box box2 = null;
        HashMap<String, Object> hashMap = X3DImport.getTheImport().getCurrentParser().getReferenceMap();
        if (box.isSetUSE()) {
            try {
                box2 = (Box)((Node)hashMap.get(box.getUSE())).clone(true);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        } else {
            box2 = new Box();
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            if (box.isSetIS()) {
                ProtoInstanceImport.calcFinalValueMap(hashMap2, (X3DNode)box);
            }
            BoxImport.setValues(box2, box, hashMap2, object);
            if (box.isSetDEF()) {
                hashMap.put(box.getDEF(), box2);
            }
        }
        box2.setName("X3DBox");
        return box2;
    }

    private static void setValues(Box box, BoxDocument.Box box2, HashMap<String, String> hashMap, Object object) {
        Phong phong;
        float[] fArray = null;
        String string = hashMap.get("size") != null ? hashMap.get("size") : box2.getSize();
        fArray = Util.splitStringToArrayOfFloat(string, new float[]{2.0f, 2.0f, 2.0f});
        box.setLength(fArray[1]);
        box.setWidth(fArray[0]);
        box.setHeight(fArray[2]);
        box.setShiftPivot(false);
        box.setStartPosition(-0.5f);
        box.setEndPosition(0.0f);
        if (object instanceof ShadedNull && ((ShadedNull)object).getShader() instanceof Phong && (phong = (Phong)((ShadedNull)object).getShader()).getDiffuse() instanceof ImageMap) {
            ImageMap imageMap = (ImageMap)phong.getDiffuse();
            BufferedImage bufferedImage = imageMap.getImageAdapter().getBufferedImage();
            float f = 1.0f;
            float f2 = 1.0f;
            if (imageMap.getInput() instanceof AffineUVTransformation) {
                AffineUVTransformation affineUVTransformation = (AffineUVTransformation)imageMap.getInput();
                f = affineUVTransformation.getScaleU();
                f2 = affineUVTransformation.getScaleV();
                affineUVTransformation.setScaleU(1.0f);
                affineUVTransformation.setScaleV(1.0f);
            }
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            int n3 = n * 4;
            int n4 = n2 * 3;
            BufferedImage bufferedImage2 = new BufferedImage(n3, n4, 2);
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n4; ++j) {
                    double d;
                    double d2;
                    double d3 = (double)i / (double)(n3 - 1);
                    double d4 = (double)j / (double)(n4 - 1);
                    if (d3 >= 0.25 && d3 <= 0.5 && d4 >= 0.3333333333333333 && d4 <= 0.6666666666666666) {
                        d2 = (d3 - 0.25) / 0.25;
                        d = (d4 - 0.3333333333333333) / 0.3333333333333333;
                        d2 *= (double)f;
                        d2 -= Math.floor(d2);
                        d *= (double)f2;
                        d -= Math.floor(d);
                        bufferedImage2.setRGB(i, j, bufferedImage.getRGB(Util.round(d2 *= (double)(n - 1)), Util.round(d *= (double)(n2 - 1))));
                        continue;
                    }
                    if (d3 >= 0.75 && d3 <= 1.0 && d4 >= 0.3333333333333333 && d4 <= 0.6666666666666666) {
                        d2 = (d3 - 0.75) / 0.25;
                        d = (d4 - 0.3333333333333333) / 0.3333333333333333;
                        d2 *= (double)f;
                        d2 -= Math.floor(d2);
                        d *= (double)f2;
                        d -= Math.floor(d);
                        d2 *= (double)(n - 1);
                        d2 = (double)(n - 1) - d2;
                        d *= (double)(n2 - 1);
                        d = (double)(n2 - 1) - d;
                        bufferedImage2.setRGB(i, j, bufferedImage.getRGB(Util.round(d2), Util.round(d)));
                        continue;
                    }
                    if (d3 >= 0.25 && d3 <= 0.5 && d4 >= 0.6666666666666666 && d4 <= 1.0) {
                        d2 = (d3 - 0.25) / 0.25;
                        d = (d4 - 0.6666666666666666) / 0.3333333333333333;
                        d2 *= (double)f;
                        d2 -= Math.floor(d2);
                        d *= (double)f2;
                        d -= Math.floor(d);
                        bufferedImage2.setRGB(i, j, bufferedImage.getRGB(Util.round(d2 *= (double)(n - 1)), Util.round(d *= (double)(n2 - 1))));
                        continue;
                    }
                    if (d3 >= 0.25 && d3 <= 0.5 && d4 >= 0.0 && d4 <= 0.3333333333333333) {
                        d2 = (d3 - 0.25) / 0.25;
                        d = d4 / 0.3333333333333333;
                        d2 *= (double)f;
                        d2 -= Math.floor(d2);
                        d *= (double)f2;
                        d -= Math.floor(d);
                        d2 *= (double)(n - 1);
                        d2 = (double)(n - 1) - d2;
                        d *= (double)(n2 - 1);
                        d = (double)(n2 - 1) - d;
                        bufferedImage2.setRGB(i, j, bufferedImage.getRGB(Util.round(d2), Util.round(d)));
                        continue;
                    }
                    if (d3 >= 0.5 && d3 <= 0.75 && d4 >= 0.3333333333333333 && d4 <= 0.6666666666666666) {
                        d = (d3 - 0.5) / 0.25;
                        d2 = (d4 - 0.3333333333333333) / 0.3333333333333333;
                        d2 *= (double)f;
                        d2 -= Math.floor(d2);
                        d *= (double)f2;
                        d -= Math.floor(d);
                        d2 *= (double)(n - 1);
                        d2 = (double)(n - 1) - d2;
                        bufferedImage2.setRGB(i, j, bufferedImage.getRGB(Util.round(d2), Util.round(d *= (double)(n2 - 1))));
                        continue;
                    }
                    if (!(d3 >= 0.0) || !(d3 <= 0.25) || !(d4 >= 0.3333333333333333) || !(d4 <= 0.6666666666666666)) continue;
                    d = d3 / 0.25;
                    d2 = (d4 - 0.3333333333333333) / 0.3333333333333333;
                    d2 *= (double)f;
                    d2 -= Math.floor(d2);
                    d *= (double)f2;
                    d -= Math.floor(d);
                    d *= (double)(n2 - 1);
                    d = (double)(n2 - 1) - d;
                    bufferedImage2.setRGB(i, j, bufferedImage.getRGB(Util.round(d2 *= (double)(n - 1)), Util.round(d)));
                }
            }
            File file = null;
            try {
                file = File.createTempFile("x3dsurface", ".png");
                ImageIO.write((RenderedImage)bufferedImage2, "png", file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
            ImageAdapter imageAdapter = Util.getImageForURL(file.getPath(), true);
            imageMap.setImageAdapter(imageAdapter);
        }
    }
}

