/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.texgen;

import de.grogra.imp.objects.ImageAdapter;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.texgen.SyntheticTexture;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Random;

public class DiamondSquareTexture
extends SyntheticTexture {
    int width = 256;
    int height = 256;
    float a0 = 1.0f;
    float a1 = 0.75f;
    float a2 = 0.5f;
    float a3 = 0.25f;
    long randomSeed = 1827564L;
    boolean useColor = true;
    private BufferedImage img;
    private transient int imageStamp = -1;
    private Random rnd;
    public static final Type $TYPE = new Type(DiamondSquareTexture.class);
    public static final SCOType.Field width$FIELD = Type._addManagedField($TYPE, "width", 0x200000, de.grogra.reflect.Type.INT, null, 0);
    public static final SCOType.Field height$FIELD = Type._addManagedField($TYPE, "height", 0x200000, de.grogra.reflect.Type.INT, null, 1);
    public static final SCOType.Field a0$FIELD = Type._addManagedField($TYPE, "a0", 0x200000, de.grogra.reflect.Type.FLOAT, null, 2);
    public static final SCOType.Field a1$FIELD = Type._addManagedField($TYPE, "a1", 0x200000, de.grogra.reflect.Type.FLOAT, null, 3);
    public static final SCOType.Field a2$FIELD = Type._addManagedField($TYPE, "a2", 0x200000, de.grogra.reflect.Type.FLOAT, null, 4);
    public static final SCOType.Field a3$FIELD = Type._addManagedField($TYPE, "a3", 0x200000, de.grogra.reflect.Type.FLOAT, null, 5);
    public static final SCOType.Field randomSeed$FIELD = Type._addManagedField($TYPE, "randomSeed", 0x200000, de.grogra.reflect.Type.LONG, null, 6);
    public static final SCOType.Field useColor$FIELD = Type._addManagedField($TYPE, "useColor", 0x200000, de.grogra.reflect.Type.BOOLEAN, null, 7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getBufferedImage() {
        int n = this.getStamp();
        DiamondSquareTexture diamondSquareTexture = this;
        synchronized (diamondSquareTexture) {
            if (n != this.imageStamp) {
                this.createImage();
                this.imageStamp = n;
            }
        }
        return this.img;
    }

    private Color computeColor(float f) {
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        f2 = f < 0.5f ? f * 2.0f : (1.0f - f) * 2.0f;
        f3 = f >= 0.3f && f < 0.8f ? (f - 0.3f) * 2.0f : (f < 0.3f ? (0.3f - f) * 2.0f : (1.3f - f) * 2.0f);
        f4 = f >= 0.5f ? (f - 0.5f) * 2.0f : (0.5f - f) * 2.0f;
        if (f2 < 0.0f) {
            f2 = Math.abs(f2);
        }
        if (f3 < 0.0f) {
            f3 = Math.abs(f3);
        }
        if (f4 < 0.0f) {
            f4 = Math.abs(f4);
        }
        if (f2 > 1.0f) {
            f2 -= (float)((int)f2);
        }
        if (f3 > 1.0f) {
            f3 -= (float)((int)f3);
        }
        if (f4 > 1.0f) {
            f4 -= (float)((int)f4);
        }
        if (this.useColor) {
            return new Color(f2, f3, f4);
        }
        f = 0.3f * f2 + 0.59f * f3 + 0.11f * f4;
        return new Color(f, f, f);
    }

    public Dimension getPreferredIconSize(boolean bl) {
        return bl ? new Dimension(this.width * 32 / this.height, 32) : new Dimension(this.width, this.height);
    }

    protected void createImage() {
        this.img = new BufferedImage(this.width, this.height, 1);
        this.rnd = new Random(this.randomSeed);
        this.divideGrid(this.img.getGraphics(), 0.0f, 0.0f, this.width, this.height, this.a0, this.a1, this.a2, this.a3);
    }

    protected void divideGrid(Graphics graphics, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9 = f3 / 2.0f;
        float f10 = f4 / 2.0f;
        if (f3 > 2.0f || f4 > 2.0f) {
            float f11 = (f5 + f6 + f7 + f8) / 4.0f + this.displace(f3, f4, f9 + f10);
            float f12 = (f5 + f6) / 2.0f;
            float f13 = (f6 + f7) / 2.0f;
            float f14 = (f7 + f8) / 2.0f;
            float f15 = (f8 + f6) / 2.0f;
            if (f11 < 0.0f) {
                f11 = 0.0f;
            } else if (f11 > 1.0f) {
                f11 = 1.0f;
            }
            this.divideGrid(graphics, f, f2, f9, f10, f5, f12, f11, f15);
            this.divideGrid(graphics, f + f9, f2, f9, f10, f12, f6, f13, f11);
            this.divideGrid(graphics, f + f9, f2 + f10, f9, f10, f11, f13, f7, f14);
            this.divideGrid(graphics, f, f2 + f10, f9, f10, f15, f11, f14, f8);
        } else {
            graphics.setColor(this.computeColor((f5 + f6 + f7 + f8) / 4.0f));
            graphics.drawRect((int)f, (int)f2, 1, 1);
        }
    }

    protected float displace(float f, float f2, float f3) {
        float f4 = f3 / (f + f2) * 3.0f;
        return (this.rnd.nextFloat() - 0.5f) * f4;
    }

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public boolean isUseColor() {
        return this.useColor;
    }

    public void setUseColor(boolean bl) {
        this.useColor = bl;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public long getRandomSeed() {
        return this.randomSeed;
    }

    public void setRandomSeed(long l) {
        this.randomSeed = l;
    }

    public float getA0() {
        return this.a0;
    }

    public void setA0(float f) {
        this.a0 = f;
    }

    public float getA1() {
        return this.a1;
    }

    public void setA1(float f) {
        this.a1 = f;
    }

    public float getA2() {
        return this.a2;
    }

    public void setA2(float f) {
        this.a2 = f;
    }

    public float getA3() {
        return this.a3;
    }

    public void setA3(float f) {
        this.a3 = f;
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends ImageAdapter.Type {
        private static final int SUPER_FIELD_COUNT = 0;
        protected static final int FIELD_COUNT = 8;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(DiamondSquareTexture diamondSquareTexture, SCOType sCOType) {
            super((ImageAdapter)diamondSquareTexture, sCOType);
        }

        Type(Class clazz) {
            super(clazz, (SCOType)SyntheticTexture.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setBoolean(Object object, int n, boolean bl) {
            switch (n) {
                case 7: {
                    ((DiamondSquareTexture)((Object)object)).useColor = bl;
                    return;
                }
            }
            super.setBoolean(object, n, bl);
        }

        protected boolean getBoolean(Object object, int n) {
            switch (n) {
                case 7: {
                    return ((DiamondSquareTexture)((Object)object)).isUseColor();
                }
            }
            return super.getBoolean(object, n);
        }

        protected void setInt(Object object, int n, int n2) {
            switch (n) {
                case 0: {
                    ((DiamondSquareTexture)((Object)object)).width = n2;
                    return;
                }
                case 1: {
                    ((DiamondSquareTexture)((Object)object)).height = n2;
                    return;
                }
            }
            super.setInt(object, n, n2);
        }

        protected int getInt(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((DiamondSquareTexture)((Object)object)).getWidth();
                }
                case 1: {
                    return ((DiamondSquareTexture)((Object)object)).getHeight();
                }
            }
            return super.getInt(object, n);
        }

        protected void setLong(Object object, int n, long l) {
            switch (n) {
                case 6: {
                    ((DiamondSquareTexture)((Object)object)).randomSeed = l;
                    return;
                }
            }
            super.setLong(object, n, l);
        }

        protected long getLong(Object object, int n) {
            switch (n) {
                case 6: {
                    return ((DiamondSquareTexture)((Object)object)).getRandomSeed();
                }
            }
            return super.getLong(object, n);
        }

        protected void setFloat(Object object, int n, float f) {
            switch (n) {
                case 2: {
                    ((DiamondSquareTexture)((Object)object)).a0 = f;
                    return;
                }
                case 3: {
                    ((DiamondSquareTexture)((Object)object)).a1 = f;
                    return;
                }
                case 4: {
                    ((DiamondSquareTexture)((Object)object)).a2 = f;
                    return;
                }
                case 5: {
                    ((DiamondSquareTexture)((Object)object)).a3 = f;
                    return;
                }
            }
            super.setFloat(object, n, f);
        }

        protected float getFloat(Object object, int n) {
            switch (n) {
                case 2: {
                    return ((DiamondSquareTexture)((Object)object)).getA0();
                }
                case 3: {
                    return ((DiamondSquareTexture)((Object)object)).getA1();
                }
                case 4: {
                    return ((DiamondSquareTexture)((Object)object)).getA2();
                }
                case 5: {
                    return ((DiamondSquareTexture)((Object)object)).getA3();
                }
            }
            return super.getFloat(object, n);
        }

        public Object newInstance() {
            return new DiamondSquareTexture();
        }
    }
}

