/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.grophysics;

import com.bulletphysics.linearmath.Transform;
import de.grogra.graph.impl.Node;
import de.grogra.rgg.Library;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class PhysicsUtils {
    public Matrix4d offsetMatrix(Matrix4d matrix4d, Point3d point3d) {
        return this.offsetMatrix(matrix4d, new Vector3d((Tuple3d)point3d));
    }

    public Matrix4d offsetMatrix(Matrix4d matrix4d, Vector3d vector3d) {
        Matrix4d matrix4d2 = new Matrix4d();
        matrix4d2.set(matrix4d);
        Matrix4d matrix4d3 = this.getTranslation(vector3d);
        matrix4d2.mul(matrix4d3);
        return matrix4d2;
    }

    public Matrix4d getMatrix4d(Transform transform) {
        Matrix4f matrix4f = new Matrix4f();
        transform.getMatrix(matrix4f);
        Matrix4d matrix4d = new Matrix4d(matrix4f);
        return matrix4d;
    }

    public Matrix4d getTranslation(Vector3d vector3d) {
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.setIdentity();
        matrix4d.setTranslation(vector3d);
        return matrix4d;
    }

    public Matrix4d getDifference(Matrix4d matrix4d, Matrix4d matrix4d2) {
        Matrix4d matrix4d3 = new Matrix4d();
        matrix4d3.invert(matrix4d2);
        matrix4d3.mul(matrix4d);
        return matrix4d3;
    }

    public void showNodeInfo(Node node) {
        Library.println((Object)("Node " + node.getId() + " " + node.getName() + " has " + node.getDirectChildCount() + " children"));
    }
}

