/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.grophysics;

import de.grogra.graph.GraphState;
import de.grogra.graph.Path;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.Visitor3D;
import de.grogra.rgg.Library;
import javax.vecmath.Matrix4d;
import uk.ac.soton.grophysics.MassObject;
import uk.ac.soton.grophysics.PhysicsModel;

public class PhysicsVisitor
extends Visitor3D {
    private boolean debug = false;
    private PhysicsModel physicsModel;

    public void init(GraphState graphState, Matrix4d matrix4d, PhysicsModel physicsModel) {
        this.physicsModel = physicsModel;
        this.init(graphState, graphState.getGraph().getTreePattern(), matrix4d);
    }

    protected void visitEnterImpl(Object object, boolean bl, Path path) {
        MassObject massObject;
        if (bl && object instanceof Node && (massObject = this.physicsModel.getMassObject(object)) != null) {
            if (massObject.isInitialised()) {
                if (this.debug) {
                    Library.println((Object)("\nPhysicsVisitor: Move MassObject " + massObject.getName()));
                }
                this.physicsModel.updatePosition(massObject);
            } else {
                if (this.debug) {
                    Library.println((Object)("\nPhysicsVisitor: New MassObject " + massObject.getName()));
                }
                this.physicsModel.addDeferred(massObject);
            }
        }
    }

    protected void visitLeaveImpl(Object object, boolean bl, Path path) {
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }
}

