/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.grammar;

import de.grogra.grammar.NumberLiteral;

public final class IntLiteral
extends NumberLiteral {
    private int value;
    private int radix;

    public IntLiteral(String string, int n) {
        super(5, string);
        this.radix = -n;
    }

    public IntLiteral(int n) {
        super(5, null);
        this.value = n;
        this.radix = 10;
    }

    public boolean isDecimal() {
        return this.radix == 10 || this.radix == -10;
    }

    public static int parse(CharSequence charSequence, int n, int n2, int n3, boolean bl) throws NumberFormatException {
        int n4;
        boolean bl2;
        if (charSequence == null || n < 0 || n2 > charSequence.length() || n2 <= n) {
            throw new NumberFormatException("Empty string");
        }
        if (n3 < 2) {
            throw new NumberFormatException("radix " + n3 + " less than Character.MIN_RADIX");
        }
        if (n3 > 36) {
            throw new NumberFormatException("radix " + n3 + " greater than Character.MAX_RADIX");
        }
        int n5 = n;
        if (charSequence.charAt(n5) == '-') {
            bl2 = true;
            if (++n5 == n2) {
                throw new NumberFormatException(((Object)charSequence.subSequence(n, n2)).toString());
            }
            n4 = Integer.MIN_VALUE;
        } else {
            bl2 = false;
            n4 = -2147483647;
        }
        int n6 = n4 / n3;
        int n7 = 0;
        while (n5 < n2) {
            int n8;
            if ((n8 = Character.digit(charSequence.charAt(n5++), n3)) < 0) {
                throw new NumberFormatException(((Object)charSequence.subSequence(n, n2)).toString());
            }
            boolean bl3 = n7 < n6;
            if (bl3 || (n7 *= n3) < n4 + n8) {
                if (bl) {
                    bl = false;
                } else {
                    throw new NumberFormatException(((Object)charSequence.subSequence(n, n2)).toString());
                }
            }
            n7 -= n8;
        }
        return bl2 ? n7 : -n7;
    }

    public int intValue() {
        if (this.radix < 0) {
            String string = super.getText();
            this.radix = -this.radix;
            this.value = IntLiteral.parse(string, 0, string.length(), this.radix, this.radix == 8 || this.radix == 16);
            return this.value;
        }
        return this.value;
    }

    public long longValue() {
        return this.intValue();
    }

    public float floatValue() {
        return this.intValue();
    }

    public double doubleValue() {
        return this.intValue();
    }

    public String getText() {
        String string = super.getText();
        if (string == null) {
            string = String.valueOf(this.value);
            this.setText(string);
            this.radix = 10;
        }
        return string;
    }
}

