/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.grammar;

import de.grogra.grammar.NumberLiteral;

public final class LongLiteral
extends NumberLiteral {
    private long value;
    private int radix;

    public LongLiteral(String string, int n) {
        super(6, string);
        this.radix = -n;
    }

    public LongLiteral(long l) {
        super(6, null);
        this.value = l;
        this.radix = 10;
    }

    public boolean isDecimal() {
        return this.radix == 10 || this.radix == -10;
    }

    public static long parse(CharSequence charSequence, int n, int n2, int n3, boolean bl) throws NumberFormatException {
        long l;
        boolean bl2;
        if (charSequence == null || n < 0 || n2 > charSequence.length() || n2 <= n) {
            throw new NumberFormatException("Empty string");
        }
        if (n3 < 2) {
            throw new NumberFormatException("radix " + n3 + " less than Character.MIN_RADIX");
        }
        if (n3 > 36) {
            throw new NumberFormatException("radix " + n3 + " greater than Character.MAX_RADIX");
        }
        int n4 = n;
        if (charSequence.charAt(n4) == '-') {
            bl2 = true;
            if (++n4 == n2) {
                throw new NumberFormatException(((Object)charSequence.subSequence(n, n2)).toString());
            }
            l = Long.MIN_VALUE;
        } else {
            bl2 = false;
            l = -9223372036854775807L;
        }
        long l2 = l / (long)n3;
        long l3 = 0L;
        while (n4 < n2) {
            int n5;
            if ((n5 = Character.digit(charSequence.charAt(n4++), n3)) < 0) {
                throw new NumberFormatException(((Object)charSequence.subSequence(n, n2)).toString());
            }
            boolean bl3 = l3 < l2;
            if (bl3 || (l3 *= (long)n3) < l + (long)n5) {
                if (bl) {
                    bl = false;
                } else {
                    throw new NumberFormatException(((Object)charSequence.subSequence(n, n2)).toString());
                }
            }
            l3 -= (long)n5;
        }
        return bl2 ? l3 : -l3;
    }

    public long longValue() {
        if (this.radix < 0) {
            String string = super.getText();
            this.radix = -this.radix;
            this.value = LongLiteral.parse(string, 0, string.length(), this.radix, this.radix == 8 || this.radix == 16);
            return this.value;
        }
        return this.value;
    }

    public int intValue() {
        return (int)this.longValue();
    }

    public float floatValue() {
        return this.longValue();
    }

    public double doubleValue() {
        return this.longValue();
    }

    public String getText() {
        String string = super.getText();
        if (string == null) {
            string = String.valueOf(this.value);
            this.setText(string);
            this.radix = 10;
        }
        return string;
    }
}

