/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.grammar;

import antlr.ANTLRException;
import antlr.MismatchedTokenException;
import antlr.NoViableAltException;
import antlr.TokenStreamIOException;
import antlr.TokenStreamRecognitionException;
import antlr.collections.AST;
import de.grogra.grammar.ASTWithToken;
import de.grogra.grammar.Input;
import de.grogra.grammar.SemanticException;
import de.grogra.grammar.SyntacticException;
import de.grogra.grammar.Token;
import de.grogra.grammar.Tokenizer;
import de.grogra.util.DetailedException;
import de.grogra.util.UserException;
import de.grogra.util.Utils;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecognitionException
extends antlr.RecognitionException
implements UserException,
DetailedException,
Comparable<RecognitionException> {
    public static final long IS_ERROR = 1L;
    public static final long MIN_UNUSED = 2L;
    public long warningBits = 1L;
    boolean isError = true;
    int stamp = 0;
    private int start = -1;
    private int end = -1;
    private Input input;
    private static final String INDENT = "        ";

    public RecognitionException(String string) {
        super(string, null, -1, -1);
    }

    public boolean isError() {
        return this.isError;
    }

    public String getCategoryDescription() {
        return Tokenizer.I18N.msg(this.isError() ? "grammar.error" : "grammar.warning");
    }

    public final void complete(Input input, int n, int n2) {
        if (this.input == null) {
            this.input = input;
            this.fileName = input.getSourceName();
        }
        if (this.start < 0) {
            this.start = n;
        }
        if (this.end < 0) {
            this.end = n2;
        }
    }

    public final RecognitionException set(Input input, int n, int n2) {
        this.input = input;
        this.fileName = input.getSourceName();
        this.start = n;
        this.end = n2;
        return this;
    }

    public final RecognitionException set(antlr.RecognitionException recognitionException) {
        this.fileName = recognitionException.fileName;
        this.line = recognitionException.line;
        this.column = recognitionException.column;
        if (recognitionException instanceof RecognitionException) {
            this.input = ((RecognitionException)recognitionException).input;
            this.start = ((RecognitionException)recognitionException).start;
            this.end = ((RecognitionException)recognitionException).end;
        }
        return this;
    }

    public final RecognitionException set(Tokenizer tokenizer) {
        tokenizer.set(this);
        return this;
    }

    public final RecognitionException set(antlr.Token token) {
        if (token != null) {
            this.fileName = token.getFilename();
            if (token instanceof Token) {
                Token token2 = (Token)token;
                this.set(token2.getTokenizer().getInput(), token2.getStartPosition(), token2.getEndPosition());
            } else {
                this.line = token.getLine();
                this.column = token.getColumn();
            }
        }
        return this;
    }

    private void set1(AST aST) {
        antlr.Token token;
        if (aST instanceof ASTWithToken && (token = ((ASTWithToken)aST).token) instanceof Token) {
            Token token2 = (Token)token;
            this.input = token2.getTokenizer().getInput();
            this.fileName = this.input.getSourceName();
            if (this.start < 0 || this.start > token2.getStartPosition()) {
                this.start = token2.getStartPosition();
            }
            if (this.end < token2.getEndPosition()) {
                this.end = token2.getEndPosition();
            }
        }
    }

    private void setTree(AST aST) {
        this.set1(aST);
        for (aST = aST.getFirstChild(); aST != null; aST = aST.getNextSibling()) {
            this.setTree(aST);
        }
    }

    public final RecognitionException set(AST aST) {
        if (aST != null) {
            this.setTree(aST);
        }
        return this;
    }

    public int getLine() {
        return this.line >= 0 || this.input == null || this.start < 0 ? this.line : (this.line = this.input.getLineAt(this.start));
    }

    public int getColumn() {
        return this.column >= 0 || this.input == null || this.start < 0 ? this.column : (this.column = this.input.getColumnAt(this.start, 1));
    }

    private static void append(StringBuffer stringBuffer, String string, int n, int n2) {
        int n3;
        String string2 = Integer.toString(n);
        for (n3 = string2.length(); n3 < 6; ++n3) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(string2).append(". ");
        n3 = 0;
        int n4 = string.length();
        for (int i = 0; i < n4; ++i) {
            if (string.charAt(i) == '\t') {
                int n5 = (n3 / n2 + 1) * n2;
                while (n5 > n3) {
                    ++n3;
                    stringBuffer.append(' ');
                }
                continue;
            }
            ++n3;
            stringBuffer.append(string.charAt(i));
        }
        stringBuffer.append('\n');
    }

    public String getDetailedMessage(boolean bl) {
        return this.getDetailedMessage(1, 1, 8, bl);
    }

    public String getDetailedMessage(int n, int n2, int n3, boolean bl) {
        int n4;
        int n5;
        String string = this.fileName == null ? "input" : this.fileName;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.input == null || this.start < 0 || this.end < 0) {
            if (bl) {
                stringBuffer.append("<a href=\"").append(string).append("\">").append(string).append("</a>:<br>");
            } else {
                stringBuffer.append(string).append(":\n");
            }
            n5 = stringBuffer.length();
        } else {
            int n6;
            boolean bl2;
            n4 = this.input.getLineAt(this.start);
            int n7 = this.input.getColumnAt(this.start, n3);
            int n8 = this.input.getLineAt(this.end);
            int n9 = this.input.getColumnAt(this.end, n3);
            if (bl) {
                stringBuffer.append("<a href=\"").append(string).append('#').append(n4).append(':').append(this.input.getColumnAt(this.start, 1)).append('-').append(n8).append(':').append(this.input.getColumnAt(this.end, 1)).append("\">");
            }
            stringBuffer.append(string).append(' ').append(n4 + n).append(':').append(n7 + n2).append(" - ").append(n8 + n).append(':').append(n9 + n2).append(bl ? "</a> :<br><pre>\n" : " :\n");
            n5 = stringBuffer.length();
            boolean bl3 = bl2 = n4 == n8;
            if (bl2) {
                RecognitionException.append(stringBuffer, this.input.getTextForLine(n4), n + n4, n3);
            }
            stringBuffer.append(INDENT);
            for (n6 = n7; n6 > 0; --n6) {
                stringBuffer.append(' ');
            }
            if (bl2) {
                stringBuffer.append('^');
                n6 = n9 - n7 - 1;
                if (n6 > 0) {
                    while (--n6 > 0) {
                        stringBuffer.append('-');
                    }
                    stringBuffer.append('^');
                }
                stringBuffer.append('\n');
            } else {
                stringBuffer.append('<');
                for (n6 = this.input.getLineLength(n4, n3) - n7; n6 > 1; --n6) {
                    stringBuffer.append('-');
                }
                stringBuffer.append('\n');
                RecognitionException.append(stringBuffer, this.input.getTextForLine(n4), n + n4, n3);
                if (n4 < n8 - 1) {
                    stringBuffer.append("   . . .\n");
                }
                RecognitionException.append(stringBuffer, this.input.getTextForLine(n8), n + n8, n3);
                stringBuffer.append(INDENT);
                for (n6 = n9; n6 > 1; --n6) {
                    stringBuffer.append('-');
                }
                stringBuffer.append(">\n");
            }
            if (bl) {
                stringBuffer.append('\uffff');
            }
        }
        stringBuffer.append("*** ").append(this.getCategoryDescription()).append(": ").append(this.getMessage()).append('\n');
        if (bl) {
            Utils.escapeForXML((StringBuffer)stringBuffer, (int)n5);
            for (n4 = stringBuffer.length() - 1; n4 >= n5; --n4) {
                if (stringBuffer.charAt(n4) != '\uffff') continue;
                stringBuffer.replace(n4, n4 + 1, "</pre>\n");
            }
            stringBuffer.append("<br>\n");
        }
        return stringBuffer.toString();
    }

    public void dispose() {
        this.input = null;
    }

    public static RecognitionException convert(ANTLRException aNTLRException, String[] stringArray) throws IOException {
        if (aNTLRException instanceof TokenStreamRecognitionException) {
            aNTLRException = ((TokenStreamRecognitionException)aNTLRException).recog;
        }
        if (aNTLRException instanceof RecognitionException) {
            return (RecognitionException)aNTLRException;
        }
        if (aNTLRException instanceof MismatchedTokenException) {
            MismatchedTokenException mismatchedTokenException = (MismatchedTokenException)aNTLRException;
            SyntacticException syntacticException = new SyntacticException(mismatchedTokenException.mismatchType == 1 ? Tokenizer.I18N.msg("grammar.unexpected-token1", (Object)stringArray[mismatchedTokenException.expecting]) : Tokenizer.I18N.msg("grammar.unexpected-token0"));
            if (mismatchedTokenException.token != null) {
                syntacticException.set(mismatchedTokenException.token);
            } else {
                super.set1(mismatchedTokenException.node);
            }
            return syntacticException;
        }
        if (aNTLRException instanceof NoViableAltException) {
            NoViableAltException noViableAltException = (NoViableAltException)aNTLRException;
            SyntacticException syntacticException = new SyntacticException(Tokenizer.I18N.msg("grammar.unexpected-token0"));
            if (noViableAltException.token != null) {
                syntacticException.set(noViableAltException.token);
            } else {
                super.set1(noViableAltException.node);
            }
            return syntacticException;
        }
        if (aNTLRException instanceof antlr.SemanticException) {
            return new SemanticException(aNTLRException.getMessage()).set((antlr.RecognitionException)((antlr.SemanticException)aNTLRException));
        }
        if (aNTLRException instanceof antlr.RecognitionException) {
            return new RecognitionException(aNTLRException.getMessage()).set((antlr.RecognitionException)aNTLRException);
        }
        if (aNTLRException instanceof TokenStreamIOException) {
            throw ((TokenStreamIOException)aNTLRException).io;
        }
        return new RecognitionException(aNTLRException.getMessage());
    }

    @Override
    public int compareTo(RecognitionException recognitionException) {
        if (this.getFilename() == null) {
            return -1;
        }
        if (recognitionException.getFilename() == null) {
            return 1;
        }
        int n = this.getFilename().compareTo(recognitionException.getFilename());
        if (n != 0) {
            return n;
        }
        if (this.isError != recognitionException.isError) {
            return this.isError ? -1 : 1;
        }
        if (this.start < 0) {
            return -1;
        }
        if (recognitionException.start < 0) {
            return 1;
        }
        n = this.start - recognitionException.start;
        if (n != 0) {
            return n;
        }
        return this.stamp - recognitionException.stamp;
    }
}

