/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.grammar;

import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.TokenStreamRecognitionException;
import de.grogra.grammar.DoubleLiteral;
import de.grogra.grammar.FloatLiteral;
import de.grogra.grammar.Identifier;
import de.grogra.grammar.Input;
import de.grogra.grammar.IntLiteral;
import de.grogra.grammar.LexicalException;
import de.grogra.grammar.Literal;
import de.grogra.grammar.LongLiteral;
import de.grogra.grammar.NumberLiteral;
import de.grogra.grammar.RecognitionException;
import de.grogra.grammar.Sequence;
import de.grogra.grammar.SequenceStart;
import de.grogra.grammar.Token;
import de.grogra.grammar.UnexpectedTokenException;
import de.grogra.util.I18NBundle;
import de.grogra.util.StringMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class Tokenizer
implements TokenStream {
    public static final I18NBundle I18N = I18NBundle.getInstance(Tokenizer.class);
    public static final int EOL_IS_SIGNIFICANT = 1;
    public static final int FLOAT_IS_DEFAULT = 2;
    public static final int MINUS_IS_SIGN = 4;
    public static final int CREATE_TOKEN_LOCATOR = 8;
    public static final int EVALUATE_NUMBERS = 16;
    public static final int ENABLE_TYPE_SUFFIX = 32;
    public static final int UNICODE_ESCAPES = 64;
    protected final boolean eolIsSignificant;
    protected final boolean floatIsDefault;
    protected final boolean minusIsSign;
    protected final boolean createTokenLocator;
    protected final boolean evaluateNumbers;
    protected final boolean enableTypeSuffix;
    protected final boolean unicode;
    private Input input;
    private int tokenStart;
    private static final int INTEGER = 0;
    private static final int HEX = 1;
    private static final int FLOAT = 2;
    private static final int BUFFER_SIZE = 32;
    private TokenInfo[] tokenBuffer;
    private int bufferHead;
    private int bufferIndex;
    private StringMap tokenTableA = new StringMap();
    private StringMap tokenTableB = new StringMap();
    private static final int CHAR_CATEGORY_LENGTH = 256;
    private static final boolean[] ID_START = new boolean[256];
    private static final boolean[] ID_PART = new boolean[256];

    public Tokenizer(int n) {
        this.eolIsSignificant = (n & 1) != 0;
        this.floatIsDefault = (n & 2) != 0;
        this.minusIsSign = (n & 4) != 0;
        this.createTokenLocator = (n & 8) != 0;
        this.evaluateNumbers = (n & 0x10) != 0;
        this.enableTypeSuffix = (n & 0x20) != 0;
        this.unicode = (n & 0x40) != 0;
        this.tokenBuffer = new TokenInfo[32];
        for (int i = 0; i < 32; ++i) {
            this.tokenBuffer[i] = new TokenInfo();
        }
    }

    protected void copyTokenTablesFrom(Tokenizer tokenizer) {
        this.tokenTableA = tokenizer.tokenTableA;
        this.tokenTableB = tokenizer.tokenTableB;
    }

    public final void addToken(Token token) {
        this.addToken(token, token.getText(), true);
    }

    public final void addToken(Token token, boolean bl) {
        this.addToken(token, token.getText(), bl);
    }

    public final void addToken(int n, String string) {
        this.addToken(new Token(n, string), string, true);
    }

    public final void addToken(int n, String string, boolean bl) {
        this.addToken(new Token(n, string), string, bl);
    }

    public final void addToken(Token token, String string) {
        this.addToken(token, string, true);
    }

    public final void addToken(Token token, String string, boolean bl) {
        TokenEntry tokenEntry = new TokenEntry(token, string);
        (bl ? this.tokenTableA : this.tokenTableB).put(string, (Object)tokenEntry);
    }

    public final void setInput(Input input) {
        this.input = input;
        this.reset();
    }

    public final void setSource(Reader reader) {
        this.setSource(reader, null);
    }

    public final void setSource(Reader reader, String string) {
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        Input input = new Input(!this.unicode);
        input.setSource(reader, string);
        this.setInput(input);
    }

    public final Input getInput() {
        return this.input;
    }

    public final void reset() {
        this.bufferHead = 0;
        this.bufferIndex = 0;
        for (int i = 0; i < 32; ++i) {
            this.tokenBuffer[i].set(null, 0, 0);
        }
    }

    private TokenEntry get(int n) {
        StringMap stringMap = this.tokenTableA;
        while (true) {
            for (int i = 0; i < stringMap.size(); ++i) {
                if (((TokenEntry)stringMap.getValueAt((int)i)).token.getType() != n) continue;
                return (TokenEntry)stringMap.getValueAt(i);
            }
            if (stringMap == this.tokenTableB) {
                return null;
            }
            stringMap = this.tokenTableB;
        }
    }

    protected boolean isWhitespace(char c) {
        switch (c) {
            case '\n': {
                return !this.eolIsSignificant;
            }
            case '\t': 
            case '\f': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    protected boolean isIdentifierStart(char c) {
        return c < '\u0100' ? ID_START[c] : Character.isJavaIdentifierStart(c);
    }

    protected boolean isIdentifierPart(char c) {
        return c < '\u0100' ? ID_PART[c] : Character.isJavaIdentifierPart(c);
    }

    private Token searchToken(StringMap stringMap) throws IOException, LexicalException {
        int n;
        int n2 = n = this.input.getPosition();
        int n3 = -1;
        int n4 = 0;
        int n5 = stringMap.size();
        int n6 = 0;
        while (n4 < n5) {
            int n7 = this.input.getChar();
            int n8 = stringMap.findIndex((CharSequence)this.input, n, n6 + 1, n4, n5);
            if (n8 >= 0) {
                n2 = n + n6 + 1;
                n3 = n8;
                n4 = n8 + 1;
            } else {
                n4 = n8 ^= 0xFFFFFFFF;
            }
            for (n8 = n4; n8 < n5; ++n8) {
                if (stringMap.getKeyAt(n8).charAt(n6) == n7) continue;
                n5 = n8;
                break;
            }
            ++n6;
        }
        this.input.reset(n2);
        if (n3 < 0) {
            return null;
        }
        TokenEntry tokenEntry = (TokenEntry)stringMap.getValueAt(n3);
        Token token = tokenEntry.token;
        if (token.getType() == -1) {
            Sequence sequence = ((SequenceStart)token).createSequence(tokenEntry.string);
            return (token = sequence.getToken(this.input)) == null ? this.getTokenImpl() : token;
        }
        return token;
    }

    private Token dupIfNecessary(Token token) {
        if (this.createTokenLocator) {
            return token.dup();
        }
        return token;
    }

    private Token getTokenImpl() throws IOException, LexicalException {
        int n;
        this.tokenStart = this.input.getPosition();
        if (this.input.isClosed()) {
            return new Token(1, "");
        }
        while ((n = this.input.getChar()) != -1 && this.isWhitespace((char)n)) {
        }
        this.input.ungetChar();
        if (n == -1) {
            return new Token(1, "");
        }
        this.tokenStart = this.input.getPosition();
        Token token = this.searchToken(this.tokenTableB);
        if (token != null) {
            return this.dupIfNecessary(token);
        }
        if (this.isIdentifierStart((char)n)) {
            this.input.getChar();
            StringBuffer stringBuffer = this.input.getTmpBuffer();
            stringBuffer.append((char)n);
            while ((n = this.input.getChar()) != -1 && this.isIdentifierPart((char)n)) {
                stringBuffer.append((char)n);
            }
            this.input.ungetChar();
            int n2 = this.tokenTableA.findIndex((CharSequence)this.input, this.tokenStart, this.input.getPosition() - this.tokenStart, 0, this.tokenTableA.size());
            if (n2 >= 0) {
                return this.dupIfNecessary(((TokenEntry)this.tokenTableA.getValueAt((int)n2)).token);
            }
            return new Identifier(this.input.substring(this.tokenStart));
        }
        token = this.checkForNumberLiteral();
        if (token != null) {
            return token;
        }
        this.input.reset(this.tokenStart);
        token = this.searchToken(this.tokenTableA);
        if (token != null) {
            return this.dupIfNecessary(token);
        }
        throw new LexicalException(I18N.msg("grammar.illegal-token"));
    }

    private Literal checkForNumberLiteral() throws LexicalException, IOException {
        int n;
        boolean bl;
        int n2 = this.input.getPosition();
        int n3 = this.input.getChar();
        boolean bl2 = bl = this.minusIsSign && n3 == 45;
        if (bl) {
            n3 = this.input.getChar();
        }
        if (n3 == 10) {
            return null;
        }
        int n4 = this.input.getChar();
        if (!(Character.isDigit((char)n3) || n3 == 46 && Character.isDigit((char)n4))) {
            return null;
        }
        if (!(n3 != 48 || bl || n4 != 120 && n4 != 88)) {
            n = 1;
            n2 = this.input.getPosition();
            while (Character.digit((char)this.input.getChar(), 16) >= 0) {
            }
            this.input.ungetChar();
        } else {
            n = 0;
            this.input.ungetChar();
            this.input.ungetChar();
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            block21: while (true) {
                n3 = this.input.getChar();
                switch (n3) {
                    case 69: 
                    case 101: {
                        n = 2;
                        bl3 = true;
                        bl5 = true;
                        continue block21;
                    }
                    case 43: 
                    case 45: {
                        if (bl3) break;
                        break block21;
                    }
                    case 46: {
                        if (bl4) break block21;
                        bl4 = true;
                        n3 = this.input.getChar();
                        this.input.ungetChar();
                        if (n3 == 46) break block21;
                        n = 2;
                        break;
                    }
                    default: {
                        if (!Character.isDigit((char)n3)) break block21;
                        bl5 = false;
                    }
                }
                bl3 = false;
            }
            this.input.ungetChar();
            if (bl5) {
                throw new LexicalException(I18N.msg("grammar.invalid-number-format"));
            }
        }
        String string = this.input.substring(n2);
        try {
            int n5;
            if (this.enableTypeSuffix) {
                switch (this.input.getChar()) {
                    case 70: 
                    case 102: {
                        return new FloatLiteral(string);
                    }
                    case 68: 
                    case 100: {
                        return new DoubleLiteral(string);
                    }
                    case 76: 
                    case 108: {
                        int n6;
                        switch (n) {
                            case 1: {
                                n6 = 16;
                                break;
                            }
                            case 2: {
                                throw new LexicalException(I18N.msg("grammar.lsuffix-for-float"));
                            }
                            default: {
                                n6 = string.length() > 1 && Character.digit(string.charAt(0), 10) == 0 ? 8 : 10;
                            }
                        }
                        return this.evaluateNumbers ? new LongLiteral(Long.parseLong(string, n6)) : new LongLiteral(string, n6);
                    }
                }
                this.input.ungetChar();
            }
            switch (n) {
                case 1: {
                    n5 = 16;
                    break;
                }
                case 2: {
                    if (this.floatIsDefault) {
                        return new FloatLiteral(string);
                    }
                    return new DoubleLiteral(string);
                }
                default: {
                    n5 = string.length() > 1 && Character.digit(string.charAt(0), 10) == 0 ? 8 : 10;
                }
            }
            return this.evaluateNumbers ? new IntLiteral(Integer.parseInt(string, n5)) : new IntLiteral(string, n5);
        }
        catch (NumberFormatException numberFormatException) {
            throw new LexicalException(I18N.msg("grammar.invalid-number-format"));
        }
    }

    protected Token convert(Token token) {
        return token;
    }

    public final Token getToken() throws IOException, LexicalException {
        Token token;
        if (this.bufferIndex == this.bufferHead) {
            try {
                token = this.convert(this.getTokenImpl());
                if (this.createTokenLocator) {
                    token.setTokenizer(this);
                    token.setExtent(this.tokenStart, this.input.getPosition());
                }
                this.tokenBuffer[this.bufferHead++ & 0x1F].set(token, this.tokenStart, this.input.getPosition());
            }
            catch (LexicalException lexicalException) {
                this.complete(lexicalException);
                throw lexicalException;
            }
        } else {
            token = this.tokenBuffer[this.bufferIndex & 0x1F].token;
        }
        ++this.bufferIndex;
        return token;
    }

    public antlr.Token nextToken() throws TokenStreamException {
        try {
            return this.getToken();
        }
        catch (LexicalException lexicalException) {
            throw new TokenStreamRecognitionException((antlr.RecognitionException)lexicalException);
        }
        catch (IOException iOException) {
            throw new TokenStreamIOException(iOException);
        }
    }

    public final void ungetToken() {
        if (this.bufferIndex == 0) {
            throw new AssertionError((Object)"ungetToken without invocation of getToken.");
        }
        if (this.bufferIndex + 32 == this.bufferHead) {
            throw new AssertionError((Object)"ungetToken: Insufficient buffer capacity.");
        }
        --this.bufferIndex;
    }

    public final NumberLiteral getNumberToken(int n) throws IOException, LexicalException {
        Token token = this.getToken();
        int n2 = token.getType();
        if (n2 > 8 || (1 << n2 & n) == 0) {
            StringBuffer stringBuffer = null;
            String string = null;
            block6: for (n2 = 5; n2 <= 8; ++n2) {
                if ((1 << n2 & n) == 0) continue;
                if (string != null) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(string);
                    } else {
                        stringBuffer.append(", ").append(string);
                    }
                }
                switch (n2) {
                    case 5: {
                        string = "int";
                        continue block6;
                    }
                    case 6: {
                        string = "long";
                        continue block6;
                    }
                    case 7: {
                        string = "float";
                        continue block6;
                    }
                    case 8: {
                        string = "double";
                        continue block6;
                    }
                    default: {
                        throw new AssertionError(n2);
                    }
                }
            }
            LexicalException lexicalException = new LexicalException(stringBuffer == null ? I18N.msg("grammar.number-expected1", string) : I18N.msg("grammar.number-expected", (Object)stringBuffer.toString(), string));
            this.complete(lexicalException);
            throw lexicalException;
        }
        return (NumberLiteral)token;
    }

    public final int getInt() throws IOException, LexicalException {
        return this.getNumberToken(32).intValue();
    }

    public final float getFloat() throws IOException, LexicalException {
        return this.getNumberToken(224).floatValue();
    }

    public final void consume(int n) throws IOException, LexicalException, UnexpectedTokenException {
        Token token = this.getToken();
        if (token.getType() != n) {
            UnexpectedTokenException unexpectedTokenException = new UnexpectedTokenException(this.getTokenString(), this.get((int)n).token.getText());
            this.complete(unexpectedTokenException);
            throw unexpectedTokenException;
        }
    }

    void complete(RecognitionException recognitionException) {
        recognitionException.complete(this.input, this.tokenStart, this.input.getPosition());
    }

    void set(RecognitionException recognitionException) {
        recognitionException.set(this.input, this.tokenStart, this.input.getPosition());
    }

    private String getTokenString() {
        TokenInfo tokenInfo = this.tokenBuffer[this.bufferIndex - 1 & 0x1F];
        return this.input.substring(tokenInfo.start, tokenInfo.end);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            Tokenizer.ID_START[i] = Character.isJavaIdentifierStart((char)i);
            Tokenizer.ID_PART[i] = Character.isJavaIdentifierPart((char)i);
        }
    }

    private static final class TokenInfo {
        Token token;
        int start;
        int end;

        private TokenInfo() {
        }

        void set(Token token, int n, int n2) {
            this.token = token;
            this.start = n;
            this.end = n2;
        }
    }

    private static final class TokenEntry {
        final Token token;
        final String string;

        TokenEntry(Token token, String string) {
            this.token = token;
            this.string = string;
        }
    }
}

