/*
 * Decompiled with CFR 0.152.
 */
package de.onyxbits.giftedmotion;

import de.onyxbits.giftedmotion.CatchOldJava;
import de.onyxbits.giftedmotion.Dict;
import de.onyxbits.giftedmotion.FrameCanvas;
import de.onyxbits.giftedmotion.FrameDisplay;
import de.onyxbits.giftedmotion.FrameSequence;
import de.onyxbits.giftedmotion.IO;
import de.onyxbits.giftedmotion.ImageFileFilter;
import de.onyxbits.giftedmotion.LoadAccessory;
import de.onyxbits.giftedmotion.Player;
import de.onyxbits.giftedmotion.SequenceEditor;
import de.onyxbits.giftedmotion.SettingsEditor;
import de.onyxbits.giftedmotion.SingleFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.BevelBorder;

public class Core
extends JFrame
implements WindowListener,
ActionListener,
ComponentListener,
MouseMotionListener,
MouseListener {
    public static final String VERSION = "GiftedMotion " + Package.getPackage("de.onyxbits.giftedmotion").getImplementationVersion();
    public static Core app;
    private JMenuItem quit = new JMenuItem(Dict.get("core.quit"), 81);
    private JMenuItem load = new JMenuItem(Dict.get("core.load"), 76);
    private JMenuItem export = new JMenuItem(Dict.get("core.export"), 83);
    private JMenuItem extract = new JMenuItem(Dict.get("core.extract"), 69);
    private JMenuItem license = new JMenuItem(Dict.get("core.license"));
    private JMenuItem handbook = new JMenuItem(Dict.get("core.handbook"));
    private JMenuItem faq = new JMenuItem(Dict.get("core.faq"));
    private JButton play = new JButton(IO.createIcon("Tango/22x22/actions/media-playback-start.png", Dict.get("core.play")));
    private JButton pause = new JButton(IO.createIcon("Tango/22x22/actions/media-playback-pause.png", Dict.get("core.pause")));
    private JButton record = new JButton(IO.createIcon("Tango/22x22/actions/media-record.png", Dict.get("core.record")));
    private JButton open = new JButton(IO.createIcon("Tango/22x22/actions/document-open.png", Dict.get("core.open")));
    private JButton togglesettings = new JButton(IO.createIcon("Tango/22x22/categories/preferences-desktop.png", Dict.get("core.togglesettings")));
    private SequenceEditor seqedit;
    private FrameDisplay display;
    private SettingsEditor setedit = new SettingsEditor();
    private JDesktopPane workspace = new JDesktopPane();
    private FrameSequence seq;
    private File directory = new File(System.getProperty("user.dir"));
    private Player player;
    private JLabel status = new JLabel();

    public Core() {
        this.load.addActionListener(this);
        this.extract.addActionListener(this);
        this.export.addActionListener(this);
        this.quit.addActionListener(this);
        this.faq.addActionListener(this);
        this.handbook.addActionListener(this);
        this.license.addActionListener(this);
        this.open.addActionListener(this);
        this.play.addActionListener(this);
        this.pause.addActionListener(this);
        this.record.addActionListener(this);
        this.togglesettings.addActionListener(this);
        this.quit.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.load.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.export.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.handbook.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.open.setToolTipText(((ImageIcon)this.open.getIcon()).getDescription());
        this.play.setToolTipText(((ImageIcon)this.play.getIcon()).getDescription());
        this.pause.setToolTipText(((ImageIcon)this.pause.getIcon()).getDescription());
        this.togglesettings.setToolTipText(((ImageIcon)this.togglesettings.getIcon()).getDescription());
        this.record.setToolTipText(((ImageIcon)this.record.getIcon()).getDescription());
        this.pause.setEnabled(false);
        this.status.setBorder(new BevelBorder(1));
        JMenu jMenu = new JMenu(Dict.get("core.core.file"));
        jMenu.add(this.load);
        jMenu.add(this.extract);
        jMenu.add(this.export);
        jMenu.add(new JSeparator());
        jMenu.add(this.quit);
        JMenu jMenu2 = new JMenu(Dict.get("core.core.help"));
        jMenu2.add(this.handbook);
        jMenu2.add(this.faq);
        jMenu2.add(new JSeparator());
        jMenu2.add(this.license);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        jMenuBar.add(Box.createHorizontalGlue());
        jMenuBar.add(jMenu2);
        jMenuBar.setBorder(new BevelBorder(0));
        this.setJMenuBar(jMenuBar);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setRollover(true);
        jToolBar.setFloatable(true);
        jToolBar.add(this.open);
        jToolBar.add(this.togglesettings);
        jToolBar.addSeparator();
        jToolBar.add(this.play);
        jToolBar.add(this.pause);
        jToolBar.add(this.record);
        jToolBar.addSeparator();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jToolBar, "North");
        jPanel.add((Component)this.workspace, "Center");
        jPanel.add((Component)this.status, "South");
        this.setContentPane(jPanel);
        this.workspace.add(this.setedit);
        this.postStatus("");
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.handleQuit();
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.quit) {
            this.handleQuit();
        }
        if (object == this.load || object == this.open) {
            this.handleLoad();
        }
        if (object == this.extract) {
            this.handleExtract();
        }
        if (object == this.export || object == this.record) {
            this.handleExport();
        }
        if (object == this.handbook) {
            this.handleHandbook();
        }
        if (object == this.faq) {
            this.handleFAQ();
        }
        if (object == this.license) {
            this.handleLicense();
        }
        if (object == this.play || object == this.pause) {
            this.handlePlayPause();
        }
        if (object == this.togglesettings) {
            this.handleTogglesettings();
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        Component component = (Component)componentEvent.getSource();
        Object[] objectArray = new Integer[]{new Integer(component.getWidth()), new Integer(component.getHeight())};
        this.postStatus(Dict.get("core.componentresized", objectArray));
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.seq.selected == null) {
            return;
        }
        Object[] objectArray = new Integer[]{new Integer(this.seq.selected.position.x), new Integer(this.seq.selected.position.y)};
        this.postStatus(Dict.get("core.mousedragged", objectArray));
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.seq.selected == null) {
            return;
        }
        Object[] objectArray = new Integer[]{new Integer(this.seq.selected.position.x), new Integer(this.seq.selected.position.y)};
        this.postStatus(Dict.get("core.mousepressed", objectArray));
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.postStatus("");
    }

    public void handleQuit() {
        System.exit(0);
    }

    public void handleLoad() {
        try {
            this.postStatus(Dict.get("core.handleload.hint"));
            LoadAccessory loadAccessory = new LoadAccessory();
            JFileChooser jFileChooser = new JFileChooser(this.directory);
            jFileChooser.setMultiSelectionEnabled(true);
            jFileChooser.setAccessory(loadAccessory);
            jFileChooser.addPropertyChangeListener(loadAccessory);
            jFileChooser.addChoosableFileFilter(new ImageFileFilter(true));
            if (jFileChooser.showOpenDialog(this) != 0) {
                this.postStatus("");
                return;
            }
            this.postStatus("");
            this.directory = jFileChooser.getCurrentDirectory();
            File[] fileArray = jFileChooser.getSelectedFiles();
            if (fileArray.length == 1 && fileArray[0].isDirectory()) {
                jFileChooser.setCurrentDirectory(fileArray[0]);
                return;
            }
            SingleFrame[] singleFrameArray = IO.load(fileArray);
            if (singleFrameArray == null || singleFrameArray.length == 0) {
                this.postStatus(Dict.get("core.handleload.nothing"));
                return;
            }
            this.setFrameSequence(new FrameSequence(singleFrameArray));
            if (singleFrameArray.length == 1) {
                JOptionPane.showInternalMessageDialog(this.workspace, Dict.get("core.handleload.singlefile.txt"));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.postStatus(Dict.get("core.handleload.illegalargumentexception", illegalArgumentException.getMessage()));
        }
        catch (IOException iOException) {
            this.postStatus(iOException.getMessage());
        }
        catch (Exception exception) {
            this.postStatus(Dict.get("core.handleload.exception"));
            exception.printStackTrace();
        }
    }

    public void handleExtract() {
        if (this.seq == null || this.seq.frames.length == 0) {
            this.postStatus(Dict.get("core.handleextract.nothing"));
            return;
        }
        try {
            JFileChooser jFileChooser = new JFileChooser(this.directory);
            jFileChooser.setFileSelectionMode(1);
            if (jFileChooser.showSaveDialog(this) != 0) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            this.directory = jFileChooser.getCurrentDirectory();
            IO.extract(this.seq, file);
            this.postStatus(Dict.get("core.handleextract.saved"));
        }
        catch (IOException iOException) {
            this.postStatus(iOException.getMessage());
        }
    }

    public void handleExport() {
        try {
            this.postStatus("");
            if (this.seq == null) {
                this.postStatus(Dict.get("core.handleexport.nothing"));
                return;
            }
            JFileChooser jFileChooser = new JFileChooser(this.directory);
            jFileChooser.setSelectedFile(new File(Dict.get("core.handleexport.defaultname")));
            if (jFileChooser.showSaveDialog(this) != 0) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            this.directory = jFileChooser.getCurrentDirectory();
            Cursor cursor = new Cursor(3);
            this.setCursor(cursor);
            this.postStatus(Dict.get("core.handleexport.saving"));
            IO.export(file, this.seq, this.display.getCanvas().getSize(), this.setedit.getSettings());
            this.postStatus(Dict.get("core.handleexport.finished"));
            cursor = new Cursor(0);
            this.setCursor(cursor);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.postStatus(Dict.get("core.handleexport.filenotfoundexception", fileNotFoundException.getMessage()));
        }
        catch (Exception exception) {
            this.postStatus(Dict.get("core.handleexport.exception"));
            exception.printStackTrace();
        }
    }

    public void handleLicense() {
        try {
            JInternalFrame jInternalFrame = new JInternalFrame("", false, true, false, false);
            JEditorPane jEditorPane = new JEditorPane(this.getClass().getClassLoader().getResource("resources/LICENSE"));
            jEditorPane.setEditable(false);
            jInternalFrame.setContentPane(new JScrollPane(jEditorPane));
            this.workspace.add(jInternalFrame);
            jInternalFrame.setMaximum(true);
            jInternalFrame.show();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void handleHandbook() {
        String string = "http://www.onyxbits.de/giftedmotion/handbook";
        try {
            CatchOldJava.openBrowser(string);
        }
        catch (Exception exception) {
            JOptionPane.showInternalMessageDialog(this.workspace, Dict.get("core.handlehandbook.text", string), Dict.get("core.handlehandbook.title"), 0);
        }
    }

    public void handleFAQ() {
        String string = "http://www.onyxbits.de/faq/giftedmotion";
        try {
            CatchOldJava.openBrowser(string);
        }
        catch (Exception exception) {
            JOptionPane.showInternalMessageDialog(this.workspace, Dict.get("core.handlehandbook.text", string), Dict.get("core.handlehandbook.title"), 0);
        }
    }

    public void handlePlayPause() {
        try {
            if (this.play.isEnabled()) {
                this.player = new Player(this.seq, 0);
                this.player.start();
                this.play.setEnabled(false);
                this.pause.setEnabled(true);
            } else {
                this.player.interrupt();
                this.player.join();
                this.play.setEnabled(true);
                this.pause.setEnabled(false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void handleTogglesettings() {
        if (this.setedit.isVisible()) {
            this.setedit.setVisible(false);
        } else {
            this.setedit.setVisible(true);
        }
    }

    public void setFrameSequence(FrameSequence frameSequence) {
        if (frameSequence == null) {
            return;
        }
        this.seq = frameSequence;
        if (this.seqedit != null) {
            this.seqedit.dispose();
        }
        if (this.display != null) {
            this.display.dispose();
        }
        this.seqedit = new SequenceEditor(frameSequence);
        frameSequence.addFrameSequenceListener(this.seqedit);
        this.workspace.add(this.seqedit);
        this.seqedit.setLocation(5, 5);
        this.seqedit.show();
        FrameCanvas frameCanvas = new FrameCanvas(frameSequence);
        frameCanvas.addComponentListener(this);
        frameCanvas.addMouseMotionListener(this);
        frameCanvas.addMouseListener(this);
        frameSequence.addFrameSequenceListener(frameCanvas);
        this.display = new FrameDisplay(frameCanvas);
        this.workspace.add(this.display);
        this.display.setLocation(this.seqedit.getSize().width + 10, 5);
        this.display.show();
    }

    public void postStatus(String string) {
        if (string.equals("")) {
            this.status.setText(" ");
        } else {
            this.status.setText(string);
        }
    }

    public static void main(String[] stringArray) {
        new Dict();
        app = new Core();
        app.setSize(new Dimension(800, 600));
        app.setTitle(VERSION);
        CatchOldJava.decorateWindow(app);
        app.setVisible(true);
        app.addWindowListener(app);
        if (stringArray != null && stringArray.length != 0) {
            File[] fileArray = new File[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                fileArray[i] = new File(stringArray[i]);
            }
            try {
                SingleFrame[] singleFrameArray = IO.load(fileArray);
                app.setFrameSequence(new FrameSequence(singleFrameArray));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

