/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.swing.action;

import de.jave.figlet.swing.action.FigLetFontSample;
import java.util.HashSet;
import net.disy.commons.core.util.ArrayUtilities;
import net.disy.commons.core.util.Ensure;

public class CharacterRanking {
    private final char[] characters;

    private CharacterRanking(char[] characters) {
        Ensure.ensureArgumentNotNull(characters);
        this.characters = characters;
    }

    public double rank(FigLetFontSample sample) {
        int containedCharacters = 0;
        for (int i = 0; i < this.characters.length; ++i) {
            if (!sample.contains(this.characters[i])) continue;
            ++containedCharacters;
        }
        return (double)containedCharacters / (double)this.characters.length;
    }

    public static CharacterRanking compile(String searchString) {
        char[] characterArray = CharacterRanking.getContainedCharacters(searchString);
        return new CharacterRanking(characterArray);
    }

    public static char[] getContainedCharacters(String searchString) {
        HashSet<Character> set = new HashSet<Character>();
        for (int i = 0; i < searchString.length(); ++i) {
            char character = searchString.charAt(i);
            if (character == '\n') continue;
            set.add(new Character(character));
        }
        Character[] array = set.toArray(new Character[set.size()]);
        char[] characterArray = ArrayUtilities.toPrimitive(array);
        return characterArray;
    }
}

