/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui.io;

import de.jave.gui.io.FileChooserUtilities;
import de.jave.gui.io.FileSelection;
import de.jave.gui.io.ISourceFilePanelConfiguration;
import de.jave.jave.actions.ButtonToolbarBuilder;
import de.jave.jave.icon.JaveIcons;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.disy.commons.core.io.FileModel;
import net.disy.commons.core.model.ObjectModel;
import net.disy.commons.core.model.listener.IChangeListener;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.dialog.io.NonEditableFileStringTextField;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.layout.grid.GridDialogPanelBuilder;
import net.disy.commons.swing.layout.grid.IDialogComponent;

public abstract class SourceFilePanel
implements IDialogComponent {
    private final JButton openButton;
    private final NonEditableFileStringTextField tfImageName;
    private final FileModel fileModel;
    private final JButton closeButton;
    private final SmartAction openAction;
    private final ISourceFilePanelConfiguration configuration;

    public SourceFilePanel(final FileModel fileModel, ISourceFilePanelConfiguration configuration) {
        Ensure.ensureArgumentNotNull(fileModel);
        Ensure.ensureArgumentNotNull(configuration);
        this.fileModel = fileModel;
        this.configuration = configuration;
        final ObjectModel<String> filenameModel = new ObjectModel<String>();
        this.tfImageName = new NonEditableFileStringTextField(filenameModel);
        this.openAction = new SmartAction(JaveIcons.OPEN_ICON){

            @Override
            protected void execute(Component parentComponent) {
                SourceFilePanel.this.performOpenImage(parentComponent);
            }
        };
        this.openAction.setToolTipText(configuration.getOpenButtonToolTipText());
        final SmartAction closeAction = new SmartAction(JaveIcons.CLOSE_ICON){

            @Override
            protected void execute(Component parentComponent) {
                if (SourceFilePanel.this.performCloseFile(parentComponent)) {
                    fileModel.setValue(null);
                }
            }
        };
        closeAction.setToolTipText(configuration.getCloseButtonToolTipText());
        fileModel.addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                SourceFilePanel.this.updateCloseActionEnabled(closeAction);
            }
        });
        this.updateCloseActionEnabled(closeAction);
        this.openButton = ButtonToolbarBuilder.createToolbarButton(this.openAction);
        this.closeButton = ButtonToolbarBuilder.createToolbarButton(closeAction);
        fileModel.addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                SourceFilePanel.this.updateTextField(filenameModel);
                File file = (File)fileModel.getValue();
                if (file != null) {
                    SourceFilePanel.this.configuration.getFileChooserConfiguration().getCurrentDirectoryModel().setValue(file.getParentFile());
                }
            }
        });
        this.updateTextField(filenameModel);
    }

    private void updateCloseActionEnabled(SmartAction closeAction) {
        closeAction.setEnabled(this.fileModel.getValue() != null);
    }

    private void updateTextField(ObjectModel<String> filenameModel) {
        File file = (File)this.fileModel.getValue();
        filenameModel.setValue(file == null ? "" : file.getAbsolutePath());
    }

    public final void performOpenImage(Component parentComponent) {
        FileSelection fileSelection = FileChooserUtilities.performOpenFileChooser(parentComponent, this.configuration.getFileChooserConfiguration());
        if (fileSelection.isEmpty()) {
            return;
        }
        boolean success = this.performOpenFile(parentComponent, fileSelection.getFile());
        if (success) {
            this.fileModel.setValue(fileSelection.getFile());
        }
    }

    protected abstract boolean performOpenFile(Component var1, File var2);

    public final JComponent createPanel() {
        GridDialogPanelBuilder panel = new GridDialogPanelBuilder();
        panel.add(this);
        return panel.createPanel();
    }

    @Override
    public final int getColumnCount() {
        return 3;
    }

    @Override
    public final void fillInto(JPanel panel, int columnCount) {
        panel.add(new JLabel(this.configuration.getLabel()));
        GridDialogLayoutData data = new GridDialogLayoutData(GridDialogLayoutData.FILL_HORIZONTAL);
        data.setHorizontalSpan(columnCount - 2);
        panel.add((Component)this.tfImageName.getContent(), data);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 0));
        buttonPanel.add(this.openButton);
        if (this.configuration.isCloseAvailable()) {
            buttonPanel.add(this.closeButton);
        }
        panel.add(buttonPanel);
    }

    protected boolean performCloseFile(Component parentComponent) {
        return true;
    }

    public final FileModel getFileModel() {
        return this.fileModel;
    }

    public final void setEnabled(boolean enabled) {
        this.openAction.setEnabled(enabled);
    }
}

