/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii;

import de.jave.image.Rotation;
import de.jave.image.greyscale.algorithm.dithering.IGreyscaleDithering;
import de.jave.image2ascii.AsciiGreyscaleTable;
import de.jave.image2ascii.AsciiGreyscaleTableAccess;
import de.jave.image2ascii.AsciiGreyscaleTableConfiguration;
import de.jave.image2ascii.ConversionException;
import de.jave.image2ascii.Converter;
import de.jave.image2ascii.Image2AsciiAlgorithm;
import de.jave.image2ascii.Image2AsciiAlgorithmFactory;
import de.jave.jave.JaveConfigurationFileLoader;
import de.jave.jave.filter.Filter;
import de.jave.lib.CharacterPlate;
import de.jave.text.TextTools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.List;
import net.disy.commons.swing.fontchooser.model.FontModel;

public class CommandLineImage2Ascii {
    public static void initialize() {
        new JaveConfigurationFileLoader(null).initConfigFile(AsciiGreyscaleTableConfiguration.getInstance());
    }

    public static void performJob(List options) throws ConversionException {
        FontModel displayFontModel = new FontModel();
        String fileName = (String)options.get(0);
        Filter.init();
        String algorithmName = "jave_algorithm";
        int resultWidth = 72;
        Rotation rotate = Rotation.NONE;
        double shapeFactor = 1.0;
        boolean normalize = true;
        boolean invert = false;
        double gamma = 1.0;
        double highlight = 100.0;
        double shadow = 0.0;
        double sharpen = 0.0;
        IGreyscaleDithering dithering = null;
        String charfile = null;
        AsciiGreyscaleTable greyscaleTable = AsciiGreyscaleTableAccess.getDefaultTable();
        for (int i = 1; i < options.size(); ++i) {
            String option = (String)options.get(i);
            int i1 = option.indexOf(61);
            if (i1 == -1) {
                System.err.println("Unknown option or syntax error: '" + option + "' - ignored.");
                continue;
            }
            String name = option.substring(0, i1).toLowerCase().trim();
            String value = option.substring(i1 + 1).toLowerCase().trim();
            if (name.equals("width")) {
                try {
                    resultWidth = Integer.parseInt(value);
                }
                catch (Exception e) {
                    System.err.println("Wrong number format for width: '" + value + "' - ignored.");
                }
                continue;
            }
            if (name.equals("algorithm")) {
                algorithmName = value;
                continue;
            }
            if (name.equals("shape")) {
                try {
                    shapeFactor = Double.valueOf(value);
                }
                catch (Exception e) {
                    System.err.println("Wrong number format for shape factor: '" + value + "' - ignored.");
                }
                continue;
            }
            if (name.equals("charfile")) {
                try {
                    BufferedReader br = new BufferedReader(new FileReader(value));
                    charfile = br.readLine();
                    br.close();
                }
                catch (Exception e) {
                    System.err.println("Error reading charfile '" + value + "':" + e);
                }
                continue;
            }
            if (name.equals("table")) {
                String tableName = TextTools.firstLetterUp(value.replace('_', ' '));
                AsciiGreyscaleTable t = AsciiGreyscaleTableAccess.getTable(tableName);
                if (t != null) {
                    greyscaleTable = t;
                    continue;
                }
                System.err.println("Greyscale table not found '" + value + "'");
                continue;
            }
            System.err.println("Unknown option '" + option + "' - ignored.");
        }
        Image2AsciiAlgorithm algorithm = Image2AsciiAlgorithmFactory.getAlgorithm(algorithmName = algorithmName.replace('_', ' '), displayFontModel);
        if (algorithm == null) {
            System.err.println("No such algorithm: '" + algorithmName + "'");
            return;
        }
        if (charfile != null) {
            algorithm.setSpecialChars(charfile);
        }
        algorithm.setGreyscaleTable(greyscaleTable);
        CharacterPlate cp = Converter.convert(new File(fileName), rotate, shapeFactor, resultWidth, algorithm, true, false, 1.0, 100.0, 0.0, 0.0, dithering);
        System.out.println(cp.asString());
    }
}

