/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.actions;

import de.jave.jave.actions.AbstractJaveAction;
import de.jave.jave.actions.enablestrategy.IJaveDocumentEditorActionEnabledStrategy;
import de.jave.jave.actions.enablestrategy.TextAndAnimationEditorEnabledStrategy;
import de.jave.jave.algorithm.repair.AsciiRepairAlgorithm;
import de.jave.jave.plate.IDocumentEditor;
import de.jave.jave.plate.JaveMainPanel;
import de.jave.lib.CharacterPlate;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import net.disy.commons.core.progress.INonInterruptableRunnableWithProgress;
import net.disy.commons.core.progress.IProgressMonitor;
import net.disy.commons.swing.dialog.progress.ProgressMonitorDialog;

public final class RepairShakedLinesAction
extends AbstractJaveAction {
    public RepairShakedLinesAction(JaveMainPanel mainPanel) {
        super(mainPanel, "Shaked lines", null);
    }

    @Override
    protected void ececute(Component parentComponent, IDocumentEditor editor) {
        final CharacterPlate cp = this.getMainPanel().getContentOfInterest().getContent();
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(parentComponent, "Repairing Shaked Lines");
        try {
            progressDialog.run(new INonInterruptableRunnableWithProgress(){

                @Override
                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    monitor.beginTask("Repair shaked lines", -1);
                    CharacterPlate cr = AsciiRepairAlgorithm.repairShaked(cp);
                    if (cr == null) {
                        return;
                    }
                    RepairShakedLinesAction.this.getMainPanel().setContentOfInterest(cr);
                    RepairShakedLinesAction.this.getMainPanel().repaint();
                    RepairShakedLinesAction.this.getMainPanel().saveCurrentState("repair");
                }
            });
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected IJaveDocumentEditorActionEnabledStrategy getEnabledStrategy() {
        return TextAndAnimationEditorEnabledStrategy.getInstance();
    }
}

