/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.actions.fileimport;

import de.jave.jave.actions.fileimport.AsciimationOptionsModel;
import java.util.regex.Pattern;

public class AsciimationImportHeuristic {
    private static final Pattern PATTERN = Pattern.compile("\\s*['`,.]?-+>.*<-+['`,.]?\\s*");

    public static void initialize(String[] lines, AsciimationOptionsModel asciimationOptionsModel) {
        int frameHeight = AsciimationImportHeuristic.getScrollBarFrameHeight(lines);
        if (frameHeight == -1) {
            return;
        }
        asciimationOptionsModel.initialize(frameHeight, frameHeight - 1, 0);
    }

    public static int getScrollBarFrameHeight(String[] lines) {
        if (lines.length < 2) {
            return -1;
        }
        if (!AsciimationImportHeuristic.isScrollBarAnimationBoundaryLine(lines[0])) {
            return -1;
        }
        for (int i = 1; i < lines.length; ++i) {
            if (!AsciimationImportHeuristic.isScrollBarAnimationBoundaryLine(lines[i])) continue;
            return i + 1;
        }
        return -1;
    }

    public static boolean isScrollBarAnimationBoundaryLine(String line) {
        return PATTERN.matcher(line).matches();
    }
}

