/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.algorithm.repair;

import de.jave.jave.algorithm.repair.AsciiRepairRule;
import de.jave.jave.configuration.ConfigurationException;
import de.jave.jave.configuration.IJavaInitializationContext;
import de.jave.jave.configuration.IJaveInitializable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import net.disy.commons.core.io.IOUtilities;

public class AsciiRepairAlgorithmConfiguration
implements IJaveInitializable {
    private AsciiRepairRule[] rules = new AsciiRepairRule[0];
    private int identical = 0;
    private int identicalLeft = 0;
    private int identicalRight = 0;
    private static final AsciiRepairAlgorithmConfiguration instance = new AsciiRepairAlgorithmConfiguration();

    private AsciiRepairAlgorithmConfiguration() {
    }

    public int getIdentical() {
        return this.identical;
    }

    @Override
    public void initialize(IJavaInitializationContext context) throws ConfigurationException {
        File configurationFile = context.getConfigurationFile("./config/repair.txt");
        ArrayList<AsciiRepairRule> rulesList = new ArrayList<AsciiRepairRule>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(configurationFile));
            boolean blockCount = false;
            int lineCount = 0;
            String line1 = br.readLine();
            ++lineCount;
            while (line1 != null && (line1.length() < 1 || line1.charAt(0) == '#')) {
                line1 = br.readLine();
                ++lineCount;
            }
            this.identical = Integer.parseInt(line1);
            line1 = br.readLine();
            ++lineCount;
            while (line1 != null && (line1.length() < 1 || line1.charAt(0) == '#')) {
                line1 = br.readLine();
                ++lineCount;
            }
            this.identicalLeft = Integer.parseInt(line1);
            line1 = br.readLine();
            ++lineCount;
            while (line1 != null && (line1.length() < 1 || line1.charAt(0) == '#')) {
                line1 = br.readLine();
                ++lineCount;
            }
            this.identicalRight = Integer.parseInt(line1);
            while (line1 != null) {
                line1 = br.readLine();
                ++lineCount;
                while (line1 != null && (line1.length() < 1 || line1.charAt(0) == '#')) {
                    line1 = br.readLine();
                    ++lineCount;
                }
                if (line1 == null) break;
                String line2 = br.readLine();
                ++lineCount;
                while (line2 != null && (line2.length() < 1 || line2.charAt(0) == '#')) {
                    line2 = br.readLine();
                    ++lineCount;
                }
                if (line2 == null) break;
                String line3 = br.readLine();
                ++lineCount;
                while (line3 != null && (line3.length() < 1 || line3.charAt(0) == '#')) {
                    line3 = br.readLine();
                    ++lineCount;
                }
                if (line3 == null) break;
                AsciiRepairRule r = AsciiRepairRule.getFrom(line1, line2, line3);
                if (r == null) continue;
                rulesList.add(r);
            }
        }
        catch (IOException e) {
            try {
                throw new ConfigurationException(configurationFile, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtilities.close(br);
                throw throwable;
            }
        }
        IOUtilities.close(br);
        this.rules = rulesList.toArray(new AsciiRepairRule[rulesList.size()]);
    }

    public int getIdenticalLeft() {
        return this.identicalLeft;
    }

    public int getIdenticalRight() {
        return this.identicalRight;
    }

    public AsciiRepairRule[] getRules() {
        return this.rules;
    }

    public static AsciiRepairAlgorithmConfiguration getInstance() {
        return instance;
    }
}

