/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.algorithm.replaceillegal;

import de.jave.jave.configuration.ConfigurationException;
import de.jave.jave.configuration.IJavaInitializationContext;
import de.jave.jave.configuration.IJaveInitializable;
import de.jave.lib.collections.IntVector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import net.disy.commons.core.io.IOUtilities;

public class AsciiReplaceIllegalConfiguration
implements IJaveInitializable {
    private static final char[] DEFAULT_REPLACE_ILLEGAL_SOURCE = new char[]{'\u00b4', '\u00a0', '\u00d1', '\u00b8', '\u00a8', '\u00b7', '\u00af', '\u00f8', '\u00a6', '\u00e4', '\u00c4', '\u00f6', '\u00d6', '\u00fc', '\u00dc', '\u2019', '\u00d8', '\u2026'};
    private static final char[] DEFAULT_REPLACE_ILLEGAL_DESTINATION = new char[]{'\'', ' ', 'N', '.', '\"', '.', '\"', 'o', '|', 'a', 'A', 'o', 'O', 'u', 'U', '\'', 'O', '_'};
    private char[] replaceIllegalSource = DEFAULT_REPLACE_ILLEGAL_SOURCE;
    private char[] replaceIllegalDestination = DEFAULT_REPLACE_ILLEGAL_DESTINATION;
    private static final AsciiReplaceIllegalConfiguration instance = new AsciiReplaceIllegalConfiguration();

    @Override
    public void initialize(IJavaInitializationContext context) throws ConfigurationException {
        File configurationFile = context.getConfigurationFile("./config/replace_illegal.txt");
        IntVector source = new IntVector(100);
        IntVector destination = new IntVector(100);
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(configurationFile));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.length() <= 2 || line.charAt(0) == '#') continue;
                int i1 = line.indexOf(32);
                if (i1 == -1) {
                    throw new Exception("The file has a syntax error: '" + line + "'");
                }
                try {
                    source.addElement(Integer.parseInt(line.substring(0, i1)));
                }
                catch (Exception e) {
                    throw new Exception("The file has a syntax error: '" + line + "' does not start with a number.");
                }
                destination.addElement(line.charAt(i1 + 1));
            }
        }
        catch (Exception e) {
            try {
                throw new ConfigurationException(configurationFile, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtilities.close(br);
                throw throwable;
            }
        }
        IOUtilities.close(br);
        int size = source.size();
        if (source.size() == 0) {
            throw new ConfigurationException(configurationFile, "The file seems to be empty.");
        }
        this.replaceIllegalSource = new char[size];
        this.replaceIllegalDestination = new char[size];
        for (int i = 0; i < size; ++i) {
            this.replaceIllegalSource[i] = (char)source.elementAt(i);
            this.replaceIllegalDestination[i] = (char)destination.elementAt(i);
        }
    }

    public static AsciiReplaceIllegalConfiguration getInstance() {
        return instance;
    }

    private AsciiReplaceIllegalConfiguration() {
    }

    public char[] getReplaceIllegalSource() {
        return this.replaceIllegalSource;
    }

    public char[] getReplaceIllegalDestination() {
        return this.replaceIllegalDestination;
    }
}

