/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.plate.selection;

import de.jave.asciimation.editor.AnimationEditorModel;
import de.jave.awt.clipboard.JaveClipboardSelection;
import de.jave.jave.Plate;
import de.jave.jave.PlateDocument;
import de.jave.jave.Selection;
import de.jave.jave.browser.IJaveDocumentTypeVisitor;
import de.jave.jave.browser.JaveDocumentType;
import de.jave.jave.plate.AnimationDocumentEditor;
import de.jave.jave.plate.IDocumentEditor;
import de.jave.jave.preferences.PlatePreferences;
import de.jave.javeplayer.JaveAnimationFrame;
import de.jave.lib.CharacterPlate;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

public class SelectionAlgorithms {
    public static void pasteAsNewSelection(IDocumentEditor editor, CharacterPlate content, Point location) {
        Plate plate = editor.getPlate();
        SelectionAlgorithms.dropSelectionIfAny(editor);
        plate.getSelection().set(location, content);
        plate.repaint();
    }

    public static void pasteAsNewSelection(IDocumentEditor editor, JaveClipboardSelection sel, Point location) {
        Plate plate = editor.getPlate();
        SelectionAlgorithms.dropSelectionIfAny(editor);
        plate.getSelection().set(location, sel);
        plate.repaint();
    }

    public static void expandSelection(IDocumentEditor editor) {
        Plate plate = editor.getPlate();
        Rectangle re = plate.getSelectionRegion();
        SelectionAlgorithms.dropSelection(editor);
        --re.x;
        --re.y;
        re.width += 2;
        re.height += 2;
        plate.setSelection(re);
    }

    public static void shrinkSelection(IDocumentEditor editor) {
        Plate plate = editor.getPlate();
        CharacterPlate ch = plate.getSelectionContent();
        Insets insets = ch.getEmptyInsets();
        int w = ch.getWidth();
        int h = ch.getHeight();
        if (insets.top + insets.bottom >= h || insets.right + insets.left >= w || h == 1 && w == 1 && ch.get(0, 0) == ' ') {
            SelectionAlgorithms.dropSelection(editor);
            return;
        }
        int w2 = w - insets.left - insets.right;
        int h2 = h - insets.bottom - insets.top;
        CharacterPlate chNew = new CharacterPlate(w2, h2);
        for (int y = 0; y < h2; ++y) {
            for (int x = 0; x < w2; ++x) {
                chNew.set(x, y, ch.get(x + insets.left, y + insets.top));
            }
        }
        Point p = plate.getSelection().getLocation();
        plate.getSelection().set(new Point(p.x + insets.left, p.y + insets.top), chNew);
        plate.repaint();
    }

    public static void selectAll(IDocumentEditor editor) {
        SelectionAlgorithms.dropSelectionIfAny(editor);
        Plate plate = editor.getPlate();
        Dimension documentSize = plate.getDocumentSize();
        Rectangle region = new Rectangle(0, 0, documentSize.width, documentSize.height);
        plate.setSelection(region, plate.cut(region));
    }

    public static void dropSelection(IDocumentEditor editor) {
        PlateDocument document;
        Insets expansion;
        Plate plate = editor.getPlate();
        if (!plate.hasSelection()) {
            throw new RuntimeException("No Selection to drop in Plate.dropSelection()!");
        }
        Selection selection = plate.getSelection();
        if (SelectionAlgorithms.isAutoExpandEnabledFor(plate.getPlatePreferences(), editor.getType()) && (expansion = SelectionAlgorithms.getRequiredExpansionToDrop((document = plate.getDocument()).getSize(), selection.getRegion())) != null) {
            SelectionAlgorithms.expandDocument(editor, expansion);
        }
        selection.paste();
        plate.unselect();
    }

    private static boolean isAutoExpandEnabledFor(final PlatePreferences preferences, JaveDocumentType documentType) {
        return documentType.accept(new IJaveDocumentTypeVisitor<Boolean>(){

            @Override
            public Boolean visitText(JaveDocumentType type) {
                return preferences.isAutoResizeOnDropForTextEditor();
            }

            @Override
            public Boolean visitGame(JaveDocumentType type) {
                return Boolean.FALSE;
            }

            @Override
            public Boolean visitAnimation(JaveDocumentType type) {
                return preferences.isAutoResizeOnDropForAnimationEditor();
            }
        });
    }

    private static void expandDocument(final IDocumentEditor editor, final Insets expansion) {
        final Plate plate = editor.getPlate();
        final PlateDocument document = plate.getDocument();
        final Selection selection = plate.getSelection();
        final Point p = selection.getLocation();
        editor.getType().accept(new IJaveDocumentTypeVisitor<Void>(){

            @Override
            public Void visitText(JaveDocumentType type) {
                selection.setLocation(p.x + expansion.left, p.y + expansion.top);
                CharacterPlate content = document.getContent();
                content.expand(expansion);
                plate.handleDocumentSizeChanged();
                return null;
            }

            @Override
            public Void visitGame(JaveDocumentType type) {
                return null;
            }

            @Override
            public Void visitAnimation(JaveDocumentType type) {
                selection.setLocation(p.x + expansion.left, p.y + expansion.top);
                AnimationDocumentEditor animationEditor = (AnimationDocumentEditor)editor;
                AnimationEditorModel model = animationEditor.getModel();
                for (int frameIndex = 0; frameIndex < model.getAnimationFile().getFrameCount(); ++frameIndex) {
                    JaveAnimationFrame frame = model.getAnimationFile().getFrame(frameIndex);
                    CharacterPlate characterPlate = new CharacterPlate(frame.getContent());
                    characterPlate.expand(expansion);
                    frame.setContent(characterPlate);
                }
                CharacterPlate content = document.getContent();
                content.expand(expansion);
                plate.handleDocumentSizeChanged();
                return null;
            }
        });
    }

    private static Insets getRequiredExpansionToDrop(Dimension documentSize, Rectangle selectionRectangle) {
        Point p = selectionRectangle.getLocation();
        int left = p.x < 0 ? -p.x : 0;
        int top = p.y < 0 ? -p.y : 0;
        int right = p.x + selectionRectangle.width > documentSize.width ? p.x + selectionRectangle.width - documentSize.width : 0;
        int bottom = p.y + selectionRectangle.height > documentSize.height ? p.y + selectionRectangle.height - documentSize.height : 0;
        if (left == 0 && right == 0 && top == 0 && bottom == 0) {
            return null;
        }
        return new Insets(top, left, bottom, right);
    }

    public static void dropSelectionIfAny(IDocumentEditor editor) {
        if (editor.getPlate().hasSelection()) {
            SelectionAlgorithms.dropSelection(editor);
        }
    }
}

