/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.preferences;

import de.jave.ascii.IAsciiGuiConstants;
import de.jave.gui.io.FileChooserUtilities;
import de.jave.jave.preferences.BooleanPreferenceModel;
import de.jave.jave.preferences.ColorScheme;
import de.jave.preferences.JavePreferences;
import de.jave.preferences.SmartPreferences;
import de.jave.util.RecentFileList;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import net.disy.commons.core.io.FileModel;
import net.disy.commons.core.model.BooleanModel;
import net.disy.commons.core.model.ObjectModel;
import net.disy.commons.core.model.listener.IChangeListener;
import net.disy.commons.swing.fontchooser.model.FontModel;

public class JaveApplicationPreferences
extends SmartPreferences {
    private static final String KEY_CLIPART_GROUP_NAME = "clipartGroupName";
    private static final String KEY_USE_AWT_FILECHOOSER = "useAwtFileChooser";
    private static final String KEY_FONT = "font";
    private static final String KEY_COLOR_SCHEME = "colorscheme";
    private static final String KEY_FRAME_HEIGHT = "frameHeight";
    private static final String KEY_FRAME_WIDTH = "frameWidth";
    private static final String KEY_FRAME_Y = "frameY";
    private static final String KEY_FRAME_X = "frameX";
    private static final String KEY_FRAME_STATE = "frameState";
    private static final String KEY_TOOL_DIALOG_LOCATION_X = "toolDialogLocationX";
    private static final String KEY_TOOL_DIALOG_LOCATION_Y = "toolDialogLocationY";
    private static final String KEY_ANIMATION_WIDTH = "animationWidth";
    private static final String KEY_ANIMATION_HEIGHT = "animationHeight";
    private static final String KEY_DOCUMENT_WIDTH = "documentWidth";
    private static final String KEY_DOCUMENT_HEIGHT = "documentHeight";
    private static final String KEY_CURRENT_DIRECTORY = "currentDirectory";
    private static final String KEY_AUTHOR_MAIL = "authorMail";
    private static final String KEY_AUTHOR_NAME = "authorName";
    private static final String KEY_CURSOR_BLOCK_STYLE = "cursorBlockStyle";
    private static final String KEY_SHOW_QUICK_START_ON_STARTUP = "showQuickStartOnStartup";
    private static final boolean DEFAULT_USE_AWT_FILECHOOSER = false;
    private static final int DEFAULT_FRAME_X = 0;
    private static final int DEFAULT_FRAME_Y = 10;
    private static final int DEFAULT_FRAME_WIDTH = 787;
    private static final int DEFAULT_FRAME_HEIGHT = 537;
    private static final int DEFAULT_OPTIONS_LOCATION_X = 600;
    private static final int DEFAULT_OPTIONS_LOCATION_Y = 90;
    private static final int DEFAULT_DOCUMENT_HEIGHT = 30;
    private static final int DEFAULT_DOCUMENT_WIDTH = 71;
    private static final int DEFAULT_ANIMATION_HEIGHT = 30;
    private static final int DEFAULT_ANIMATION_WIDTH = 71;
    private static final int DEFAULT_DISPLAY_FONT_STYLE = 0;
    private static final int DEFAULT_DISPLAY_FONT_SIZE = 13;
    private static final boolean DEFAULT_SHOW_QUICK_START_ON_STARTUP = true;
    private static final String DEFAULT_DISPLAY_FONT_NAME = IAsciiGuiConstants.DEFAULT_ASCII_FONT.getName();
    private static final int DEFAULT_FRAME_STATE = 0;
    private final RecentFileList recentFileList = new RecentFileList(new SmartPreferences(this.getSubPreferences("recentFiles")));
    private final FileModel currentDirectoryModel;
    private final BooleanPreferenceModel cursorBlockStyleModel;
    private final FontModel displayFontModel;
    private final ObjectModel<ColorScheme> defaultColorSchemeModel;
    private final BooleanModel useAwtFileChooserModel = new BooleanModel(this.getBoolean("useAwtFileChooser", false));

    public JaveApplicationPreferences(JavePreferences javePreferences) {
        super(javePreferences.getSubPreferences("application"));
        this.useAwtFileChooserModel.addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                boolean value = JaveApplicationPreferences.this.useAwtFileChooserModel.getValue();
                JaveApplicationPreferences.this.putBoolean(JaveApplicationPreferences.KEY_USE_AWT_FILECHOOSER, value);
                JaveApplicationPreferences.this.flush();
                FileChooserUtilities.useAwtFileChooser = value;
            }
        });
        FileChooserUtilities.useAwtFileChooser = this.useAwtFileChooserModel.getValue();
        this.currentDirectoryModel = new FileModel();
        String directory = this.get(KEY_CURRENT_DIRECTORY, null);
        if (directory != null) {
            this.currentDirectoryModel.setValue(new File(directory));
        }
        this.currentDirectoryModel.addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                File currentDirectory = (File)JaveApplicationPreferences.this.currentDirectoryModel.getValue();
                JaveApplicationPreferences.this.put(JaveApplicationPreferences.KEY_CURRENT_DIRECTORY, currentDirectory);
                JaveApplicationPreferences.this.flush();
            }
        });
        this.cursorBlockStyleModel = new BooleanPreferenceModel(this, KEY_CURSOR_BLOCK_STYLE, false);
        this.displayFontModel = new FontModel(this.getFont(KEY_FONT));
        this.displayFontModel.addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                JaveApplicationPreferences.this.putFont(JaveApplicationPreferences.KEY_FONT, JaveApplicationPreferences.this.displayFontModel.getFont());
                JaveApplicationPreferences.this.flush();
            }
        });
        ColorScheme colorScheme = ColorScheme.getById(this.get(KEY_COLOR_SCHEME, ColorScheme.BLACK_ON_WHITE.getId()));
        this.defaultColorSchemeModel = new ObjectModel<ColorScheme>(colorScheme);
        this.defaultColorSchemeModel.addChangeListener(new IChangeListener(){

            @Override
            public void stateChanged() {
                JaveApplicationPreferences.this.put(JaveApplicationPreferences.KEY_COLOR_SCHEME, ((ColorScheme)JaveApplicationPreferences.this.defaultColorSchemeModel.getValue()).getId());
                JaveApplicationPreferences.this.flush();
            }
        });
    }

    public FontModel getDisplayFontModel() {
        return this.displayFontModel;
    }

    public ObjectModel<ColorScheme> getDefaultColorSchemeModel() {
        return this.defaultColorSchemeModel;
    }

    public BooleanModel getUseAwtFileChooserModel() {
        return this.useAwtFileChooserModel;
    }

    private void putFont(String keyPrefix, Font font) {
        this.put(keyPrefix + "Name", font.getName());
        this.putInt(keyPrefix + "Size", font.getSize());
        this.putInt(keyPrefix + "Style", font.getStyle());
    }

    private Font getFont(String keyPrefix) {
        String fontName = this.get(keyPrefix + "Name", DEFAULT_DISPLAY_FONT_NAME);
        int fontSize = this.getInt(keyPrefix + "Size", 13);
        int fontStyle = this.getInt(keyPrefix + "Style", 0);
        return new Font(fontName, fontStyle, fontSize);
    }

    public Rectangle getApplicationFrameBounds() {
        int x = this.getInt(KEY_FRAME_X, 0);
        int y = this.getInt(KEY_FRAME_Y, 10);
        int w = this.getInt(KEY_FRAME_WIDTH, 787);
        int h = this.getInt(KEY_FRAME_HEIGHT, 537);
        return new Rectangle(x, y, w, h);
    }

    public Point getToolDialogLocation() {
        int x = this.getInt(KEY_TOOL_DIALOG_LOCATION_X, 600);
        int y = this.getInt(KEY_TOOL_DIALOG_LOCATION_Y, 90);
        return new Point(x, y);
    }

    public void setToolDialogLocation(Point location) {
        this.putInt(KEY_TOOL_DIALOG_LOCATION_X, location.x);
        this.putInt(KEY_TOOL_DIALOG_LOCATION_Y, location.y);
    }

    public RecentFileList getRecentFileList() {
        return this.recentFileList;
    }

    public Dimension getDefaultDocumentSize() {
        return new Dimension(this.getInt(KEY_DOCUMENT_WIDTH, 71), this.getInt(KEY_DOCUMENT_HEIGHT, 30));
    }

    public void setDefaultDocumentSize(Dimension size) {
        this.putInt(KEY_DOCUMENT_WIDTH, size.width);
        this.putInt(KEY_DOCUMENT_HEIGHT, size.height);
    }

    public Dimension getDefaultAnimationSize() {
        return new Dimension(this.getInt(KEY_ANIMATION_WIDTH, 71), this.getInt(KEY_ANIMATION_HEIGHT, 30));
    }

    public void setDefaultAnimationSize(Dimension size) {
        this.putInt(KEY_ANIMATION_WIDTH, size.width);
        this.putInt(KEY_ANIMATION_HEIGHT, size.height);
    }

    public FileModel getCurrectDirectoryModel() {
        return this.currentDirectoryModel;
    }

    public String getAuthorName() {
        return this.get(KEY_AUTHOR_NAME, "");
    }

    public void setAuthorName(String authorName) {
        this.put(KEY_AUTHOR_NAME, authorName);
    }

    public String getAuthorMail() {
        return this.get(KEY_AUTHOR_MAIL, "");
    }

    public void setAuthorMail(String authorMail) {
        this.put(KEY_AUTHOR_MAIL, authorMail);
    }

    public BooleanPreferenceModel getCursorBlockStyleModel() {
        return this.cursorBlockStyleModel;
    }

    public int getApplicationFrameState() {
        return this.getInt(KEY_FRAME_STATE, 0);
    }

    public void setApplicationFrameState(int frameState, Rectangle bounds) {
        this.putInt(KEY_FRAME_STATE, frameState);
        if (frameState != 6) {
            this.putInt(KEY_FRAME_X, bounds.x);
            this.putInt(KEY_FRAME_Y, bounds.y);
            this.putInt(KEY_FRAME_WIDTH, bounds.width);
            this.putInt(KEY_FRAME_HEIGHT, bounds.height);
        }
    }

    public boolean isShowQuickStartOnStartup() {
        return this.getBoolean(KEY_SHOW_QUICK_START_ON_STARTUP, true);
    }

    public void setShowQuickStartOnStartup(boolean value) {
        this.putBoolean(KEY_SHOW_QUICK_START_ON_STARTUP, value);
    }

    public String getClipartGroupName() {
        return this.get(KEY_CLIPART_GROUP_NAME, null);
    }

    public void setClipartGroupName(String groupName) {
        this.put(KEY_CLIPART_GROUP_NAME, groupName);
        this.flush();
    }
}

