/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.core.io;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import net.disy.commons.core.exception.UnreachableCodeReachedException;
import net.disy.commons.core.io.IFile;
import net.disy.commons.core.io.IFileSystem;
import net.disy.commons.core.io.IWorkingDirectoryProvider;
import net.disy.commons.core.io.JavaFile;
import net.disy.commons.core.io.JavaFileSystem;
import net.disy.commons.core.io.UrlUtilities;
import net.disy.commons.core.util.Ensure;

public class FileUtilities {
    private static IFileSystem fileSystem = new JavaFileSystem();

    protected FileUtilities() {
        throw new UnreachableCodeReachedException();
    }

    public static void deleteFileOrDirectory(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] files;
            for (File file2 : files = file.listFiles()) {
                FileUtilities.deleteFileOrDirectory(file2);
            }
        }
        if (!file.delete()) {
            throw new IOException("delete failed for file '" + file.getAbsolutePath() + "'");
        }
    }

    public static String getExtension(File file) {
        return FileUtilities.getExtension(file.getName());
    }

    public static String getExtension(String filename) {
        int lastDot = filename.lastIndexOf(46);
        return lastDot >= 0 ? filename.substring(lastDot + 1) : "";
    }

    public static File addExtension(File file, String extension) {
        return new File(FileUtilities.addExtension(file.getPath(), extension));
    }

    public static String addExtension(String fileName, String fileNameExtension) {
        String extension = fileNameExtension;
        if (!extension.startsWith(".")) {
            extension = "." + extension;
        }
        if (!fileName.endsWith(extension)) {
            return fileName + extension;
        }
        return fileName;
    }

    public static File createTempFile(String prefix, String postfix, File directory) throws IOException {
        JavaFile parentDirectory = directory == null ? null : new JavaFile(directory);
        return ((JavaFile)FileUtilities.createTempFile(prefix, postfix, parentDirectory)).getFile();
    }

    public static IFile createTempFile(String prefix, String postfix, IFile parentDirectory) throws IOException {
        boolean directoriesCreated;
        IFile directory = parentDirectory;
        if (directory == null) {
            directory = fileSystem.getDefaultTempDir();
        }
        if (!directory.exists() && !(directoriesCreated = directory.mkDirs())) {
            if (!directory.equals(fileSystem.getDefaultTempDir())) {
                try {
                    return FileUtilities.createTempFile(prefix, postfix, (IFile)null);
                }
                catch (IOException e) {
                    throw new IOException("Could not create full path for temporary file: " + directory + '/' + prefix + '.' + postfix);
                }
            }
            throw new IOException("Could not create temporary directory at: " + directory);
        }
        try {
            return fileSystem.createTempFile(prefix, postfix, directory);
        }
        catch (IOException exception) {
            throw new IOException("Could not create temp file in " + directory + ": " + exception.getMessage(), exception);
        }
    }

    public static void setFileSystem(IFileSystem fileSystem) {
        FileUtilities.fileSystem = fileSystem;
    }

    public static File createFileNameSuggestion(IWorkingDirectoryProvider workingDirectoryProvider, String fileName, String fileExtension) {
        Ensure.ensureArgumentNotNull(workingDirectoryProvider);
        Ensure.ensureArgumentNotNull(fileName);
        Ensure.ensureArgumentNotNull(fileExtension);
        File workingDirectory = workingDirectoryProvider.getWorkingDirectory();
        File directory = workingDirectory == null ? new File(".") : workingDirectory;
        return FileUtilities.createNonExistingFile(directory, fileName, fileExtension);
    }

    public static File createNonExistingFile(File directory, String fileName, String fileExtension) {
        Ensure.ensureArgumentNotNull(directory);
        Ensure.ensureArgumentNotNull(fileName);
        Ensure.ensureArgumentNotNull(fileExtension);
        File file = new File(directory, fileName + fileExtension);
        int index = 1;
        while (file.exists()) {
            file = new File(directory, fileName + index + fileExtension);
            ++index;
        }
        return file;
    }

    @Deprecated
    public static boolean isReadable(URL url) {
        return UrlUtilities.isAccessible(url);
    }

    public static File getTempDir() {
        return fileSystem.getDefaultTempDir().getFile();
    }

    public static void createFileParent(String fileName) throws IOException {
        FileUtilities.createFileParent(new File(fileName));
    }

    private static void createFileParent(File file) throws IOException {
        File canonicalFile = file.getCanonicalFile();
        File parent = canonicalFile.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
    }

    public static File getWithoutExtension(File file) {
        String fileName = file.getName();
        if (!fileName.contains(".")) {
            return file;
        }
        File parentFile = file.getParentFile();
        return new File(parentFile, fileName.substring(0, fileName.lastIndexOf(".")));
    }

    public static boolean isReadable(File file) {
        return file != null && file.canRead();
    }
}

