/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.core.io;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import net.disy.commons.core.io.FileUtilities;
import net.disy.commons.core.io.UrlUtilities;
import net.disy.commons.core.util.Ensure;

public class UriUtilities {
    public static boolean isFile(URI uri) {
        try {
            return uri != null && new File(uri) != null;
        }
        catch (IllegalArgumentException exception) {
            return false;
        }
    }

    public static URI getWithoutExtension(URI uri) throws URISyntaxException {
        File pathFile = FileUtilities.getWithoutExtension(new File(uri.getPath()));
        String path = pathFile == null ? "" : pathFile.getAbsolutePath();
        if (!(path = path.replaceAll("\\\\", "/")).startsWith("/")) {
            path = "/".concat(path);
        }
        return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), path, uri.getQuery(), uri.getFragment());
    }

    public static boolean isAccessible(URI uri) {
        Ensure.ensureArgumentNotNull(uri);
        try {
            if (UriUtilities.isFile(uri)) {
                return FileUtilities.isReadable(new File(uri));
            }
            if (uri.getScheme() == null) {
                return FileUtilities.isReadable(new File(uri.getPath()));
            }
            return UrlUtilities.isAccessible(uri.toURL());
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

