/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.core.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.disy.commons.core.predicate.IPredicate;
import net.disy.commons.core.provider.IProvider;
import net.disy.commons.core.util.ArrayUtilities;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.core.util.IClosure;
import net.disy.commons.core.util.ITransformer;
import net.disy.commons.core.util.NonNullPredicate;
import net.disy.commons.core.util.NullProvider;
import net.disy.commons.core.util.ObjectUtilities;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class CollectionUtilities {
    public static <T> void insertIntoSortedList(List<T> list, T item, Comparator<T> comparator) {
        CollectionUtilities.insertIntoSortedList(list, item, comparator, 0, list.size());
    }

    private static <T> void insertIntoSortedList(List<T> list, T item, Comparator<T> comparator, int startIndex, int endIndex) {
        if (startIndex == endIndex) {
            list.add(startIndex, item);
            return;
        }
        int middleIndex = (startIndex + endIndex) / 2;
        T middleItem = list.get(middleIndex);
        if (comparator.compare(item, middleItem) < 0) {
            CollectionUtilities.insertIntoSortedList(list, item, comparator, startIndex, middleIndex);
        } else {
            CollectionUtilities.insertIntoSortedList(list, item, comparator, middleIndex + 1, endIndex);
        }
    }

    public static <T> void forAllDo(Collection<T> collection, IClosure<T> closure) {
        Ensure.ensureArgumentNotNull(collection);
        Ensure.ensureArgumentNotNull(closure);
        for (T element : collection) {
            closure.execute(element);
        }
    }

    public static <T> void addCasted(Collection<T> valuesSet, Object object) {
        valuesSet.add(object);
    }

    public static <B> B[] toArray(Collection<B> collection, Class<B> clazz) {
        return collection.toArray((Object[])Array.newInstance(clazz, collection.size()));
    }

    public static int[] toPrimitiveArray(Collection<Integer> collection) {
        return ArrayUtilities.toPrimitive(collection.toArray(new Integer[collection.size()]));
    }

    public static double[] toPrimitiveArray(Collection<Double> collection) {
        return ArrayUtilities.toPrimitive(collection.toArray(new Double[collection.size()]));
    }

    public static <I, O> O[] toArray(Iterable<I> iterable, Class<O> clazz, ITransformer<I, O> transformer) {
        ArrayList<O> result = new ArrayList<O>();
        for (I item : iterable) {
            result.add(transformer.transform(item));
        }
        return CollectionUtilities.toArray(result, clazz);
    }

    public static <I> I[] toArray(Iterable<I> iterable, Class<I> clazz) {
        ArrayList<I> result = new ArrayList<I>();
        for (I item : iterable) {
            result.add(item);
        }
        return CollectionUtilities.toArray(result, clazz);
    }

    public static <I, O> List<O> transform(Iterable<I> input, ITransformer<? super I, ? extends O> transformer) {
        ArrayList<O> outputList = new ArrayList<O>();
        for (I inputElement : input) {
            outputList.add(transformer.transform(inputElement));
        }
        return outputList;
    }

    public static <T> boolean contains(Iterable<? extends T> iterable, IPredicate<T> predicate) {
        for (T value : iterable) {
            if (!predicate.evaluate(value)) continue;
            return true;
        }
        return false;
    }

    public static <T> T getFirst(Iterable<? extends T> iterable, IPredicate<T> predicate) {
        return CollectionUtilities.getFirst(iterable, predicate, new NullProvider());
    }

    public static <T> T getFirst(Iterable<? extends T> iterable, IPredicate<T> predicate, IProvider<T> fallback) {
        if (iterable != null && predicate != null) {
            for (T item : iterable) {
                if (!predicate.evaluate(item)) continue;
                return item;
            }
        }
        return fallback.getObject();
    }

    public static <T> List<T> filter(Iterable<? extends T> iterable, IPredicate<T> predicate) {
        ArrayList<T> values = new ArrayList<T>();
        if (iterable != null && predicate != null) {
            for (T item : iterable) {
                if (!predicate.evaluate(item)) continue;
                values.add(item);
            }
        }
        return values;
    }

    public static <T> List<T> copy(Iterable<? extends T> iterable) {
        ArrayList<T> values = new ArrayList<T>();
        if (iterable != null) {
            for (T item : iterable) {
                values.add(item);
            }
        }
        return values;
    }

    public static <T> List<T> concat(List<T> ... lists) {
        ArrayList<T> concatList = new ArrayList<T>();
        for (List<T> list : lists) {
            concatList.addAll(list);
        }
        return concatList;
    }

    public static <T extends Comparable<? super T>> T min(Iterable<? extends T> collection) {
        List<T> filteredList = CollectionUtilities.filter(collection, new NonNullPredicate());
        return (T)(filteredList.isEmpty() ? null : (Comparable)Collections.min(filteredList));
    }

    public static <T extends Comparable<? super T>> T max(Iterable<? extends T> collection) {
        List<T> filteredList = CollectionUtilities.filter(collection, new NonNullPredicate());
        return (T)(filteredList.isEmpty() ? null : (Comparable)Collections.max(filteredList));
    }

    public static String getRepresentation(Collection<?> c) {
        return ArrayUtilities.getRepresentation(c.toArray());
    }

    public static final <T> boolean equals(Collection<T> i1, Collection<T> i2) {
        return ObjectUtilities.equals(i1 == null ? null : i1.toArray(), i2 == null ? null : i2.toArray());
    }
}

