/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.dialog.userdialog;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import net.disy.commons.swing.dialog.input.IRequestFinishListener;
import net.disy.commons.swing.dialog.userdialog.IDialogConfiguration;
import net.disy.commons.swing.dialog.userdialog.IUserDialogContainer;
import net.disy.commons.swing.dialog.userdialog.buttons.DialogButtonConfigurationFactory;
import net.disy.commons.swing.dialog.userdialog.buttons.IDialogButtonConfiguration;
import net.disy.commons.swing.dialog.userdialog.page.IDialogPage;

public class DefaultDialogConfiguration<P extends IDialogPage>
implements IDialogConfiguration<P> {
    private IUserDialogContainer dialogContainer;
    private boolean headerPanelVisible = true;
    private final P dialogPage;
    private final IDialogButtonConfiguration buttonConfiguration;

    public DefaultDialogConfiguration(P dialogPage) {
        this(dialogPage, DialogButtonConfigurationFactory.createOkCancel());
    }

    public DefaultDialogConfiguration(P dialogPage, IDialogButtonConfiguration buttonConfiguration) {
        this.dialogPage = dialogPage;
        this.buttonConfiguration = buttonConfiguration;
    }

    @Override
    public P getDialogPage() {
        return this.dialogPage;
    }

    @Override
    public void setUserDialogContainer(final IUserDialogContainer dialogContainer) {
        this.dialogContainer = dialogContainer;
        this.dialogPage.addRequestFinishListener(new IRequestFinishListener(){

            @Override
            public void requestFinish() {
                dialogContainer.requestFinish();
            }
        });
    }

    protected IUserDialogContainer getDialogContainer() {
        return this.dialogContainer;
    }

    @Override
    public JComponent[] createAdditionalButtons() {
        return new JComponent[0];
    }

    @Override
    public JComponent createOptionalButtonPanelLeftComponent() {
        return null;
    }

    @Override
    public boolean performOk(Component parentComponent) {
        return true;
    }

    @Override
    public boolean performCancel(Component parentComponent) {
        return true;
    }

    @Override
    public boolean isHeaderPanelVisible() {
        return this.headerPanelVisible;
    }

    public void setHeaderPanelVisible(boolean headerPanelVisible) {
        this.headerPanelVisible = headerPanelVisible;
    }

    @Override
    public IDialogButtonConfiguration getButtonConfiguration() {
        return this.buttonConfiguration;
    }

    @Override
    public void performAfterDispose(boolean canceled) {
    }

    @Override
    public Icon getLargeDialogIcon() {
        return null;
    }
}

