/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.dialog.wizard;

import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.action.ActionConfiguration;
import net.disy.commons.swing.action.IActionConfiguration;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.dialog.BasicDialogResources;
import net.disy.commons.swing.dialog.core.AbstractDialog;
import net.disy.commons.swing.dialog.core.DialogResult;
import net.disy.commons.swing.dialog.core.IDeprecatedGenericDialogConfiguration;
import net.disy.commons.swing.dialog.core.IDialogConstants;
import net.disy.commons.swing.dialog.core.IDialogResult;
import net.disy.commons.swing.dialog.core.IGenericDialogConfiguration;
import net.disy.commons.swing.dialog.core.ISwingFrameOrDialog;
import net.disy.commons.swing.dialog.input.IRequestFinishListener;
import net.disy.commons.swing.dialog.userdialog.buttons.IDialogButtonConfiguration;
import net.disy.commons.swing.dialog.wizard.IBasicWizardConfiguration;
import net.disy.commons.swing.dialog.wizard.IBasicWizardPage;
import net.disy.commons.swing.dialog.wizard.IWizardConfiguration;
import net.disy.commons.swing.dialog.wizard.IWizardContainer;
import net.disy.commons.swing.layout.util.ButtonPanelBuilder;
import net.disy.commons.swing.util.GuiUtilities;

public class WizardDialog
extends AbstractDialog
implements IWizardContainer,
IDialogConstants {
    public static final String FINISH_BUTTON_NAME = "WizardDialog.FinishButton.ComponentName";
    private JButton finishButton;
    private JButton backButton;
    private JButton nextButton;
    private JButton helpButton;
    private IBasicWizardPage currentPage;
    private final IBasicWizardConfiguration wizard;
    private final Collection<IBasicWizardPage> pages = new HashSet<IBasicWizardPage>();
    private final IRequestFinishListener requestFinishListener = new IRequestFinishListener(){

        @Override
        public void requestFinish() {
            if (WizardDialog.this.nextButton != null && WizardDialog.this.nextButton.isEnabled()) {
                WizardDialog.this.nextButton.doClick();
                return;
            }
            if (WizardDialog.this.finishButton != null && WizardDialog.this.finishButton.isEnabled()) {
                WizardDialog.this.finishButton.doClick();
            }
        }
    };
    private JButton cancelButton;

    public WizardDialog(Component parent, IBasicWizardConfiguration wizard) {
        super(parent, wizard);
        this.wizard = wizard;
        wizard.setContainer(this);
        if (wizard instanceof IWizardConfiguration) {
            ((IWizardConfiguration)wizard).addPages();
        }
        this.initialize();
    }

    @Override
    protected JComponent createButtonBar() {
        SmartAction backAction = new SmartAction(BasicDialogResources.WIZARD_BACK_SMART){

            @Override
            protected void execute(Component parentComponent) {
                WizardDialog.this.backPressed();
            }
        };
        this.backButton = new JButton(backAction);
        SmartAction nextAction = new SmartAction(BasicDialogResources.WIZARD_NEXT_SMART){

            @Override
            protected void execute(Component parentComponent) {
                WizardDialog.this.nextPressed();
            }
        };
        this.nextButton = new JButton(nextAction);
        JPanel compactedButtons = new JPanel(new GridLayout(1, 0, 0, 0));
        compactedButtons.add(this.backButton);
        compactedButtons.add(this.nextButton);
        IDialogButtonConfiguration buttonConfiguration = this.getWizard().getButtonConfiguration();
        IActionConfiguration okActionConfiguration = buttonConfiguration.getOkActionConfiguration();
        SmartAction finishAction = new SmartAction(okActionConfiguration != null ? okActionConfiguration : new ActionConfiguration()){

            @Override
            protected void execute(Component parentComponent) {
                WizardDialog.this.performFinish(parentComponent);
            }
        };
        this.finishButton = new JButton(finishAction);
        this.finishButton.setName(FINISH_BUTTON_NAME);
        IActionConfiguration cancelActionConfiguration = buttonConfiguration.getCancelActionConfiguration();
        SmartAction cancelAction = new SmartAction(cancelActionConfiguration != null ? cancelActionConfiguration : new ActionConfiguration()){

            @Override
            protected void execute(Component parentComponent) {
                WizardDialog.this.performCancel();
            }
        };
        this.cancelButton = new JButton(cancelAction);
        SmartAction helpAction = new SmartAction(BasicDialogResources.HELP_TEXT_SMART){

            @Override
            protected void execute(Component parentComponent) {
                WizardDialog.this.helpPressed();
            }
        };
        this.helpButton = new JButton(helpAction);
        ArrayList<JComponent> buttonList = new ArrayList<JComponent>();
        buttonList.add(compactedButtons);
        JButton[] additionalButtons = this.createAdditionalButtons();
        buttonList.addAll(Arrays.asList(additionalButtons));
        if (okActionConfiguration != null) {
            buttonList.add(this.finishButton);
        }
        if (cancelActionConfiguration != null) {
            buttonList.add(this.cancelButton);
        }
        if (this.getWizard().isHelpAvailable()) {
            buttonList.add(this.helpButton);
        }
        ButtonPanelBuilder buttonPanelBuilder = new ButtonPanelBuilder();
        for (int i = 0; i < buttonList.size(); ++i) {
            buttonPanelBuilder.add((Component)buttonList.get(i));
        }
        return buttonPanelBuilder.createPanel();
    }

    private JButton[] createAdditionalButtons() {
        return new JButton[0];
    }

    protected final void backPressed() {
        this.showPage(this.getCurrentPage().getPreviousPage());
    }

    @Override
    protected final boolean cancelPressed() {
        if (this.wizard instanceof IDeprecatedGenericDialogConfiguration) {
            return ((IDeprecatedGenericDialogConfiguration)((Object)this.wizard)).performCancel(this.getDialog().getWindow());
        }
        return true;
    }

    protected final boolean finishPressed(Component parentComponent) {
        this.currentPage.getNextPage();
        this.currentPage.leave();
        if (this.wizard instanceof IWizardConfiguration) {
            return ((IWizardConfiguration)this.wizard).performFinish(parentComponent);
        }
        return true;
    }

    protected void helpPressed() {
        this.getCurrentPage().performHelp();
    }

    protected void nextPressed() {
        this.showPage(this.getCurrentPage().getNextPage());
    }

    @Override
    public void showPage(IBasicWizardPage page) {
        Ensure.ensureArgumentNotNull(page);
        if (this.currentPage != null) {
            this.currentPage.leave();
            this.currentPage.removeRequestFinishListener(this.requestFinishListener);
        }
        page.addRequestFinishListener(this.requestFinishListener);
        this.currentPage = page;
        this.pages.add(page);
        this.updateContent();
        this.updateMessage();
        this.updateDescription();
        this.updateButtons();
        this.updateTitle();
        this.updateSize();
        this.currentPage.enter();
        this.currentPage.getPageContent().requestFocus();
    }

    protected void updateContent() {
        this.setContent(this.getCurrentPage().getPageContent().getContent());
    }

    @Override
    public IBasicWizardPage getCurrentPage() {
        return this.currentPage;
    }

    protected void setCurrentPage(IBasicWizardPage page) {
        this.currentPage = page;
    }

    @Override
    public void updateButtons() {
        IBasicWizardPage page = this.getCurrentPage();
        this.nextButton.setEnabled(page.canFlipToNextPage());
        this.backButton.setEnabled(page.getPreviousPage() != null);
        this.finishButton.setEnabled(this.getWizard().canFinish());
        this.cancelButton.setEnabled(this.getWizard().canCancel());
        this.helpButton.setVisible(this.getWizard().isHelpAvailable());
        this.helpButton.setEnabled(page.isHelpAvailable());
        if (this.finishButton.isEnabled()) {
            this.setDefaultButton(this.finishButton);
        } else {
            this.setDefaultButton(this.nextButton);
        }
    }

    @Override
    public void updateMessage() {
        this.setMessage(this.getCurrentPage().getMessage());
    }

    @Override
    public void updateDescription() {
        this.setDescription(this.getCurrentPage().getDescription());
    }

    @Override
    public void updateTitle() {
        this.setTitle(this.getCurrentPage().getTitle());
    }

    @Override
    public IDialogResult show() {
        ISwingFrameOrDialog configuredDialog = this.getConfiguredDialog();
        GuiUtilities.centerToParent(configuredDialog.getWindow());
        configuredDialog.show();
        return new DialogResult(this.isCanceled());
    }

    public ISwingFrameOrDialog getConfiguredDialog() {
        IBasicWizardPage startingPage = this.getWizard().getStartingPage();
        if (startingPage == null) {
            throw new RuntimeException("Starting page may not be null in IWizard.getStartingPage()");
        }
        this.showPage(startingPage);
        ISwingFrameOrDialog configuredDialog = this.getDialog();
        if (configuredDialog == null) {
            throw new IllegalStateException("WizardDialog is already disposed and may not be shown more often than once");
        }
        if (configuredDialog.isVisible()) {
            throw new IllegalStateException("WizardDialog is already visible");
        }
        return configuredDialog;
    }

    protected IBasicWizardConfiguration getWizard() {
        return this.wizard;
    }

    private final void performFinish(Component parentComponent) {
        if (this.finishPressed(parentComponent)) {
            this.closeDialog();
            IGenericDialogConfiguration finishedDialog = this.getGenericDialog();
            if (finishedDialog instanceof IDeprecatedGenericDialogConfiguration) {
                ((IDeprecatedGenericDialogConfiguration)finishedDialog).performAfterDispose(false);
            }
        }
    }

    @Override
    public final void requestFinish() {
        this.performFinish(this.getDialog().getWindow());
    }

    @Override
    public final void requestNext() {
        if (!this.getCurrentPage().canFlipToNextPage()) {
            return;
        }
        this.nextPressed();
    }

    @Override
    protected void closeDialog() {
        super.closeDialog();
        this.currentPage.leave();
        for (IBasicWizardPage page : this.pages) {
            page.getPageContent().dispose();
        }
    }
}

