/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.fontchooser.model;

import java.awt.Font;
import net.disy.commons.core.model.AbstractChangeableModel;
import net.disy.commons.core.text.font.FontDescription;
import net.disy.commons.core.text.font.FontStyle;
import net.disy.commons.core.util.ObjectUtilities;
import net.disy.commons.swing.font.FontFactory;
import net.disy.commons.swing.fontchooser.util.FontUtilities;

public class FontModel
extends AbstractChangeableModel {
    public static final int MAX_FONT_SIZE = 200;
    public static final int MIN_FONT_SIZE = 2;
    private FontDescription font;

    public FontModel() {
        this(FontUtilities.getDefaultFont());
    }

    public FontModel(Font font) {
        this.setFont(font);
    }

    public FontModel(FontDescription font) {
        this.setFont(font);
    }

    public void setFont(Font font) {
        this.setFont(FontFactory.createFontDescription(font));
    }

    public void setFont(FontDescription fontDescription) {
        this.font = fontDescription;
        this.fireChangeEvent();
    }

    public String getFontFamilyName() {
        return this.font.getFontFamilyName();
    }

    public int getFontSize() {
        return this.font.getFontSize();
    }

    public FontStyle getFontStyle() {
        return this.font.getFontStyle();
    }

    public void setFontFamilyName(String fontFamilyName) {
        if (ObjectUtilities.equals(this.font.getFontFamilyName(), fontFamilyName)) {
            return;
        }
        this.font.setFontFamilyName(fontFamilyName);
        this.fireChangeEvent();
    }

    public void setFontSize(int fontSize) {
        if (!FontUtilities.isValidFontSize(fontSize)) {
            throw new IllegalArgumentException("Illegal value '" + fontSize + "' for font size. Valid values are " + 2 + ".." + 200);
        }
        if (this.font.getFontSize() == fontSize) {
            return;
        }
        this.font.setFontSize(fontSize);
        this.fireChangeEvent();
    }

    public void setFontStyle(FontStyle fontStyle) {
        if (ObjectUtilities.equals((Object)this.font.getFontStyle(), (Object)fontStyle)) {
            return;
        }
        this.font.setFontStyle(fontStyle);
        this.fireChangeEvent();
    }

    public Font getFont() {
        return FontModel.createFont(this.font);
    }

    public FontDescription getFontDescription() {
        return this.font;
    }

    public static Font createFont(FontDescription fontDescription) {
        return FontFactory.createFont(fontDescription.getFontFamilyName(), fontDescription.getFontStyle(), fontDescription.getFontSize());
    }
}

