/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.panel.AbstractVerticalScrollablePanel;

public class VerticalScrollableComponentPanel
extends AbstractVerticalScrollablePanel {
    public VerticalScrollableComponentPanel(int preferredViewPortHeight) {
        super((LayoutManager)new GridDialogLayout(1, false), preferredViewPortHeight);
    }

    @Override
    protected int getVerticalScrollabelUnitIncrement(Rectangle visibleRect, int direction) {
        if (direction > 0) {
            Component component = this.getNextComponentToShow(visibleRect);
            return component.getY() + component.getHeight() - (visibleRect.y + visibleRect.height);
        }
        Component component = this.getPreviousComponentToShow(visibleRect);
        return visibleRect.y - component.getY();
    }

    private Component getNextComponentToShow(Rectangle visibleRect) {
        Component component;
        int componentIndex;
        for (componentIndex = 0; componentIndex < this.getComponentCount() && (component = this.getComponent(componentIndex)).getY() < visibleRect.y; ++componentIndex) {
        }
        while (componentIndex < this.getComponentCount() && (component = this.getComponent(componentIndex)).getY() + component.getHeight() <= visibleRect.y + visibleRect.height) {
            ++componentIndex;
        }
        if (componentIndex >= this.getComponentCount()) {
            componentIndex = this.getComponentCount() - 1;
        }
        return this.getComponent(componentIndex);
    }

    private Component getPreviousComponentToShow(Rectangle visibleRect) {
        Component component;
        int componentIndex;
        for (componentIndex = this.getComponentCount() - 1; componentIndex >= 0 && (component = this.getComponent(componentIndex)).getY() + component.getHeight() > visibleRect.y + visibleRect.height; --componentIndex) {
        }
        while (componentIndex >= 0 && (component = this.getComponent(componentIndex)).getY() >= visibleRect.y) {
            --componentIndex;
        }
        if (componentIndex < 0) {
            componentIndex = 0;
        }
        return this.getComponent(componentIndex);
    }
}

