/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.tree;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.tree.TreePath;
import net.disy.commons.core.model.listener.ListenerList;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.action.ActionGroupMenuBuilder;
import net.disy.commons.swing.action.GroupedMenuItem;
import net.disy.commons.swing.component.IComponentContainer;
import net.disy.commons.swing.tree.EnhancedJTree;
import net.disy.commons.swing.tree.ISmartTree;
import net.disy.commons.swing.tree.ISmartTreeActionFactory;
import net.disy.commons.swing.tree.ISmartTreeAddition;
import net.disy.commons.swing.tree.ITreeNodeActionListener;
import net.disy.commons.swing.tree.SmartTreeModel;
import net.disy.commons.swing.tree.SmartTreeModelNode;
import net.disy.commons.swing.tree.SmartTreeSelectionModel;
import net.disy.commons.swing.tree.TreeDoubleClickMouseActionListener;
import net.disy.commons.swing.tree.TreeSelectionMode;
import net.disy.commons.swing.ui.IObjectUi;

public class SmartTreeComponent<T>
implements IComponentContainer {
    private final ListenerList<ITreeNodeActionListener<T>> nodeActionListeners = new ListenerList();
    private final JComponent content;
    private final EnhancedJTree<T> tree;
    private final SmartTreeSelectionModel<T> selectionModel;
    private final List<ISmartTreeActionFactory<T>> actionFactories = new ArrayList<ISmartTreeActionFactory<T>>();
    private ISmartTree<T> smartTree;

    public SmartTreeComponent(ISmartTree<T> smartTree, IObjectUi<T> objectUi) {
        this.smartTree = smartTree;
        Ensure.ensureArgumentNotNull(smartTree);
        Ensure.ensureArgumentNotNull(objectUi);
        this.tree = new EnhancedJTree<T>(smartTree, objectUi);
        this.tree.addMouseListener(new TreeDoubleClickMouseActionListener<T>(this.nodeActionListeners));
        this.content = new JScrollPane(this.tree);
        this.selectionModel = new SmartTreeSelectionModel<T>(this.tree.getSelectionModel(), this.tree.getSmartTreeModel());
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent event) {
                if (event.isMetaDown()) {
                    SmartTreeComponent.this.showContextMenu(event);
                }
            }
        });
    }

    private void showContextMenu(MouseEvent event) {
        T[] selectionPath = this.getSelectionModel().getSelectionPath();
        if (selectionPath == null) {
            return;
        }
        ActionGroupMenuBuilder menuBuilder = new ActionGroupMenuBuilder();
        for (ISmartTreeActionFactory<T> actionFactory : this.actionFactories) {
            GroupedMenuItem menuItem = actionFactory.createMenuItem(selectionPath);
            if (menuItem == null) continue;
            menuBuilder.add(menuItem);
        }
        if (menuBuilder.isEmpty()) {
            return;
        }
        JPopupMenu contextMenu = menuBuilder.createPopupMenu();
        this.tree.add(contextMenu);
        contextMenu.show(this.tree, event.getX(), event.getY());
    }

    public ISmartTree<T> getSmartTree() {
        return this.smartTree;
    }

    @Override
    public JComponent getContent() {
        return this.content;
    }

    public final void addNodeActionListener(ITreeNodeActionListener<T> listener) {
        this.nodeActionListeners.add(listener);
    }

    public final void removeNodeActionListener(ITreeNodeActionListener<T> listener) {
        this.nodeActionListeners.add(listener);
    }

    public void setRootVisible(boolean visible) {
        this.tree.setRootVisible(visible);
    }

    public void setSmartTree(ISmartTree<T> smartTree) {
        this.smartTree = smartTree;
        this.tree.setModel(new SmartTreeModel<T>(smartTree));
    }

    public SmartTreeSelectionModel<T> getSelectionModel() {
        return this.selectionModel;
    }

    public void expandPath(T[] path) {
        this.tree.expandPath(new TreePath(this.tree.getSmartTreeModel().getPathInModel(path)));
    }

    public void addActionFactory(ISmartTreeActionFactory<T> actionFactory) {
        this.actionFactories.add(actionFactory);
    }

    public void applyAddition(ISmartTreeAddition<T> addition) {
        addition.applyTo(this, this.tree);
    }

    public void setSelectionMode(TreeSelectionMode selectionMode) {
        this.tree.getSelectionModel().setSelectionMode(selectionMode.getTreeSelectionMode());
    }

    public void nodeInserted(T[] nodePath) {
        SmartTreeModel<T> smartTreeModel = this.tree.getSmartTreeModel();
        SmartTreeModelNode<T>[] pathInModel = smartTreeModel.getPathInModel(nodePath);
        smartTreeModel.nodeWasInserted(pathInModel[pathInModel.length - 2], this.smartTree.getIndexOfChild(nodePath[nodePath.length - 2], nodePath[nodePath.length - 1]));
    }

    public void startEditing(T[] path) {
        this.tree.startEditingAtPath(new TreePath(this.tree.getSmartTreeModel().getPathInModel(path)));
    }
}

