/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.widgets.internal;

import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.widgets.internal.TextPosition;

public class TextSelection {
    private final TextPosition endPosition;
    private final TextPosition startPosition;

    public static TextSelection createSelection(TextPosition position1, TextPosition position2) {
        Ensure.ensureArgumentNotNull(position1);
        Ensure.ensureArgumentNotNull(position2);
        if (position1.getBlockIndex() < position2.getBlockIndex()) {
            return new TextSelection(position1, position2);
        }
        if (position1.getBlockIndex() == position2.getBlockIndex() && position1.getIndexInBlock() <= position2.getIndexInBlock()) {
            return new TextSelection(position1, position2);
        }
        return new TextSelection(position2, position1);
    }

    private TextSelection(TextPosition startPosition, TextPosition endPosition) {
        Ensure.ensureArgumentNotNull(startPosition);
        Ensure.ensureArgumentNotNull(endPosition);
        this.startPosition = startPosition;
        this.endPosition = endPosition;
    }

    public TextPosition getStartPosition() {
        return this.startPosition;
    }

    public TextPosition getEndPosition() {
        return this.endPosition;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextSelection)) {
            return false;
        }
        TextSelection other = (TextSelection)obj;
        return this.startPosition.equals(other.startPosition) && this.endPosition.equals(other.endPosition);
    }
}

